/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.dependency.cgg.internal.sql;

import java.io.IOException;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.nudge.dependency.cgg.Gson;
import org.nudge.dependency.cgg.JsonSyntaxException;
import org.nudge.dependency.cgg.TypeAdapter;
import org.nudge.dependency.cgg.TypeAdapterFactory;
import org.nudge.dependency.cgg.reflect.TypeToken;
import org.nudge.dependency.cgg.stream.JsonReader;
import org.nudge.dependency.cgg.stream.JsonToken;
import org.nudge.dependency.cgg.stream.JsonWriter;

final class SqlDateTypeAdapter
extends TypeAdapter<Date> {
    static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Date.class ? new SqlDateTypeAdapter() : null;
        }
    };
    private final DateFormat format = new SimpleDateFormat("MMM d, yyyy");

    private SqlDateTypeAdapter() {
    }

    @Override
    public synchronized Date read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        try {
            long utilDate = this.format.parse(in.nextString()).getTime();
            return new Date(utilDate);
        }
        catch (ParseException e) {
            throw new JsonSyntaxException(e);
        }
    }

    @Override
    public synchronized void write(JsonWriter out, Date value) throws IOException {
        out.value(value == null ? null : this.format.format(value));
    }
}

