/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.dependency.cgg.internal.sql;

import java.io.IOException;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.nudge.dependency.cgg.Gson;
import org.nudge.dependency.cgg.JsonSyntaxException;
import org.nudge.dependency.cgg.TypeAdapter;
import org.nudge.dependency.cgg.TypeAdapterFactory;
import org.nudge.dependency.cgg.reflect.TypeToken;
import org.nudge.dependency.cgg.stream.JsonReader;
import org.nudge.dependency.cgg.stream.JsonToken;
import org.nudge.dependency.cgg.stream.JsonWriter;

final class SqlTimeTypeAdapter
extends TypeAdapter<Time> {
    static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Time.class ? new SqlTimeTypeAdapter() : null;
        }
    };
    private final DateFormat format = new SimpleDateFormat("hh:mm:ss a");

    private SqlTimeTypeAdapter() {
    }

    @Override
    public synchronized Time read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        try {
            Date date = this.format.parse(in.nextString());
            return new Time(date.getTime());
        }
        catch (ParseException e) {
            throw new JsonSyntaxException(e);
        }
    }

    @Override
    public synchronized void write(JsonWriter out, Time value) throws IOException {
        out.value(value == null ? null : this.format.format(value));
    }
}

