/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.dependency.nj.lz4;

import java.lang.reflect.Field;
import org.nudge.dependency.nj.lz4.LZ4Compressor;
import org.nudge.dependency.nj.util.Native;

public final class LZ4Factory {
    private static LZ4Factory NATIVE_INSTANCE;
    private static LZ4Factory JAVA_UNSAFE_INSTANCE;
    private static LZ4Factory JAVA_SAFE_INSTANCE;
    private final String impl;
    private final LZ4Compressor fastCompressor;
    private final LZ4Compressor highCompressor;

    private static LZ4Factory instance(String impl) {
        try {
            return new LZ4Factory(impl);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public static synchronized LZ4Factory nativeInstance() {
        if (NATIVE_INSTANCE == null) {
            NATIVE_INSTANCE = LZ4Factory.instance("JNI");
        }
        return NATIVE_INSTANCE;
    }

    public static synchronized LZ4Factory safeInstance() {
        if (JAVA_SAFE_INSTANCE == null) {
            JAVA_SAFE_INSTANCE = LZ4Factory.instance("JavaSafe");
        }
        return JAVA_SAFE_INSTANCE;
    }

    public static synchronized LZ4Factory unsafeInstance() {
        if (JAVA_UNSAFE_INSTANCE == null) {
            JAVA_UNSAFE_INSTANCE = LZ4Factory.instance("JavaUnsafe");
        }
        return JAVA_UNSAFE_INSTANCE;
    }

    public static LZ4Factory fastestJavaInstance() {
        try {
            return LZ4Factory.unsafeInstance();
        }
        catch (Throwable t) {
            return LZ4Factory.safeInstance();
        }
    }

    public static LZ4Factory fastestInstance() {
        if (Native.isLoaded() || Native.class.getClassLoader() == ClassLoader.getSystemClassLoader()) {
            try {
                return LZ4Factory.nativeInstance();
            }
            catch (Throwable t) {
                return LZ4Factory.fastestJavaInstance();
            }
        }
        return LZ4Factory.fastestJavaInstance();
    }

    private static <T> T classInstance(String cls) throws NoSuchFieldException, SecurityException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        Class<?> c = Class.forName(cls);
        Field f = c.getField("INSTANCE");
        return (T)f.get(null);
    }

    private LZ4Factory(String impl) throws ClassNotFoundException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        this.impl = impl;
        this.fastCompressor = (LZ4Compressor)LZ4Factory.classInstance("org.nudge.dependency.nj.lz4.LZ4" + impl + "Compressor");
        this.highCompressor = (LZ4Compressor)LZ4Factory.classInstance("org.nudge.dependency.nj.lz4.LZ4HC" + impl + "Compressor");
    }

    public LZ4Compressor fastCompressor() {
        return this.fastCompressor;
    }

    public LZ4Compressor highCompressor() {
        return this.highCompressor;
    }

    public static void main(String[] args) {
        System.out.println("Fastest instance is " + LZ4Factory.fastestInstance());
        System.out.println("Fastest Java instance is " + LZ4Factory.fastestJavaInstance());
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.impl;
    }
}

