/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.dependency.oah5.client5.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.nudge.dependency.oah5.client5.http.DnsResolver;

public class SystemDefaultDnsResolver
implements DnsResolver {
    public static final SystemDefaultDnsResolver INSTANCE = new SystemDefaultDnsResolver();

    @Override
    public InetAddress[] resolve(String host) throws UnknownHostException {
        try {
            return InetAddress.getAllByName(host);
        }
        catch (UnknownHostException e) {
            int i;
            String strippedHost = null;
            if (host.charAt(0) == '[' && (i = host.lastIndexOf(37)) != -1) {
                strippedHost = host.substring(0, i) + "]";
            }
            if (strippedHost != null) {
                return InetAddress.getAllByName(strippedHost);
            }
            throw e;
        }
    }

    @Override
    public String resolveCanonicalHostname(String host) throws UnknownHostException {
        if (host == null) {
            return null;
        }
        InetAddress in = InetAddress.getByName(host);
        String canonicalServer = in.getCanonicalHostName();
        if (in.getHostAddress().contentEquals(canonicalServer)) {
            return host;
        }
        return canonicalServer;
    }
}

