/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.dependency.oah5.client5.http.impl.async;

import java.io.Closeable;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.nudge.dependency.oah5.client5.http.HttpRoute;
import org.nudge.dependency.oah5.client5.http.async.AsyncExecRuntime;
import org.nudge.dependency.oah5.client5.http.auth.AuthSchemeFactory;
import org.nudge.dependency.oah5.client5.http.auth.CredentialsProvider;
import org.nudge.dependency.oah5.client5.http.config.RequestConfig;
import org.nudge.dependency.oah5.client5.http.cookie.CookieSpecFactory;
import org.nudge.dependency.oah5.client5.http.cookie.CookieStore;
import org.nudge.dependency.oah5.client5.http.impl.async.AsyncExecChainElement;
import org.nudge.dependency.oah5.client5.http.impl.async.AsyncPushConsumerRegistry;
import org.nudge.dependency.oah5.client5.http.impl.async.InternalAbstractHttpAsyncClient;
import org.nudge.dependency.oah5.client5.http.impl.async.InternalH2AsyncExecRuntime;
import org.nudge.dependency.oah5.client5.http.impl.async.InternalH2ConnPool;
import org.nudge.dependency.oah5.client5.http.protocol.HttpClientContext;
import org.nudge.dependency.oah5.client5.http.routing.HttpRoutePlanner;
import org.nudge.dependency.oah5.core5.annotation.Contract;
import org.nudge.dependency.oah5.core5.annotation.Internal;
import org.nudge.dependency.oah5.core5.annotation.ThreadingBehavior;
import org.nudge.dependency.oah5.core5.http.HttpException;
import org.nudge.dependency.oah5.core5.http.HttpHost;
import org.nudge.dependency.oah5.core5.http.config.Lookup;
import org.nudge.dependency.oah5.core5.http.nio.AsyncPushConsumer;
import org.nudge.dependency.oah5.core5.http.nio.HandlerFactory;
import org.nudge.dependency.oah5.core5.reactor.DefaultConnectingIOReactor;
import org.nudge.dependency.os.Logger;
import org.nudge.dependency.os.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
@Internal
public final class InternalH2AsyncClient
extends InternalAbstractHttpAsyncClient {
    private static final Logger LOG = LoggerFactory.getLogger(InternalH2AsyncClient.class);
    private final HttpRoutePlanner routePlanner;
    private final InternalH2ConnPool connPool;

    InternalH2AsyncClient(DefaultConnectingIOReactor ioReactor, AsyncExecChainElement execChain, AsyncPushConsumerRegistry pushConsumerRegistry, ThreadFactory threadFactory, InternalH2ConnPool connPool, HttpRoutePlanner routePlanner, Lookup<CookieSpecFactory> cookieSpecRegistry, Lookup<AuthSchemeFactory> authSchemeRegistry, CookieStore cookieStore, CredentialsProvider credentialsProvider, RequestConfig defaultConfig, List<Closeable> closeables) {
        super(ioReactor, pushConsumerRegistry, threadFactory, execChain, cookieSpecRegistry, authSchemeRegistry, cookieStore, credentialsProvider, defaultConfig, closeables);
        this.connPool = connPool;
        this.routePlanner = routePlanner;
    }

    @Override
    AsyncExecRuntime createAsyncExecRuntime(HandlerFactory<AsyncPushConsumer> pushHandlerFactory) {
        return new InternalH2AsyncExecRuntime(LOG, this.connPool, pushHandlerFactory);
    }

    @Override
    HttpRoute determineRoute(HttpHost httpHost, HttpClientContext clientContext) throws HttpException {
        HttpRoute route = this.routePlanner.determineRoute(httpHost, clientContext);
        if (route.isTunnelled()) {
            throw new HttpException("HTTP/2 tunneling not supported");
        }
        return route;
    }
}

