/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.dependency.oah5.client5.http.impl.auth;

import org.nudge.dependency.oah5.client5.http.SchemePortResolver;
import org.nudge.dependency.oah5.client5.http.auth.AuthCache;
import org.nudge.dependency.oah5.client5.http.auth.AuthExchange;
import org.nudge.dependency.oah5.client5.http.auth.AuthScheme;
import org.nudge.dependency.oah5.client5.http.auth.AuthStateCacheable;
import org.nudge.dependency.oah5.client5.http.impl.auth.BasicAuthCache;
import org.nudge.dependency.oah5.client5.http.protocol.HttpClientContext;
import org.nudge.dependency.oah5.core5.annotation.Contract;
import org.nudge.dependency.oah5.core5.annotation.Internal;
import org.nudge.dependency.oah5.core5.annotation.ThreadingBehavior;
import org.nudge.dependency.oah5.core5.http.HttpHost;
import org.nudge.dependency.oah5.core5.http.protocol.HttpContext;
import org.nudge.dependency.os.Logger;
import org.nudge.dependency.os.LoggerFactory;

@Internal
@Contract(threading=ThreadingBehavior.STATELESS)
public final class AuthCacheKeeper {
    private static final Logger LOG = LoggerFactory.getLogger(AuthCacheKeeper.class);
    private final SchemePortResolver schemePortResolver;

    public AuthCacheKeeper(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver;
    }

    public void updateOnChallenge(HttpHost host, String pathPrefix, AuthExchange authExchange, HttpContext context) {
        this.clearCache(host, pathPrefix, HttpClientContext.adapt(context));
    }

    public void updateOnNoChallenge(HttpHost host, String pathPrefix, AuthExchange authExchange, HttpContext context) {
        if (authExchange.getState() == AuthExchange.State.SUCCESS) {
            this.updateCache(host, pathPrefix, authExchange.getAuthScheme(), HttpClientContext.adapt(context));
        }
    }

    public void updateOnResponse(HttpHost host, String pathPrefix, AuthExchange authExchange, HttpContext context) {
        if (authExchange.getState() == AuthExchange.State.FAILURE) {
            this.clearCache(host, pathPrefix, HttpClientContext.adapt(context));
        }
    }

    public void loadPreemptively(HttpHost host, String pathPrefix, AuthExchange authExchange, HttpContext context) {
        if (authExchange.getState() == AuthExchange.State.UNCHALLENGED) {
            AuthScheme authScheme = this.loadFromCache(host, pathPrefix, HttpClientContext.adapt(context));
            if (authScheme == null && pathPrefix != null) {
                authScheme = this.loadFromCache(host, null, HttpClientContext.adapt(context));
            }
            if (authScheme != null) {
                authExchange.select(authScheme);
            }
        }
    }

    private AuthScheme loadFromCache(HttpHost host, String pathPrefix, HttpClientContext clientContext) {
        AuthScheme authScheme;
        AuthCache authCache = clientContext.getAuthCache();
        if (authCache != null && (authScheme = authCache.get(host, pathPrefix)) != null) {
            if (LOG.isDebugEnabled()) {
                String exchangeId = clientContext.getExchangeId();
                LOG.debug("{} Re-using cached '{}' auth scheme for {}{}", exchangeId, authScheme.getName(), host, pathPrefix != null ? pathPrefix : "");
            }
            return authScheme;
        }
        return null;
    }

    private void updateCache(HttpHost host, String pathPrefix, AuthScheme authScheme, HttpClientContext clientContext) {
        boolean cacheable;
        boolean bl = cacheable = authScheme.getClass().getAnnotation(AuthStateCacheable.class) != null;
        if (cacheable) {
            AuthCache authCache = clientContext.getAuthCache();
            if (authCache == null) {
                authCache = new BasicAuthCache(this.schemePortResolver);
                clientContext.setAuthCache(authCache);
            }
            if (LOG.isDebugEnabled()) {
                String exchangeId = clientContext.getExchangeId();
                LOG.debug("{} Caching '{}' auth scheme for {}{}", exchangeId, authScheme.getName(), host, pathPrefix != null ? pathPrefix : "");
            }
            authCache.put(host, pathPrefix, authScheme);
        }
    }

    private void clearCache(HttpHost host, String pathPrefix, HttpClientContext clientContext) {
        AuthCache authCache = clientContext.getAuthCache();
        if (authCache != null) {
            if (LOG.isDebugEnabled()) {
                String exchangeId = clientContext.getExchangeId();
                LOG.debug("{} Clearing cached auth scheme for {}{}", exchangeId, host, pathPrefix != null ? pathPrefix : "");
            }
            authCache.remove(host, pathPrefix);
        }
    }
}

