/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.dependency.oah5.client5.http.impl.classic;

import java.io.IOException;
import org.nudge.dependency.oah5.client5.http.HttpRoute;
import org.nudge.dependency.oah5.client5.http.classic.BackoffManager;
import org.nudge.dependency.oah5.client5.http.classic.ConnectionBackoffStrategy;
import org.nudge.dependency.oah5.client5.http.classic.ExecChain;
import org.nudge.dependency.oah5.client5.http.classic.ExecChainHandler;
import org.nudge.dependency.oah5.core5.annotation.Contract;
import org.nudge.dependency.oah5.core5.annotation.ThreadingBehavior;
import org.nudge.dependency.oah5.core5.http.ClassicHttpRequest;
import org.nudge.dependency.oah5.core5.http.ClassicHttpResponse;
import org.nudge.dependency.oah5.core5.http.HttpException;
import org.nudge.dependency.oah5.core5.util.Args;
import org.nudge.dependency.os.Logger;
import org.nudge.dependency.os.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
public final class BackoffStrategyExec
implements ExecChainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BackoffStrategyExec.class);
    private final ConnectionBackoffStrategy connectionBackoffStrategy;
    private final BackoffManager backoffManager;

    public BackoffStrategyExec(ConnectionBackoffStrategy connectionBackoffStrategy, BackoffManager backoffManager) {
        Args.notNull(connectionBackoffStrategy, "Connection backoff strategy");
        Args.notNull(backoffManager, "Backoff manager");
        this.connectionBackoffStrategy = connectionBackoffStrategy;
        this.backoffManager = backoffManager;
    }

    @Override
    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        ClassicHttpResponse response;
        Args.notNull(request, "HTTP request");
        Args.notNull(scope, "Scope");
        HttpRoute route = scope.route;
        try {
            response = chain.proceed(request, scope);
        }
        catch (IOException | HttpException ex) {
            if (this.connectionBackoffStrategy.shouldBackoff(ex)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Backing off route {} due to exception: {}", (Object)route, (Object)ex.getMessage());
                }
                this.backoffManager.backOff(route);
            }
            throw ex;
        }
        if (this.connectionBackoffStrategy.shouldBackoff(response)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Backing off route {} due to response status: {}", (Object)route, (Object)response.getCode());
            }
            this.backoffManager.backOff(route);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Probing route: {}", (Object)route);
            }
            this.backoffManager.probe(route);
        }
        return response;
    }
}

