/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.dependency.oah5.client5.http.protocol;

import java.io.IOException;
import org.nudge.dependency.oah5.client5.http.RouteInfo;
import org.nudge.dependency.oah5.client5.http.protocol.HttpClientContext;
import org.nudge.dependency.oah5.core5.annotation.Contract;
import org.nudge.dependency.oah5.core5.annotation.ThreadingBehavior;
import org.nudge.dependency.oah5.core5.http.EntityDetails;
import org.nudge.dependency.oah5.core5.http.HttpException;
import org.nudge.dependency.oah5.core5.http.HttpRequest;
import org.nudge.dependency.oah5.core5.http.HttpRequestInterceptor;
import org.nudge.dependency.oah5.core5.http.Method;
import org.nudge.dependency.oah5.core5.http.protocol.HttpContext;
import org.nudge.dependency.oah5.core5.util.Args;
import org.nudge.dependency.os.Logger;
import org.nudge.dependency.os.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
public class RequestClientConnControl
implements HttpRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RequestClientConnControl.class);

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getMethod();
        if (Method.CONNECT.isSame(method)) {
            return;
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        String exchangeId = clientContext.getExchangeId();
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Connection route not set in the context", (Object)exchangeId);
            }
            return;
        }
        if ((route.getHopCount() == 1 || route.isTunnelled()) && !request.containsHeader("Connection")) {
            request.addHeader("Connection", "keep-alive");
        }
    }
}

