/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.dependency.oah5.core5.http.impl.bootstrap;

import org.nudge.dependency.oah5.core5.http.ExceptionListener;
import org.nudge.dependency.oah5.core5.http.impl.io.HttpService;
import org.nudge.dependency.oah5.core5.http.io.HttpServerConnection;
import org.nudge.dependency.oah5.core5.http.protocol.BasicHttpContext;
import org.nudge.dependency.oah5.core5.http.protocol.HttpCoreContext;
import org.nudge.dependency.oah5.core5.io.CloseMode;

class Worker
implements Runnable {
    private final HttpService httpservice;
    private final HttpServerConnection conn;
    private final ExceptionListener exceptionListener;

    Worker(HttpService httpservice, HttpServerConnection conn, ExceptionListener exceptionListener) {
        this.httpservice = httpservice;
        this.conn = conn;
        this.exceptionListener = exceptionListener;
    }

    public HttpServerConnection getConnection() {
        return this.conn;
    }

    @Override
    public void run() {
        try {
            BasicHttpContext localContext = new BasicHttpContext();
            HttpCoreContext context = HttpCoreContext.adapt(localContext);
            while (!Thread.interrupted() && this.conn.isOpen()) {
                this.httpservice.handleRequest(this.conn, context);
                localContext.clear();
            }
            this.conn.close();
        }
        catch (Exception ex) {
            this.exceptionListener.onError(this.conn, ex);
        }
        finally {
            this.conn.close(CloseMode.IMMEDIATE);
        }
    }
}

