/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.dependency.oah5.core5.http.impl.io;

import java.io.IOException;
import org.nudge.dependency.oah5.core5.http.ClassicHttpResponse;
import org.nudge.dependency.oah5.core5.http.HttpException;
import org.nudge.dependency.oah5.core5.http.HttpResponseFactory;
import org.nudge.dependency.oah5.core5.http.config.Http1Config;
import org.nudge.dependency.oah5.core5.http.impl.io.AbstractMessageParser;
import org.nudge.dependency.oah5.core5.http.impl.io.DefaultClassicHttpResponseFactory;
import org.nudge.dependency.oah5.core5.http.message.LineParser;
import org.nudge.dependency.oah5.core5.http.message.StatusLine;
import org.nudge.dependency.oah5.core5.util.CharArrayBuffer;

public class DefaultHttpResponseParser
extends AbstractMessageParser<ClassicHttpResponse> {
    private final HttpResponseFactory<ClassicHttpResponse> responseFactory;

    public DefaultHttpResponseParser(LineParser lineParser, HttpResponseFactory<ClassicHttpResponse> responseFactory, Http1Config http1Config) {
        super(lineParser, http1Config);
        this.responseFactory = responseFactory != null ? responseFactory : DefaultClassicHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParser(Http1Config http1Config) {
        this(null, null, http1Config);
    }

    public DefaultHttpResponseParser() {
        this(Http1Config.DEFAULT);
    }

    @Override
    protected ClassicHttpResponse createMessage(CharArrayBuffer buffer) throws IOException, HttpException {
        StatusLine statusline = this.getLineParser().parseStatusLine(buffer);
        ClassicHttpResponse response = this.responseFactory.newHttpResponse(statusline.getStatusCode(), statusline.getReasonPhrase());
        response.setVersion(statusline.getProtocolVersion());
        return response;
    }
}

