/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.dependency.oah5.core5.http.impl.nio;

import java.io.IOException;
import org.nudge.dependency.oah5.core5.http.HttpException;
import org.nudge.dependency.oah5.core5.http.HttpRequest;
import org.nudge.dependency.oah5.core5.http.HttpRequestFactory;
import org.nudge.dependency.oah5.core5.http.MessageConstraintException;
import org.nudge.dependency.oah5.core5.http.RequestHeaderFieldsTooLargeException;
import org.nudge.dependency.oah5.core5.http.config.Http1Config;
import org.nudge.dependency.oah5.core5.http.impl.nio.AbstractMessageParser;
import org.nudge.dependency.oah5.core5.http.message.LineParser;
import org.nudge.dependency.oah5.core5.http.message.RequestLine;
import org.nudge.dependency.oah5.core5.http.nio.SessionInputBuffer;
import org.nudge.dependency.oah5.core5.util.Args;
import org.nudge.dependency.oah5.core5.util.CharArrayBuffer;

public class DefaultHttpRequestParser<T extends HttpRequest>
extends AbstractMessageParser<T> {
    private final HttpRequestFactory<T> requestFactory;

    public DefaultHttpRequestParser(HttpRequestFactory<T> requestFactory, LineParser parser, Http1Config http1Config) {
        super(parser, http1Config);
        this.requestFactory = Args.notNull(requestFactory, "Request factory");
    }

    public DefaultHttpRequestParser(HttpRequestFactory<T> requestFactory, Http1Config http1Config) {
        this(requestFactory, null, http1Config);
    }

    public DefaultHttpRequestParser(HttpRequestFactory<T> requestFactory) {
        this(requestFactory, null);
    }

    @Override
    public T parse(SessionInputBuffer sessionBuffer, boolean endOfStream) throws IOException, HttpException {
        try {
            return (T)((HttpRequest)super.parse(sessionBuffer, endOfStream));
        }
        catch (MessageConstraintException ex) {
            throw new RequestHeaderFieldsTooLargeException(ex.getMessage(), ex);
        }
    }

    @Override
    protected T createMessage(CharArrayBuffer buffer) throws HttpException {
        RequestLine requestLine = this.getLineParser().parseRequestLine(buffer);
        T request = this.requestFactory.newHttpRequest(requestLine.getMethod(), requestLine.getUri());
        request.setVersion(requestLine.getProtocolVersion());
        return request;
    }
}

