/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.dependency.oah5.core5.http.protocol;

import java.io.IOException;
import org.nudge.dependency.oah5.core5.annotation.Contract;
import org.nudge.dependency.oah5.core5.annotation.ThreadingBehavior;
import org.nudge.dependency.oah5.core5.http.EntityDetails;
import org.nudge.dependency.oah5.core5.http.HttpException;
import org.nudge.dependency.oah5.core5.http.HttpRequest;
import org.nudge.dependency.oah5.core5.http.HttpRequestInterceptor;
import org.nudge.dependency.oah5.core5.http.HttpVersion;
import org.nudge.dependency.oah5.core5.http.Method;
import org.nudge.dependency.oah5.core5.http.ProtocolException;
import org.nudge.dependency.oah5.core5.http.ProtocolVersion;
import org.nudge.dependency.oah5.core5.http.protocol.HttpContext;
import org.nudge.dependency.oah5.core5.net.URIAuthority;
import org.nudge.dependency.oah5.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    public static final HttpRequestInterceptor INSTANCE = new RequestTargetHost();

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        Args.notNull(context, "HTTP context");
        ProtocolVersion ver = context.getProtocolVersion();
        String method = request.getMethod();
        if (Method.CONNECT.isSame(method) && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            URIAuthority authority = request.getAuthority();
            if (authority == null) {
                if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                    return;
                }
                throw new ProtocolException("Target host is unknown");
            }
            if (authority.getUserInfo() != null) {
                authority = new URIAuthority(authority.getHostName(), authority.getPort());
            }
            request.addHeader("Host", authority);
        }
    }
}

