/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.dependency.oah5.core5.http2.ssl;

import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import org.nudge.dependency.oah5.core5.concurrent.FutureCallback;
import org.nudge.dependency.oah5.core5.http.HttpHost;
import org.nudge.dependency.oah5.core5.http.URIScheme;
import org.nudge.dependency.oah5.core5.http.nio.ssl.TlsStrategy;
import org.nudge.dependency.oah5.core5.http2.ssl.H2TlsSupport;
import org.nudge.dependency.oah5.core5.net.NamedEndpoint;
import org.nudge.dependency.oah5.core5.reactor.ssl.SSLBufferMode;
import org.nudge.dependency.oah5.core5.reactor.ssl.SSLSessionInitializer;
import org.nudge.dependency.oah5.core5.reactor.ssl.SSLSessionVerifier;
import org.nudge.dependency.oah5.core5.reactor.ssl.TransportSecurityLayer;
import org.nudge.dependency.oah5.core5.ssl.SSLContexts;
import org.nudge.dependency.oah5.core5.util.Args;
import org.nudge.dependency.oah5.core5.util.Timeout;

public class H2ClientTlsStrategy
implements TlsStrategy {
    private final SSLContext sslContext;
    private final SSLBufferMode sslBufferMode;
    private final SSLSessionInitializer initializer;
    private final SSLSessionVerifier verifier;

    public H2ClientTlsStrategy(SSLContext sslContext, SSLBufferMode sslBufferMode, SSLSessionInitializer initializer, SSLSessionVerifier verifier) {
        this.sslContext = Args.notNull(sslContext, "SSL context");
        this.sslBufferMode = sslBufferMode;
        this.initializer = initializer;
        this.verifier = verifier;
    }

    public H2ClientTlsStrategy(SSLContext sslContext, SSLSessionInitializer initializer, SSLSessionVerifier verifier) {
        this(sslContext, null, initializer, verifier);
    }

    public H2ClientTlsStrategy(SSLContext sslContext, SSLSessionVerifier verifier) {
        this(sslContext, null, null, verifier);
    }

    public H2ClientTlsStrategy(SSLContext sslContext) {
        this(sslContext, null, null, null);
    }

    public H2ClientTlsStrategy() {
        this(SSLContexts.createSystemDefault());
    }

    public H2ClientTlsStrategy(SSLSessionVerifier verifier) {
        this(SSLContexts.createSystemDefault(), null, null, verifier);
    }

    @Override
    public void upgrade(TransportSecurityLayer tlsSession, NamedEndpoint endpoint, Object attachment, Timeout handshakeTimeout, FutureCallback<TransportSecurityLayer> callback) {
        tlsSession.startTls(this.sslContext, endpoint, this.sslBufferMode, H2TlsSupport.enforceRequirements(attachment, this.initializer), this.verifier, handshakeTimeout, callback);
    }

    @Override
    @Deprecated
    public boolean upgrade(TransportSecurityLayer tlsSession, HttpHost host, SocketAddress localAddress, SocketAddress remoteAddress, Object attachment, Timeout handshakeTimeout) {
        String scheme;
        String string = scheme = host != null ? host.getSchemeName() : null;
        if (URIScheme.HTTPS.same(scheme)) {
            this.upgrade(tlsSession, host, attachment, handshakeTimeout, null);
            return true;
        }
        return false;
    }
}

