/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;

public class Anonymizer {
    private final Map<String, String> internalCache = new WeakHashMap<String, String>();
    private static final int MAX_CACHE_SIZE = 32;
    private static final Pattern sqlOp = Pattern.compile("([=!<>])\\s*[0-9]+");
    private static final Pattern sqlIn = Pattern.compile("[iI][nN]\\s*\\(\\s*(?:\\s+|\\?|,|[0-9]+).*?\\s?\\)");
    private static final Pattern sqlDateAdd = Pattern.compile("[dD][aA][tT][eE][aA][dD][dD]\\s*\\(.*?\\)");
    private static final Pattern sqlDateDiff = Pattern.compile("[dD][aA][tT][eE][dD][iI][fF][fF]\\s*\\(.*?\\)");
    private static final Pattern sqlDatePart = Pattern.compile("[dD][aA][tT][eE][pP][aA][rR][tT]\\s*\\(.*?\\)");
    private static final Pattern sqlBetween = Pattern.compile("[Bb][Ee][Tt][Ww][Ee][Ee][Nn]\\s*(?:[0-9]+|\\?)\\s*[Aa][Nn][Dd]\\s*(?:[0-9]+|\\?)");
    private static final Pattern sqlValues = Pattern.compile("[Vv][Aa][Ll][Uu][Ee][Ss]\\s*\\(.*\\)");

    private static boolean isQuoteChar(char c) {
        return c == '\'' || c == '\"';
    }

    public String anonymiseSql(String sql) {
        String res = sql;
        if (sql == null) {
            return "";
        }
        String cacheValue = this.internalCache.get(sql);
        if (null != cacheValue) {
            return cacheValue;
        }
        try {
            boolean hasParenthesis = false;
            boolean hasQuote = false;
            boolean extraWhite = false;
            boolean hasComment = false;
            boolean hasOp = false;
            char previous = ' ';
            for (int i = 0; i < sql.length(); ++i) {
                char c = sql.charAt(i);
                switch (c) {
                    case '(': 
                    case ')': {
                        hasParenthesis = true;
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        hasQuote = true;
                        break;
                    }
                    case '!': 
                    case '<': 
                    case '=': 
                    case '>': {
                        hasOp = true;
                    }
                }
                if (i > 0) {
                    extraWhite |= Character.isWhitespace(c) && Character.isWhitespace(previous);
                    hasComment |= previous == c && c == '-';
                }
                previous = c;
            }
            if (hasComment) {
                res = Anonymizer.removeComments(sql);
            }
            if (extraWhite) {
                res = Anonymizer.removeExcessiveWhitespace(res);
            }
            if (hasQuote) {
                res = Anonymizer.stringAnonymizer(res);
            }
            if (hasOp) {
                res = Anonymizer.replaceOp(res);
            }
            if (hasParenthesis) {
                res = Anonymizer.replaceIn(res);
                res = Anonymizer.replaceDateAdd(res);
                res = Anonymizer.replaceDateDiff(res);
                res = Anonymizer.replaceDatePart(res);
            }
            res = Anonymizer.replaceBetween(res);
            if (hasParenthesis) {
                res = Anonymizer.replaceValues(res);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        res = res.trim();
        if (this.internalCache.size() < 32) {
            this.internalCache.put(sql, res);
        }
        return res;
    }

    private static String replaceDateAdd(String res) {
        return sqlDateAdd.matcher(res).replaceAll("dateadd (?) ");
    }

    private static String replaceDateDiff(String res) {
        return sqlDateDiff.matcher(res).replaceAll("datediff (?) ");
    }

    private static String replaceDatePart(String res) {
        return sqlDatePart.matcher(res).replaceAll("datepart (?) ");
    }

    private static String replaceBetween(String res) {
        return sqlBetween.matcher(res).replaceAll("between ? and ? ");
    }

    private static String replaceValues(String res) {
        return sqlValues.matcher(res).replaceAll("values (?) ");
    }

    private static String replaceOp(String res) {
        return sqlOp.matcher(res).replaceAll("$1? ");
    }

    private static String replaceIn(String res) {
        return sqlIn.matcher(res).replaceAll("in (?) ");
    }

    private static String removeComments(String sql) {
        for (int i = 1; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (c != '-' || c != sql.charAt(i - 1)) continue;
            return sql.substring(0, i - 1);
        }
        return sql;
    }

    private static String removeExcessiveWhitespace(String sql) {
        char[] chars = sql.toCharArray();
        int write = 0;
        boolean prevWhite = true;
        for (int read = 0; read < chars.length; ++read) {
            char c = chars[read];
            if (c == '\n') {
                c = ' ';
            }
            boolean doCopy = true;
            if (Character.isWhitespace(c)) {
                if (prevWhite) {
                    doCopy = false;
                }
                prevWhite = true;
            } else {
                prevWhite = false;
            }
            if (!doCopy) continue;
            chars[write++] = chars[read];
        }
        return new String(chars, 0, write);
    }

    private static String stringAnonymizer(String sql) {
        char[] sqlC = sql.toCharArray();
        StringBuilder b = new StringBuilder(sql.length());
        int l = sqlC.length;
        char stringQuote = '\u0000';
        for (int i = 0; i < sqlC.length; ++i) {
            char c = sqlC[i];
            if ('\u0000' == stringQuote && Anonymizer.isQuoteChar(c)) {
                stringQuote = c;
                ++i;
                boolean doContinue = true;
                while (i < l && doContinue) {
                    boolean bl = doContinue = sqlC[i] != stringQuote;
                    if (!doContinue) {
                        if (i + 1 < l && sqlC[i] == sqlC[i + 1]) {
                            doContinue = true;
                            ++i;
                        } else if (sqlC[i - 1] == '\\') {
                            doContinue = true;
                        }
                    }
                    if (doContinue) {
                        ++i;
                        continue;
                    }
                    stringQuote = '\u0000';
                }
                b.append('?');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }
}

