/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.nudge.dependency.oaci.IOUtils;
import org.nudge.dependency.ooa.ClassReader;
import org.nudge.dependency.ooa.ClassVisitor;
import org.nudge.dependency.ooa.MethodVisitor;
import org.nudge.probe.log.Logger;
import org.nudge.probe.weave.ClassDef;
import org.nudge.probe.weave.NudgeClassWriter;

public class BytecodeWitch {
    private static final Logger log = Logger.getLogger(BytecodeWitch.class.getName());

    private BytecodeWitch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fixBytecode(String className, byte[] bytecode, ClassLoader cl) {
        if (className.equals("org/jboss/classfilewriter/annotations/ClassAnnotation")) {
            InputStream input;
            if (Arrays.hashCode(bytecode) == -1018916863 && null != (input = ClassLoader.getSystemClassLoader().getResourceAsStream("jboss_fix/ClassAnnotation.klass"))) {
                try {
                    log.info("ad-hoc patch for jboss : %s fixed in jboss-classfilewriter 1.0.3.Final", className);
                    byte[] byArray = IOUtils.toByteArray(input);
                    return byArray;
                }
                catch (IOException e) {
                    log.severe(e, "unable to patch buggy jboss ClassAnnotation", new Object[0]);
                }
                finally {
                    IOUtils.closeQuietly(input);
                }
            }
        } else if ((className.startsWith("org/apache/commons/dbcp") || className.startsWith("org/apache/tomcat/dbcp/dbcp")) && className.endsWith("DelegatingDatabaseMetaData")) {
            log.info("ad-hoc patch for commons-dbcp class : %s see DBCP-352 for details", className);
            ClassDef classDef = ClassDef.fromBytecode(bytecode, cl);
            NudgeClassWriter writer = new NudgeClassWriter(cl, classDef, 3);
            ClassReader reader = new ClassReader(bytecode);
            reader.accept(new CommonsDbcpClassVisitor(writer), 4);
            return writer.toByteArray();
        }
        return null;
    }

    private static class CommonsDbcpMethodVisitor
    extends MethodVisitor {
        private boolean beforeParentConstructorCall = true;

        public CommonsDbcpMethodVisitor(MethodVisitor mv) {
            super(589824, mv);
        }

        @Override
        public void visitVarInsn(int opcode, int var) {
            if (!this.beforeParentConstructorCall || opcode != 25) {
                super.visitVarInsn(opcode, var);
            }
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (opcode == 183 && owner.endsWith("AbandonedTrace") && name.equals("<init>")) {
                super.visitVarInsn(25, 0);
                super.visitMethodInsn(opcode, "java/lang/Object", name, "()V", false);
                this.beforeParentConstructorCall = false;
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }
    }

    private static class CommonsDbcpClassVisitor
    extends ClassVisitor {
        public CommonsDbcpClassVisitor(ClassVisitor cv) {
            super(589824, cv);
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (name.endsWith("DelegatingDatabaseMetaData") && superName.endsWith("AbandonedTrace")) {
                superName = "java/lang/Object";
            }
            super.visit(version, access, name, signature, superName, interfaces);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            if ("<init>".equals(name)) {
                mv = new CommonsDbcpMethodVisitor(mv);
            }
            return mv;
        }
    }
}

