/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.nudge.dependency.oaci.IOUtils;
import org.nudge.probe.ConfigurationMBean;
import org.nudge.probe.ProbeJar;
import org.nudge.probe.Util;
import org.nudge.probe.collector.TransactionFilter;
import org.nudge.probe.conf.ConfigParam;
import org.nudge.probe.conf.ConnectorConfig;
import org.nudge.probe.conf.ProxyConfig;
import org.nudge.probe.log.Level;
import org.nudge.probe.log.Logger;
import org.nudge.probe.util.Checker;

public class Configuration
implements ConfigurationMBean {
    private List<ConfigParam<?>> allParameters = new ArrayList();
    public static String DEFAULT_LOGGER_NAME = "org.nudge";
    public static Level DEFAULT_LOG_LEVEL = Level.SEVERE;
    public static String NUDGE_LOG = "nudge.log";
    public static String NUDGE_ROTATE_FORMAT = "nudge%d.log";
    public static Pattern NUDGE_ROTATE_PATTERN = Pattern.compile("nudge(\\d+)\\.log");
    private String logDirectory;
    private boolean fineLogOnStartup;
    private boolean hasExplicitLogLevel;
    private Level logLevel;
    private int logRotationCount;
    private static String SYSTEM_PROPERTIES_PREFIX = "nudge.";
    private static String CONFIG_LOCATION = "configuration_location";
    public static String NUDGE_PROPERTIES = "nudge.properties";
    public static String CONTROLLER_PROPERTIES = "controller-config.properties";
    private int hostKey;
    private String hostname;
    private String qualifier;
    private boolean allowHotReloading;
    private List<String> handlers;
    private int packetSize;
    private boolean allowInstanceConfig;
    private boolean logUpload;
    private boolean configUpload;
    private String appId;
    private List<String> serverUrl;
    private boolean collectorEnabled;
    public static String SERVER_URL_KEY = "server_url";
    public static String SERVER_URL_DEFAULT_VALUE = "https://www.atakama-technologies.com/unsetCollectorURL";
    private boolean compressed;
    private boolean dryRun;
    private int diskFallbackMaxSend;
    private long diskFallbackIgnoreThreshold;
    private long diskFallbackMaxSize;
    private File diskFallbackDirectory;
    private final int flushFilteringRate;
    private final TransactionFilter.ReducingType flushFilteringType;
    private final String flushFilteringTypeStr;
    private long diskDumpMaxSize;
    private File diskDumpDirectory;
    private File propertiesLocation;
    private boolean prependTxType = false;
    private int flushTxCount;
    private int flushInterval;
    private int flushThreadSamplesCount;
    private int flushJmxSamplesCount;
    private int flushOverflowLimitFactor;
    private int flushSystemMetricsSampleCount;
    private int flushComponentsCount;
    private int flushRumCount;
    private boolean activateRum;
    private boolean servletVersionPost2_3 = true;
    private boolean logServlet;
    private boolean logServletContextListener;
    private boolean logPortlet;
    private List<String> excludedClasspath;
    private List<String> includedClasspath;
    private List<String> excludedClassLoaders;
    private boolean activateAutoExclusion;
    private List<String> autoExcludedClasspath;
    private List<String> aopPointcuts;
    private boolean activateJmx;
    private List<String> mbeansMonitored;
    private List<String> initialMbeansMonitored;
    private int maxMbeanAttributesMonitored;
    private int jmxSampleInterval;
    private int jmxSampleMaxTime;
    private int systemSampleInterval;
    private int systemSampleMaxTime;
    private boolean systemSampleEnabled;
    private boolean captureHttpParams;
    private Set<String> ignoredHttpParams;
    private Set<String> allowedHttpParams;
    private boolean captureHttpHeaders;
    private Set<String> ignoredHttpHeaders;
    private Set<String> allowedHttpHeaders;
    private boolean httpClientIp;
    private Long queryCountLimit;
    private boolean isQueryAnonymizationActive;
    private Long longQueryThreshold;
    private boolean logStackTraceOnConnection = false;
    private boolean instrumentProxyClasses;
    private boolean logRunnable;
    private boolean logEbj3;
    private boolean logRmi;
    private boolean logCorba;
    private boolean logTimerTask;
    private boolean logWebService;
    private boolean dumpClasses;
    private boolean dumpAllClasses;
    private boolean profilingEnabled;
    private int profilingThreadDepth;
    private int profilingSampleInterval;
    private int profilingSampleMaxTime;
    private int threadDumpFrequency;
    private int threadDumpDuration;
    private String version;
    private boolean traceInstrumentedCodeStackTraces;
    private boolean probeEnabled;
    private ConnectorConfig connectorConfig;
    private boolean componentScanEnabled;
    private boolean logSpringMvc;
    private static final ConfigParam.ConvertFunction<String> NORMALIZE_SERVER_URL = new ConfigParam.ConvertFunction<String>(){

        @Override
        public String convert(String s) {
            while (s.endsWith("/")) {
                s = s.substring(0, s.length() - 1);
            }
            return Util.createUrl(s, new Object[0]).toString();
        }
    };
    private static final ConfigParam.ConvertFunction<List<String>> NORMALIZE_CLASSPATH = new ConfigParam.ConvertFunction<List<String>>(){

        @Override
        public List<String> convert(String s) {
            ArrayList<String> result = new ArrayList<String>();
            String trimmed = s.trim();
            if (trimmed.length() > 0) {
                String[] parts;
                for (String part : parts = trimmed.split(",")) {
                    result.add(Configuration.normalizeClassName(part));
                }
            }
            return result;
        }
    };

    public boolean isRmiActivated() {
        return this.logRmi;
    }

    public boolean isCorbaActivated() {
        return this.logCorba;
    }

    public boolean isTimerTaskActivated() {
        return this.logTimerTask;
    }

    public int getFlushInterval() {
        return this.flushInterval;
    }

    public int getFlushTxCount() {
        return this.flushTxCount;
    }

    public int getFlushThreadSamplesCount() {
        return this.flushThreadSamplesCount;
    }

    public int getFlushJmxSamplesCount() {
        return this.flushJmxSamplesCount;
    }

    public int getFlushOverflowLimitFactor() {
        return this.flushOverflowLimitFactor;
    }

    public int getFlushSystemMetricsSampleCount() {
        return this.flushSystemMetricsSampleCount;
    }

    public int getFlushComponentsCount() {
        return this.flushComponentsCount;
    }

    public int getHostKey() {
        return this.hostKey;
    }

    public String getServiceHostname() {
        return this.hostname;
    }

    public String getServiceQualifier() {
        return this.qualifier;
    }

    protected Configuration(Properties properties, File propertiesLocation, ProbeJar jar, boolean isConfigReloading) {
        this.version = null != jar ? jar.getVersion() : "";
        this.propertiesLocation = propertiesLocation;
        this.appId = this.stringConfig("app_id").mandatory().load(properties, isConfigReloading);
        this.serverUrl = this.loadServerUrlFromProps(properties, isConfigReloading);
        this.packetSize = this.intConfig("packet_size").defaultValue(500).validate(this.minimum(1)).load(properties, isConfigReloading);
        this.handlers = this.stringListConfig("handlers", ",").defaultValue(Collections.singletonList("http")).load(properties, isConfigReloading);
        this.compressed = this.booleanConfig("compressed").reloadable().defaultValue(true).load(properties, isConfigReloading);
        this.prependTxType = this.booleanConfig("prepend_tx_type").reloadable().defaultValue(false).load(properties, isConfigReloading);
        this.allowInstanceConfig = this.booleanConfig("allow_instance_config").reloadable().defaultValue(true).load(properties, isConfigReloading);
        this.allowHotReloading = this.booleanConfig("allow_hot_reloading").defaultValue(true).load(properties, isConfigReloading);
        this.diskFallbackMaxSend = this.intConfig("disk_fallback_max_send").reloadable().defaultValue(10).load(properties, isConfigReloading);
        this.diskFallbackIgnoreThreshold = this.intConfig("disk_fallback_ignore_threshold").reloadable().defaultValue(86400).load(properties, isConfigReloading).intValue();
        this.diskFallbackMaxSize = this.longConfig("disk_fallback_max_size").reloadable().defaultValue(0xC800000L).load(properties, isConfigReloading);
        this.diskDumpMaxSize = this.longConfig("disk_dump_max_size").reloadable().defaultValue(-1L).load(properties, isConfigReloading);
        this.logUpload = this.booleanConfig("upload_log").defaultValue(true).load(properties, isConfigReloading);
        this.configUpload = this.booleanConfig("upload_config").defaultValue(true).load(properties, isConfigReloading);
        this.flushTxCount = this.intConfig("flush_tx_count").defaultValue(2000).validate(this.minimum(1)).load(properties, isConfigReloading);
        this.flushThreadSamplesCount = this.intConfig("flush_thread_samples_count").defaultValue(5000).validate(this.minimum(1)).load(properties, isConfigReloading);
        this.flushJmxSamplesCount = this.intConfig("flush_jmx_samples_count").defaultValue(1000).validate(this.minimum(1)).load(properties, isConfigReloading);
        this.flushSystemMetricsSampleCount = this.intConfig("flush_system_samples_count").defaultValue(1000).validate(this.minimum(1)).load(properties, isConfigReloading);
        this.flushComponentsCount = this.intConfig("flush_components_count").defaultValue(1000).validate(this.minimum(1)).load(properties, isConfigReloading);
        this.flushRumCount = this.intConfig("flush_rum_count").defaultValue(1000).validate(this.minimum(1)).load(properties, isConfigReloading);
        this.flushInterval = this.intConfig("flush_interval").defaultValue(60).validate(this.between(1, 600)).load(properties, isConfigReloading);
        this.flushOverflowLimitFactor = this.intConfig("flush_overflow_limit_factor").defaultValue(5).validate(this.minimum(1)).load(properties, isConfigReloading);
        this.logDirectory = this.getLogDirWithFallback(properties, jar, isConfigReloading);
        this.fineLogOnStartup = this.booleanConfig("fine_log_on_startup").defaultValue(true).load(properties, isConfigReloading);
        this.logRotationCount = this.intConfig("log_rotation_count").defaultValue(5).validate(this.minimum(0)).load(properties, isConfigReloading);
        this.diskFallbackDirectory = this.getDirectoryWithFallback("disk_fallback_directory", properties, this.logDirectory, isConfigReloading);
        this.diskDumpDirectory = this.getDirectoryWithFallback("disk_dump_directory", properties, this.logDirectory, isConfigReloading);
        ConfigParam<Level> logLevelParam = this.logLevel("log_level");
        this.logLevel = logLevelParam.load(properties, isConfigReloading);
        this.hasExplicitLogLevel = !logLevelParam.isDefaultValue();
        final ProxyConfig proxyConfig = new ProxyConfig(this.proxyType("proxy_type").defaultValue(Proxy.Type.HTTP).load(properties, isConfigReloading), this.stringConfig("proxy_host").load(properties, isConfigReloading), this.intConfig("proxy_port").defaultValue(0).validate(this.minimum(0)).load(properties, isConfigReloading), this.stringConfig("proxy_user").load(properties, isConfigReloading), this.stringConfig("proxy_password").confidential().load(properties, isConfigReloading));
        if (proxyConfig.useProxy() && proxyConfig.useCredentials()) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(proxyConfig.getLogin(), proxyConfig.getPassword().toCharArray());
                }
            });
        }
        int connectionTimeout = this.intConfig("network_connect_timeout").defaultValue(2000).load(properties, isConfigReloading);
        int connectionReadTimeout = this.intConfig("network_read_timeout").defaultValue(5000).load(properties, isConfigReloading);
        boolean useInternalKeystore = this.booleanConfig("network_internal_keystore").defaultValue(false).load(properties, isConfigReloading);
        this.connectorConfig = new ConnectorConfig(proxyConfig, connectionTimeout, connectionReadTimeout, useInternalKeystore);
        this.qualifier = this.stringConfig("service_qualifier").reloadable().defaultValue(null).load(properties, isConfigReloading);
        this.hostname = this.stringConfig("service_hostname").defaultValue(null).load(properties, isConfigReloading);
        this.hostKey = null != this.qualifier ? this.qualifier.hashCode() : this.logDirectory.hashCode();
        this.traceInstrumentedCodeStackTraces = this.booleanConfig("instrumented_code_stacktraces").defaultValue(false).load(properties, isConfigReloading);
        this.threadDumpFrequency = this.intConfig("thread_dump_frequency").defaultValue(0).validate(this.minimum(0)).load(properties, isConfigReloading);
        this.threadDumpDuration = this.intConfig("thread_dump_duration").defaultValue(0).validate(this.minimum(0)).load(properties, isConfigReloading);
        this.dumpClasses = this.booleanConfig("dump_classes").defaultValue(false).load(properties, isConfigReloading);
        this.dumpAllClasses = this.booleanConfig("dump_all_classes").defaultValue(false).load(properties, isConfigReloading);
        this.captureHttpParams = this.booleanConfig("capture_params").reloadable().defaultValue(false).load(properties, isConfigReloading);
        this.ignoredHttpParams = new HashSet<String>((Collection)this.stringListConfig("ignored_params", ",").reloadable().load(properties, isConfigReloading));
        this.allowedHttpParams = new HashSet<String>((Collection)this.stringListConfig("allowed_params", ",").reloadable().load(properties, isConfigReloading));
        this.captureHttpHeaders = this.booleanConfig("capture_headers").reloadable().defaultValue(false).load(properties, isConfigReloading);
        this.ignoredHttpHeaders = new HashSet<String>((Collection)this.httpHeaderConfig("ignored_headers").reloadable().load(properties, isConfigReloading));
        this.allowedHttpHeaders = new HashSet<String>((Collection)this.httpHeaderConfig("allowed_headers").reloadable().load(properties, isConfigReloading));
        this.httpClientIp = this.booleanConfig("http_client_ip").reloadable().defaultValue(false).load(properties, isConfigReloading);
        this.excludedClasspath = this.classpathListConfig("excluded_classpath").load(properties, isConfigReloading);
        this.includedClasspath = this.classpathListConfig("included_classpath").load(properties, isConfigReloading);
        this.excludedClassLoaders = this.classpathListConfig("excluded_classloaders").load(properties, isConfigReloading);
        this.activateAutoExclusion = this.booleanConfig("activate-auto-exclusion").defaultValue(true).load(properties, isConfigReloading);
        this.autoExcludedClasspath = Configuration.defineAutomaticExcludedClasspath();
        this.isQueryAnonymizationActive = this.booleanConfig("query_anonymization").defaultValue(true).load(properties, isConfigReloading);
        this.longQueryThreshold = (long)(1000.0 * this.doubleConfig("long_query_threshold").defaultValue(0.0).load(properties, isConfigReloading));
        this.queryCountLimit = this.longConfig("query_count_limit").defaultValue(10000L).load(properties, isConfigReloading);
        this.logStackTraceOnConnection = this.booleanConfig("log_connection").defaultValue(false).load(properties, isConfigReloading);
        this.instrumentProxyClasses = this.booleanConfig("instrument_proxy_classes").reloadable().defaultValue(false).load(properties, isConfigReloading);
        this.activateJmx = this.booleanConfig("activate_jmx").defaultValue(true).load(properties, isConfigReloading);
        this.mbeansMonitored = this.stringListConfig("mbeans_monitored", ";").reloadable().load(properties, isConfigReloading);
        this.initialMbeansMonitored = new ArrayList<String>(this.mbeansMonitored);
        this.maxMbeanAttributesMonitored = this.intConfig("max_mbean_attributes_monitored").reloadable().validate(this.minimum(0)).defaultValue(2000).load(properties, isConfigReloading);
        this.jmxSampleInterval = this.intConfig("jmx_sample_interval").defaultValue(10000).validate(this.minimum(10000)).load(properties, isConfigReloading);
        this.jmxSampleMaxTime = this.intConfig("jmx_sample_max_time").defaultValue(100).validate(this.minimum(1)).load(properties, isConfigReloading);
        Checker.checkState(this.jmxSampleMaxTime <= this.jmxSampleInterval, "jmx max sample time must be less or equal to sample time");
        this.systemSampleInterval = this.intConfig("system_sample_interval").defaultValue(60000).validate(this.minimum(10000)).load(properties, isConfigReloading);
        this.systemSampleMaxTime = this.intConfig("system_sample_max_time").reloadable().defaultValue(100).validate(this.minimum(1)).load(properties, isConfigReloading);
        Checker.checkState(this.systemSampleMaxTime <= this.systemSampleInterval, "system max sample time must be less or equal to sample time");
        this.systemSampleEnabled = this.booleanConfig("system_sample_enable").defaultValue(true).load(properties, isConfigReloading);
        this.activateRum = this.booleanConfig("activate_rum").defaultValue(false).load(properties, isConfigReloading);
        this.profilingEnabled = this.booleanConfig("profiling_enable").defaultValue(true).load(properties, isConfigReloading);
        this.profilingThreadDepth = this.intConfig("profiling_thread_depth").reloadable().legacyName("thread_depth").defaultValue(1000).load(properties, isConfigReloading);
        this.profilingSampleInterval = this.intConfig("profiling_sample_interval").defaultValue(1000).load(properties, isConfigReloading);
        this.profilingSampleMaxTime = this.intConfig("profiling_sample_max_time").reloadable().defaultValue(10).load(properties, isConfigReloading);
        Checker.checkState(this.profilingSampleMaxTime <= this.profilingSampleInterval, "profiling max sample time must be less or equal to sample time");
        this.logRunnable = this.booleanConfig("log_runnable").defaultValue(false).load(properties, isConfigReloading);
        this.logEbj3 = this.booleanConfig("log_ejb3").defaultValue(true).load(properties, isConfigReloading);
        this.logRmi = this.booleanConfig("log_rmi").defaultValue(true).load(properties, isConfigReloading);
        this.logCorba = this.booleanConfig("log_corba").defaultValue(true).load(properties, isConfigReloading);
        this.logTimerTask = this.booleanConfig("log_timertask").defaultValue(true).load(properties, isConfigReloading);
        this.logWebService = this.booleanConfig("log_webservice").defaultValue(true).load(properties, isConfigReloading);
        this.aopPointcuts = this.stringListConfig("trace_classpath_regex", ",").load(properties, isConfigReloading);
        this.servletVersionPost2_3 = this.booleanConfig("servlet_version_post_2_3").defaultValue(true).load(properties, isConfigReloading);
        this.logServlet = this.booleanConfig("log_servlet").defaultValue(true).load(properties, isConfigReloading);
        this.logServletContextListener = this.booleanConfig("log_servlet_contextlistener").defaultValue(false).load(properties, isConfigReloading);
        this.logSpringMvc = this.booleanConfig("log_springmvc").defaultValue(true).load(properties, isConfigReloading);
        this.logPortlet = this.booleanConfig("log_portlet").defaultValue(true).load(properties, isConfigReloading);
        this.probeEnabled = this.booleanConfig("enable").defaultValue(true).load(properties, isConfigReloading);
        this.dryRun = this.booleanConfig("dryrun").defaultValue(false).load(properties, isConfigReloading);
        this.componentScanEnabled = this.booleanConfig("component_scan").defaultValue(true).load(properties, isConfigReloading);
        this.collectorEnabled = this.booleanConfig("collector_enable").defaultValue(true).load(properties, isConfigReloading);
        this.flushFilteringRate = this.intConfig("flush_filtering_rate").defaultValue(0).load(properties, isConfigReloading);
        this.flushFilteringTypeStr = this.stringConfig("flush_filtering_type").defaultValue("none").load(properties, isConfigReloading);
        this.flushFilteringType = this.getFlushFilteringType(this.flushFilteringTypeStr);
    }

    private static List<String> defineAutomaticExcludedClasspath() {
        ArrayList<String> exclClasspath = new ArrayList<String>();
        exclClasspath.add("oracle/oc4j/sql/proxy");
        exclClasspath.add("com/sun/net/ssl");
        return exclClasspath;
    }

    private File getDirectoryWithFallback(String property, Properties properties, String fallback, boolean isConfigReloading) {
        File dir = new File(this.stringConfig(property).reloadable().defaultValue(this.logDirectory).load(properties, isConfigReloading));
        if (dir.exists() && !dir.isDirectory()) {
            dir = new File(fallback);
        }
        return dir;
    }

    public static Configuration buildFromProperties(Properties properties, File propertiesLocation, ProbeJar jar, boolean isConfigReloading) {
        return new Configuration(properties, propertiesLocation, jar, isConfigReloading);
    }

    public static Configuration buildFromSystemProperties(Properties system, ProbeJar jar, boolean isConfigReloading) {
        String externalConfig = system.getProperty(SYSTEM_PROPERTIES_PREFIX + CONFIG_LOCATION);
        File externalConfigFile = null;
        if (!"system".equals(externalConfig)) {
            if (null != externalConfig) {
                externalConfigFile = new File(externalConfig);
            } else {
                String jarPath = jar.getJarPath();
                if (null != jarPath) {
                    externalConfigFile = new File(new File(jarPath).getParent(), NUDGE_PROPERTIES);
                }
            }
        }
        Properties properties = new Properties();
        if (null != externalConfigFile && externalConfigFile.isFile()) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(externalConfigFile);
                properties.load(input);
            }
            catch (IOException e) {
                try {
                    throw new IllegalStateException("unable to open configuration file " + externalConfigFile.getAbsolutePath(), e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(input);
        }
        for (Map.Entry<Object, Object> property : system.entrySet()) {
            String key = (String)property.getKey();
            if (!key.startsWith(SYSTEM_PROPERTIES_PREFIX)) continue;
            key = key.substring(SYSTEM_PROPERTIES_PREFIX.length());
            properties.put(key, property.getValue());
        }
        return Configuration.buildFromProperties(properties, externalConfigFile, jar, isConfigReloading);
    }

    private ConfigParam<List<String>> classpathListConfig(String name) {
        return this.addParam(new ConfigParam<List<String>>(name, NORMALIZE_CLASSPATH).defaultValue(Collections.emptyList()));
    }

    public boolean hasExplicitLogLevel() {
        return this.hasExplicitLogLevel;
    }

    public boolean useFineLogOnStartup() {
        return this.fineLogOnStartup;
    }

    private static String normalizeClassName(String className) {
        return className.replace('.', '/').trim();
    }

    public boolean isAllowedInstanceConfig() {
        return this.allowInstanceConfig;
    }

    public boolean prependTxTypeToUrl() {
        return this.prependTxType;
    }

    public boolean isLogRunnable() {
        return this.logRunnable;
    }

    public boolean isEjb3Logged() {
        return this.logEbj3;
    }

    public boolean isServletVersionPost_2_3() {
        return this.servletVersionPost2_3;
    }

    public boolean isLogServlet() {
        return this.logServlet;
    }

    public boolean isLogPortlet() {
        return this.logPortlet;
    }

    public boolean isLogServletContextListener() {
        return this.logServletContextListener;
    }

    public boolean isProfilingEnabled() {
        return this.profilingEnabled;
    }

    public int getProfilingThreadDepth() {
        return this.profilingThreadDepth;
    }

    public int getProfilingSampleInterval() {
        return this.profilingSampleInterval;
    }

    public int getProfilingSampleMaxTime() {
        return this.profilingSampleMaxTime;
    }

    public int getJmxSampleInterval() {
        return this.jmxSampleInterval;
    }

    public int getJmxSampleMaxTime() {
        return this.jmxSampleMaxTime;
    }

    public int getSystemSampleInterval() {
        return this.systemSampleInterval;
    }

    public int getSystemSampleMaxTime() {
        return this.systemSampleMaxTime;
    }

    public boolean isSystemMetricsEnabled() {
        return this.systemSampleEnabled;
    }

    public String getVersion() {
        return this.version;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public void setHandlers(List<String> handlers) {
        this.handlers = handlers;
    }

    public void setAllowInstanceConfig(boolean allowInstanceConfig) {
        this.allowInstanceConfig = allowInstanceConfig;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public void setDiskFallbackMaxSend(int diskFallbackMaxSend) {
        this.diskFallbackMaxSend = diskFallbackMaxSend;
    }

    public void setDiskFallbackIgnoreThreshold(long diskFallbackIgnoreThreshold) {
        this.diskFallbackIgnoreThreshold = diskFallbackIgnoreThreshold;
    }

    public void setDiskFallbackMaxSize(long diskFallbackMaxSize) {
        this.diskFallbackMaxSize = diskFallbackMaxSize;
    }

    public void setDiskFallbackDirectory(File diskFallbackDirectory) {
        this.diskFallbackDirectory = diskFallbackDirectory;
    }

    public void setDiskDumpMaxSize(long diskDumpMaxSize) {
        this.diskDumpMaxSize = diskDumpMaxSize;
    }

    public void setDiskDumpDirectory(File diskDumpDirectory) {
        this.diskDumpDirectory = diskDumpDirectory;
    }

    public void setPrependTxType(boolean prependTxType) {
        this.prependTxType = prependTxType;
    }

    public void setMbeansMonitored(List<String> mbeansMonitored) {
        this.mbeansMonitored = mbeansMonitored;
    }

    public void setInitialMbeansMonitored(List<String> initialMbeansMonitored) {
        this.initialMbeansMonitored = initialMbeansMonitored;
    }

    public void setMaxMbeanAttributesMonitored(int maxMbeanAttributesMonitored) {
        this.maxMbeanAttributesMonitored = maxMbeanAttributesMonitored;
    }

    public void setSystemSampleMaxTime(int systemSampleMaxTime) {
        this.systemSampleMaxTime = systemSampleMaxTime;
    }

    public void setCaptureHttpParams(boolean captureHttpParams) {
        this.captureHttpParams = captureHttpParams;
    }

    public void setIgnoredHttpParams(Set<String> ignoredHttpParams) {
        this.ignoredHttpParams = ignoredHttpParams;
    }

    public void setAllowedHttpParams(Set<String> allowedHttpParams) {
        this.allowedHttpParams = allowedHttpParams;
    }

    public void setCaptureHttpHeaders(boolean captureHttpHeaders) {
        this.captureHttpHeaders = captureHttpHeaders;
    }

    public void setIgnoredHttpHeaders(Set<String> ignoredHttpHeaders) {
        this.ignoredHttpHeaders = ignoredHttpHeaders;
    }

    public void setAllowedHttpHeaders(Set<String> allowedHttpHeaders) {
        this.allowedHttpHeaders = allowedHttpHeaders;
    }

    public void setHttpClientIp(boolean httpClientIp) {
        this.httpClientIp = httpClientIp;
    }

    public void setProfilingThreadDepth(int profilingThreadDepth) {
        this.profilingThreadDepth = profilingThreadDepth;
    }

    public void setProfilingSampleMaxTime(int profilingSampleMaxTime) {
        this.profilingSampleMaxTime = profilingSampleMaxTime;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getAppId() {
        return this.appId;
    }

    public List<String> getServerUrls() {
        return this.serverUrl;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public String getLogDirectory() {
        return this.logDirectory;
    }

    public long getDiskFallbackMaxSize() {
        return this.diskFallbackMaxSize;
    }

    public File getDiskFallbackDirectory() {
        return this.diskFallbackDirectory;
    }

    public File getDiskDumpDirectory() {
        return this.diskDumpDirectory;
    }

    public long getDiskDumpMaxSize() {
        return this.diskDumpMaxSize;
    }

    public int getDiskFallbackMaxSend() {
        return this.diskFallbackMaxSend;
    }

    public long getDiskFallbackIgnoreThreshold() {
        return this.diskFallbackIgnoreThreshold;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public boolean isParamsAllowed() {
        return this.captureHttpParams;
    }

    public Set<String> getIgnoredHttpParams() {
        return this.ignoredHttpParams;
    }

    public void setHostKey(int hostKey) {
        this.hostKey = hostKey;
    }

    public Set<String> getAllowedHttpParams() {
        return this.allowedHttpParams;
    }

    public boolean isParamAllowed(String param) {
        return this.captureHttpParams && Configuration.isAllowedItem(this.allowedHttpParams, this.ignoredHttpParams, param);
    }

    private static boolean isAllowedItem(Set<String> allowedSet, Set<String> ignoredSet, String name) {
        return allowedSet.contains(name) && !ignoredSet.contains(name);
    }

    public boolean isHeadersAllowed() {
        return this.captureHttpHeaders;
    }

    public Set<String> getIgnoredHttpHeaders() {
        return this.ignoredHttpHeaders;
    }

    public Set<String> getAllowedHttpHeaders() {
        return this.allowedHttpHeaders;
    }

    public boolean isHeaderAllowed(String header) {
        return this.captureHttpHeaders && Configuration.isAllowedItem(this.allowedHttpHeaders, this.ignoredHttpHeaders, header.toLowerCase());
    }

    public boolean ignoredClass(String className) {
        className = Configuration.normalizeClassName(className);
        for (String cp : this.includedClasspath) {
            if (!className.startsWith(cp)) continue;
            return false;
        }
        for (String cp : this.excludedClasspath) {
            if (!className.startsWith(cp)) continue;
            return true;
        }
        return false;
    }

    public boolean ignoredAutoClass(String className) {
        if (this.activateAutoExclusion) {
            for (String cp : this.autoExcludedClasspath) {
                if (!className.startsWith(cp)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean ignoredClassLoader(String classLoader) {
        for (String cp : this.excludedClassLoaders) {
            if (!classLoader.startsWith(cp)) continue;
            return true;
        }
        return false;
    }

    public List<String> getAopPointcuts() {
        return this.aopPointcuts;
    }

    public boolean isAnonymizableQuery(long ellapsed) {
        return this.isQueryAnonymizationActive && (this.longQueryThreshold == 0L || ellapsed < this.longQueryThreshold);
    }

    public boolean instrumentPSSetters() {
        return !this.isQueryAnonymizationActive || this.longQueryThreshold > 0L;
    }

    public long getLongQueryThreshold() {
        return this.longQueryThreshold;
    }

    public long getQueryCountLimit() {
        return this.queryCountLimit;
    }

    public boolean isInstrumentProxyClasses() {
        return this.instrumentProxyClasses;
    }

    public void setInstrumentProxyClasses(boolean instrumentProxyClasses) {
        this.instrumentProxyClasses = instrumentProxyClasses;
    }

    public List<String> getHandlers() {
        return this.handlers;
    }

    public boolean isRumActivated() {
        return this.activateRum;
    }

    public boolean isActivateJmx() {
        return this.activateJmx;
    }

    public List<String> getMbeansMonitored() {
        return this.mbeansMonitored;
    }

    public int getMaxMbeanAttributesMonitored() {
        return this.maxMbeanAttributesMonitored;
    }

    public int getThreadDumpFrequency() {
        return this.threadDumpFrequency;
    }

    public int getThreadDumpDuration() {
        return this.threadDumpDuration;
    }

    public boolean isLogStackTraceOnConnection() {
        return this.logStackTraceOnConnection;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public boolean dumpClasses() {
        return this.dumpClasses;
    }

    public boolean dumpAllClasses() {
        return this.dumpAllClasses;
    }

    public File dumpClassesDirectory() {
        return new File(this.getLogDirectory(), "classesDump");
    }

    public String getPropertiesPath() {
        return null != this.propertiesLocation ? this.propertiesLocation.getAbsolutePath() : null;
    }

    public String getLogPath() {
        return this.getLogDirectory() + File.separator + NUDGE_LOG;
    }

    public void setLogRunnable(boolean logRunnable) {
        this.logRunnable = logRunnable;
    }

    public boolean uploadLogEnabled() {
        return this.logUpload;
    }

    public boolean configUploadEnabled() {
        return this.configUpload;
    }

    public boolean traceInstrumentedCodeStackTraces() {
        return this.traceInstrumentedCodeStackTraces;
    }

    public int getlogRotationCount() {
        return this.logRotationCount;
    }

    private <T> ConfigParam<T> addParam(ConfigParam<T> param) {
        this.allParameters.add(param);
        return param;
    }

    private ConfigParam<String> stringConfig(String name) {
        return this.addParam(new ConfigParam<String>(name, new ConfigParam.ConvertFunction<String>(){

            @Override
            public String convert(String s) {
                return s;
            }
        }));
    }

    private ConfigParam<Boolean> booleanConfig(String name) {
        return this.addParam(new ConfigParam<Boolean>(name, new ConfigParam.ConvertFunction<Boolean>(){

            @Override
            public Boolean convert(String s) {
                return Boolean.parseBoolean(s);
            }
        }));
    }

    private ConfigParam<Integer> intConfig(final String name) {
        return this.addParam(new ConfigParam<Integer>(name, new ConfigParam.ConvertFunction<Integer>(){

            @Override
            public Integer convert(String s) {
                try {
                    return Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("%s must be an int value, current value: %s", name, s));
                }
            }
        }));
    }

    private ConfigParam<Long> longConfig(final String name) {
        return this.addParam(new ConfigParam<Long>(name, new ConfigParam.ConvertFunction<Long>(){

            @Override
            public Long convert(String s) {
                try {
                    return Long.parseLong(s);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("%s must be an int value, current value: %s", name, s));
                }
            }
        }));
    }

    private ConfigParam<Double> doubleConfig(final String name) {
        return this.addParam(new ConfigParam<Double>(name, new ConfigParam.ConvertFunction<Double>(){

            @Override
            public Double convert(String s) {
                try {
                    return Double.parseDouble(s);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("%s must be a double value, current value: %s", name, s));
                }
            }
        }));
    }

    private ConfigParam<List<String>> stringListConfig(String name, String separator) {
        return this.stringListConfig(name, separator, null);
    }

    private ConfigParam<List<String>> stringListConfig(String name, final String separator, final ConfigParam.ConvertFunction<String> normalizeFunction) {
        return this.addParam(new ConfigParam<List<String>>(name, new ConfigParam.ConvertFunction<List<String>>(){

            @Override
            public List<String> convert(String s) {
                String[] parts = s.split(separator);
                ArrayList<String> result = new ArrayList<String>();
                for (String part : parts) {
                    String value = part.trim();
                    if (value.length() <= 0) continue;
                    if (null == normalizeFunction) {
                        result.add(value);
                        continue;
                    }
                    result.add((String)normalizeFunction.convert(value));
                }
                return result;
            }
        })).defaultValue(Collections.emptyList());
    }

    private ConfigParam<Set<String>> httpHeaderConfig(String name) {
        return this.addParam(new ConfigParam<Set<String>>(name, new ConfigParam.ConvertFunction<Set<String>>(){

            @Override
            public Set<String> convert(String s) {
                String[] parts = s.split(",");
                HashSet<String> result = new HashSet<String>();
                for (String part : parts) {
                    String value = part.trim();
                    if (value.length() <= 0) continue;
                    result.add(value.toLowerCase());
                }
                return result;
            }
        })).defaultValue(Collections.emptySet());
    }

    private ConfigParam<Proxy.Type> proxyType(String name) {
        return this.addParam(new ConfigParam<Proxy.Type>(name, new ConfigParam.ConvertFunction<Proxy.Type>(){

            @Override
            public Proxy.Type convert(String s) {
                return Proxy.Type.valueOf(s);
            }
        }));
    }

    private ConfigParam<Level> logLevel(String name) {
        return this.addParam(new ConfigParam<Level>(name, new ConfigParam.ConvertFunction<Level>(){

            @Override
            public Level convert(String s) {
                return Level.valueOf(s);
            }
        })).defaultValue(Level.INFO);
    }

    private String getLogDirWithFallback(Properties properties, ProbeJar jar, boolean isConfigReloading) {
        String logDirectory = null;
        ArrayList<File> folders = new ArrayList<File>();
        String path = this.stringConfig("log_directory").load(properties, isConfigReloading);
        if (null != path) {
            folders.add(new File(path));
        }
        if (null != (path = jar.getJarPath())) {
            File jarFile = new File(path);
            folders.add(new File(jarFile.getParentFile(), "log"));
        }
        for (File folder : folders) {
            try {
                logDirectory = folder.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (folder.exists() || folder.mkdir()) break;
            logDirectory = null;
        }
        Checker.checkState(null != logDirectory, String.format("unable to find any writable folder for log (%s), please use explicit log_directory to fix that", ((Object)folders).toString()));
        return logDirectory;
    }

    void writeConfiguration(Logger log) {
        for (ConfigParam<?> param : this.allParameters) {
            if (!param.isMandatory() && param.isDefaultValue() && !log.isLoggable(Level.FINEST)) continue;
            log.severe("config " + param.getPrintValue(), new Object[0]);
        }
    }

    List<ConfigParam<?>> getAllParameters() {
        return this.allParameters;
    }

    private ConfigParam.ValidateFunction<Integer> minimum(final int min) {
        return new ConfigParam.ValidateFunction<Integer>(){

            @Override
            public void validate(Integer value) {
                Checker.checkArgument(value >= min);
            }
        };
    }

    private ConfigParam.ValidateFunction<Integer> between(final int min, final int max) {
        return new ConfigParam.ValidateFunction<Integer>(){

            @Override
            public void validate(Integer value) {
                Checker.checkArgument(value >= min && value <= max);
            }
        };
    }

    public boolean isProbeEnabled() {
        return this.probeEnabled;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public ConnectorConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    public boolean isComponentScanEnabled() {
        return this.componentScanEnabled;
    }

    public boolean isCollectorEnabled() {
        return this.collectorEnabled;
    }

    public int getFlushRumCount() {
        return this.flushRumCount;
    }

    public boolean isLogSpringMvc() {
        return this.logSpringMvc;
    }

    public boolean isCaptureHttpClientIp() {
        return this.httpClientIp;
    }

    public boolean isWebServiceLogged() {
        return this.logWebService;
    }

    public void applyControllerConfig() {
        Properties ctrlProps = new Properties();
        try {
            FileInputStream is = new FileInputStream(new File(this.diskDumpDirectory, CONTROLLER_PROPERTIES));
            try {
                ctrlProps.load(is);
                if (ctrlProps.containsKey(SERVER_URL_KEY)) {
                    this.serverUrl = this.loadServerUrlFromProps(ctrlProps, false);
                }
                if (ctrlProps.containsKey("mbeans_monitored")) {
                    this.mbeansMonitored = this.stringListConfig("mbeans_monitored", ";").load(ctrlProps, false);
                    this.mbeansMonitored.addAll(this.initialMbeansMonitored);
                }
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read controller config file", e);
        }
    }

    private List<String> loadServerUrlFromProps(Properties props, boolean isConfigReloading) {
        List<Object> serverUrl = new ArrayList();
        serverUrl = this.stringListConfig(SERVER_URL_KEY, ",", NORMALIZE_SERVER_URL).load(props, isConfigReloading);
        if (serverUrl.isEmpty()) {
            serverUrl = Arrays.asList(SERVER_URL_DEFAULT_VALUE);
        }
        return serverUrl;
    }

    public boolean allowHotReloading() {
        return this.allowHotReloading;
    }

    public int getFlushFilteringRate() {
        return this.flushFilteringRate;
    }

    public TransactionFilter.ReducingType getFlushFilteringType(String flushFilteringTypeString) {
        if ("time".equalsIgnoreCase(flushFilteringTypeString)) {
            return TransactionFilter.ReducingType.DURATION;
        }
        if ("random".equalsIgnoreCase(flushFilteringTypeString)) {
            return TransactionFilter.ReducingType.RANDOM;
        }
        return TransactionFilter.ReducingType.NONE;
    }

    public String getFlushFilteringTypeStr() {
        return this.flushFilteringTypeStr;
    }
}

