/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe;

import org.nudge.probe.Configuration;
import org.nudge.probe.NudgeLogger;
import org.nudge.probe.NudgeLoggerImpl;
import org.nudge.probe.TxUuid;
import org.nudge.probe.collector.Collector;
import org.nudge.probe.events.NudgeStackImpl;
import org.nudge.probe.events.StackTracer;
import org.nudge.probe.util.Checker;

public class LoggerFactory {
    private static LoggerFactory INSTANCE = null;
    private final Configuration config;
    private final Collector collector;
    private final ThreadLocal<NudgeLogger> LOGGER;
    private final TxUuid uuid;
    private final StackTracer tracer;

    public LoggerFactory(Configuration config, Collector collector, TxUuid uuid, StackTracer tracer) {
        Checker.checkArgument(null != config);
        Checker.checkArgument(null != collector);
        this.config = config;
        this.collector = collector;
        this.LOGGER = new ThreadLocal();
        this.uuid = uuid;
        this.tracer = tracer;
    }

    protected LoggerFactory() {
        this.LOGGER = null;
        this.config = null;
        this.collector = null;
        this.uuid = null;
        this.tracer = null;
    }

    protected NudgeLogger getOrCreateThreadLogger() {
        NudgeLogger logger = this.LOGGER.get();
        if (logger != null) {
            if (!logger.isNewThread()) {
                return logger;
            }
            this.LOGGER.remove();
        }
        NudgeStackImpl stack = new NudgeStackImpl(this.collector, this.uuid, this.tracer);
        logger = new NudgeLoggerImpl(this.collector, this.config, this.uuid, stack, this.tracer, true);
        this.LOGGER.set(logger);
        return logger;
    }

    public static void setLoggerFactory(LoggerFactory lf) {
        Checker.checkArgument(null != lf);
        INSTANCE = lf;
    }

    public static LoggerFactory getLoggerFactory() {
        Checker.checkState(null != INSTANCE);
        return INSTANCE;
    }

    public static NudgeLogger getLogger() {
        Checker.checkState(null != INSTANCE);
        return INSTANCE.getOrCreateThreadLogger();
    }
}

