/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarFile;
import org.nudge.probe.Configuration;
import org.nudge.probe.ProbeJar;
import org.nudge.probe.collector.HttpConnector;
import org.nudge.probe.collector.NudgeConnector;
import org.nudge.probe.conf.ConfigParam;
import org.nudge.probe.json.Listener;
import org.nudge.probe.jvm.JvmInfo;
import org.nudge.probe.logparser.ApacheLogParser;
import org.nudge.probe.spi.NudgeProbeSpi;
import org.nudge.probe.util.ConnectionTest;
import org.nudge.probe.util.LogAnalyzer;
import org.nudge.probe.util.RawdataReader;
import org.nudge.probe.util.RawdataViewer;

public class Main {
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            Main.usage();
            System.exit(1);
        }
        if ("-tc".equals(args[0]) || "-testConnection".equals(args[0])) {
            Main.testConnection();
            return;
        }
        if ("-bj".equals(args[0]) || "-startJSonDaemon".equals(args[0])) {
            Main.startListener();
            return;
        }
        if ("-ej".equals(args[0]) || "-stopJSonDaemon".equals(args[0])) {
            System.out.println("Stopping json listener ...");
            Listener.stop();
            return;
        }
        if ("-pa".equals(args[0]) || "-printAppRawdata".equals(args[0])) {
            if (args.length < 2) {
                Main.usage();
                System.exit(1);
            }
            RawdataReader.printAppRawdata(args[1]);
            return;
        }
        if ("-ps".equals(args[0]) || "-printSysRawdata".equals(args[0])) {
            if (args.length < 2) {
                Main.usage();
                System.exit(1);
            }
            RawdataReader.printSysRawdata(args[1]);
            return;
        }
        if ("-va".equals(args[0]) || "-viewAppRawdata".equals(args[0])) {
            if (args.length < 2) {
                Main.usage();
                System.exit(1);
            }
            RawdataViewer.viewRawdata(Main.getFilesFromArgs(args), false);
            return;
        }
        if ("-vs".equals(args[0]) || "-viewSysRawdata".equals(args[0])) {
            if (args.length < 2) {
                Main.usage();
                System.exit(1);
            }
            RawdataViewer.viewRawdata(Main.getFilesFromArgs(args), true);
            return;
        }
        if ("-al".equals(args[0]) || "-analyzeLog".equals(args[0])) {
            if (args.length < 2) {
                Main.usage();
                System.exit(1);
            }
            LogAnalyzer.packageDistribution(args[1]);
            return;
        }
        if ("-v".equals(args[0]) || "-version".equals(args[0])) {
            JarFile j = new JarFile(Main.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            System.out.println("Current version is " + j.getManifest().getMainAttributes().getValue("Implementation-Version"));
            j.close();
            return;
        }
        if ("-a2jl".equals(args[0]) || "-apache2jsonlog".equals(args[0])) {
            if (args.length < 2) {
                System.err.println("missing log file");
                Main.usage();
                System.exit(1);
            }
            ApacheLogParser.uploadFile(args[1]);
            return;
        }
        if ("-lp".equals(args[0]) || "-listparameters".equals(args[0])) {
            Main.listParameters();
            return;
        }
        if ("-dd".equals(args[0]) || "-datadogConvert".equals(args[0])) {
            if (args.length < 2) {
                Main.usage();
                System.exit(1);
            }
            RawdataReader.convertToDatadogTraces(args[1], true, args.length > 2 ? args[2] : null);
            return;
        }
        if ("-jdd".equals(args[0]) || "-jsonDatadogConvert".equals(args[0])) {
            if (args.length < 2) {
                Main.usage();
                System.exit(1);
            }
            RawdataReader.convertToDatadogTraces(args[1], false, args.length > 2 ? args[2] : null);
            return;
        }
        Main.usage();
        System.exit(1);
    }

    private static void listParameters() {
        Configuration config = Main.getConfig();
        for (ConfigParam<?> param : config.getAllParameters()) {
            System.out.println(String.format("%s | default = %s | %s", param.getName(), param.getDefaultValue(), param.isMandatory() ? "mandatory" : "optional"));
        }
    }

    private static void startListener() throws Exception {
        System.out.println("Launching json listener ...");
        Configuration config = Main.getConfig();
        HttpConnector httpConnector = NudgeProbeSpi.getProbeSpi(config, new JvmInfo(config)).newHttpConnector();
        NudgeConnector nudgeConnector = new NudgeConnector(config, httpConnector);
        Listener.start(config, nudgeConnector);
    }

    private static void testConnection() {
        Configuration config = Main.getConfig();
        HttpConnector httpConnector = NudgeProbeSpi.getProbeSpi(config, new JvmInfo(config)).newHttpConnector();
        ConnectionTest.test(config, httpConnector);
    }

    private static List<String> getFilesFromArgs(String[] args) {
        return Arrays.asList(args).subList(1, args.length);
    }

    private static void usage() {
        System.out.println("Usage: java -jar nudge-x.x.xx.jar [-command] [args]");
        System.out.println("The following commands are available:");
        System.out.println("    -v    | -version                   Displays agent version");
        System.out.println("    -tc   | -testConnection            Test connection to nudge server using nudge.properties");
        System.out.println("    -pa   | -printAppRawdata [file]    Dumps an app rawdata content in standard output");
        System.out.println("    -ps   | -printSysRawdata [file]    Dumps a system rawdata content in standard output");
        System.out.println("    -va   | -viewAppRawdata [file+]    Displays an app rawdata(s)");
        System.out.println("    -vs   | -viewSysRawdata [file+]    Displays a system rawdata(s)");
        System.out.println("    -bj   | -startJSonDaemon           Launches JSon listener daemon");
        System.out.println("    -ej   | -stopJSonDaemon            Interrupts JSon listener daemon");
        System.out.println("    -al   | -analyzeLog                Evaluates and dumps package distribution");
        System.out.println("    -a2jl | -apache2jsonlog [file]     Parse & upoad apache2 json log");
        System.out.println("    -lp   | -listparameters            List all available parameters");
        System.out.println("    -dd   | -datadogConvert [file]     Convert rawdata transactions to datadog traces");
        System.out.println("    -jdd  | -jsonDatadogConvert [file] Convert rawdata transactions to datadog traces json fmt");
    }

    private static Configuration getConfig() {
        Properties properties = new Properties(System.getProperties());
        properties.put("nudge.app_id", "00000000-0000-0000-0000-000000000000");
        return Configuration.buildFromSystemProperties(properties, ProbeJar.fromPackaging(), false);
    }
}

