/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe;

import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.nudge.dependency.oaci.FileUtils;
import org.nudge.probe.Configuration;
import org.nudge.probe.CurrentTime;
import org.nudge.probe.LoggerFactory;
import org.nudge.probe.NudgeClassFileTransformer;
import org.nudge.probe.ProbeJar;
import org.nudge.probe.ThreadBasedTxUuid;
import org.nudge.probe.Util;
import org.nudge.probe.collector.CollectorImpl;
import org.nudge.probe.collector.NudgeConnector;
import org.nudge.probe.collector.Orchestrator;
import org.nudge.probe.events.StackTracer;
import org.nudge.probe.jvm.JvmInfo;
import org.nudge.probe.libscan.LibScanTransformer;
import org.nudge.probe.log.Logger;
import org.nudge.probe.sampler.JmxBeansSampler;
import org.nudge.probe.sampler.ProfilingSampler;
import org.nudge.probe.sampler.SystemSampler;
import org.nudge.probe.spi.NudgeProbe;
import org.nudge.probe.spi.NudgeProbeSpi;
import org.nudge.probe.watch.WatchFile;

public class NudgeAgent {
    private static final int LATE_INIT_DELAY_SECONDS = 60;
    private static final String MSG_TEMPLATE = "[NUDGE] JAVAAGENT ";
    private static final AtomicBoolean started = new AtomicBoolean(false);
    public static final String JBOSS_MODULES_SYSTEM_PKGS = "jboss.modules.system.pkgs";
    public static final String PROBE_PKG = "org.nudge";
    public static final String JBOSS_PLATFORM_MBEANSERVER = "jboss.platform.mbeanserver";
    public static Configuration staticConfiguration;

    public static void premain(String agentArgs, Instrumentation inst) {
        try {
            if (started.getAndSet(true)) {
                NudgeAgent.error("already started", null);
                return;
            }
            ProbeJar jar = ProbeJar.fromPackaging();
            jar.checkJarName();
            Properties systemProperties = System.getProperties();
            NudgeAgent.initAgent(jar, systemProperties, inst);
        }
        catch (Exception e) {
            NudgeAgent.error("Error during Agent bootstrap", e);
            e.printStackTrace(System.err);
        }
    }

    private static void info(String msg, Logger log) {
        System.out.println(MSG_TEMPLATE + msg);
        if (null != log) {
            log.info(msg, new Object[0]);
        }
    }

    private static void error(String msg, Throwable t) {
        System.err.println(MSG_TEMPLATE + msg);
        if (null != t) {
            t.printStackTrace(System.err);
        }
    }

    static void initAgent(ProbeJar jar, Properties systemProperties, Instrumentation inst) throws Exception {
        NudgeAgent.overrideRequiredSystemProperties(systemProperties);
        Configuration config = Configuration.buildFromSystemProperties(systemProperties, jar, false);
        if (!config.isProbeEnabled()) {
            return;
        }
        Logger.setupAndRotate(config);
        Logger log = Logger.getLogger(null);
        NudgeAgent.info("START " + jar.getJarPath(), log);
        String propertiesPath = config.getPropertiesPath();
        if (null != propertiesPath) {
            NudgeAgent.info("CONFIG " + propertiesPath, log);
        }
        NudgeAgent.info("LOG " + config.getLogPath(), log);
        log.info("Version %s", jar.getVersion());
        config.writeConfiguration(log);
        if (config.dumpClasses() || config.dumpAllClasses()) {
            try {
                FileUtils.deleteDirectory(config.dumpClassesDirectory());
            }
            catch (IOException e) {
                log.severe("unable to delete directory %s", config.dumpClassesDirectory());
            }
        }
        if (config.allowHotReloading()) {
            new Thread(new WatchFile(config)).start();
            log.info("Probe configuration : HOT RELOADING ACTIVATED", new Object[0]);
        } else {
            log.info("Probe configuration : hot reloading disabled due to property allow_hot_reloading set to false", new Object[0]);
        }
        JvmInfo jvmInfo = new JvmInfo(config);
        NudgeProbe probeSpi = NudgeProbeSpi.getProbeSpi(config, jvmInfo);
        ThreadBasedTxUuid uuid = new ThreadBasedTxUuid();
        CollectorImpl collector = new CollectorImpl(config, jvmInfo, new NudgeConnector(config, probeSpi.newHttpConnector()));
        Orchestrator orchestrator = Orchestrator.probeMode(config, 60000, collector);
        orchestrator.register(jvmInfo);
        orchestrator.register(jar);
        CurrentTime time = Util.getSystemTime();
        orchestrator.register(new ProfilingSampler(collector, config, uuid, time));
        orchestrator.register(new JmxBeansSampler(collector, config, time));
        orchestrator.register(new SystemSampler(collector, probeSpi, config, time));
        orchestrator.start();
        StackTracer tracer = new StackTracer(config);
        LoggerFactory.setLoggerFactory(new LoggerFactory(config, collector, uuid, tracer));
        if (null != inst) {
            inst.addTransformer(new NudgeClassFileTransformer(config, probeSpi));
            if (config.isComponentScanEnabled()) {
                inst.addTransformer(new LibScanTransformer(collector));
            }
        }
    }

    private static void overrideRequiredSystemProperties(Properties systemProperties) {
        if (!NudgeAgent.isJboss(systemProperties)) {
            return;
        }
        String jbossPkgs = systemProperties.getProperty(JBOSS_MODULES_SYSTEM_PKGS);
        if (null == jbossPkgs || jbossPkgs.length() == 0) {
            jbossPkgs = PROBE_PKG;
        } else if (!jbossPkgs.contains(PROBE_PKG)) {
            jbossPkgs = String.format("%s,%s", jbossPkgs, PROBE_PKG);
        }
        systemProperties.setProperty(JBOSS_MODULES_SYSTEM_PKGS, jbossPkgs);
        String mbeanServer = systemProperties.getProperty(JBOSS_PLATFORM_MBEANSERVER);
        if (null == mbeanServer) {
            systemProperties.setProperty(JBOSS_PLATFORM_MBEANSERVER, "");
        }
    }

    private static boolean isJboss(Properties systemProperties) {
        String mainClass = (String)systemProperties.get("sun.java.command");
        return mainClass != null && mainClass.startsWith("org.jboss.");
    }
}

