/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.List;
import org.nudge.dependency.oaci.FileUtils;
import org.nudge.probe.BytecodeWitch;
import org.nudge.probe.ClassBlackList;
import org.nudge.probe.Configuration;
import org.nudge.probe.NudgeClassVisitor;
import org.nudge.probe.log.Logger;
import org.nudge.probe.spi.NudgeProbe;
import org.nudge.probe.util.Checker;
import org.nudge.probe.weave.aop.AopPoincut;

public class NudgeClassFileTransformer
implements ClassFileTransformer {
    private static final Logger log = Logger.getLogger(NudgeClassFileTransformer.class.getName());
    private final Configuration config;
    private final NudgeProbe factory;
    private final List<AopPoincut> aopPoincuts;

    NudgeClassFileTransformer(Configuration config, NudgeProbe factory) {
        Checker.checkArgument(null != config);
        Checker.checkArgument(null != factory);
        this.config = config;
        this.factory = factory;
        this.aopPoincuts = AopPoincut.parseList(config.getAopPointcuts());
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain domain, byte[] origBytes) {
        byte[] fixedBytecode;
        if (null == className) {
            return null;
        }
        String loaderDisplayName = NudgeClassFileTransformer.safeClassLoaderName(loader);
        if (this.config.dumpAllClasses()) {
            this.dumpClass(loader, "dump", className, origBytes);
        }
        if (ClassBlackList.contains(className)) {
            if (this.isAop(className)) {
                log.severe("ignored class explicitly included by configuration : %s (%s)", className, loaderDisplayName);
            } else {
                log.fine("ignored class : %s (%s)", className, loaderDisplayName);
                return null;
            }
        }
        if (this.config.ignoredClass(className)) {
            log.fine("class not scanned (either excluded_classpath or included_classpath) : %s (%s)", className, loaderDisplayName);
            return null;
        }
        if (this.config.ignoredAutoClass(className)) {
            return null;
        }
        log.fine("checking instrumentability for - %s (%s)", className, loaderDisplayName);
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        String loaderName = "";
        if (loader != null) {
            loaderName = loader.getClass().getName() + loader.hashCode();
            if (this.config.ignoredClassLoader(loaderName)) {
                return null;
            }
            if (loaderName.startsWith("sun.reflect.DelegatingClassLoader") || loaderName.startsWith("org.mortbay.jetty.webapp.WebAppClassLoader")) {
                ClassLoader parent = loader.getParent();
                if (parent == null) {
                    return null;
                }
                loaderName = parent.getClass().getName() + parent.hashCode();
            }
        }
        if (null != (fixedBytecode = BytecodeWitch.fixBytecode(className, origBytes, loader))) {
            if (this.config.dumpClasses()) {
                this.dumpClass(loader, "before", className, origBytes);
                this.dumpClass(loader, "after", className, fixedBytecode);
            }
            origBytes = fixedBytecode;
        }
        byte[] transformedCode = null;
        try {
            NudgeClassVisitor visitor = new NudgeClassVisitor(className, origBytes, loader, this.factory, this.config.isInstrumentProxyClasses());
            transformedCode = visitor.transform();
            if (this.config.dumpClasses() && null != transformedCode) {
                this.dumpClass(loader, "before", className, origBytes);
                this.dumpClass(loader, "after", className, transformedCode);
            }
        }
        catch (Exception e) {
            this.dumpClass(loader, "failed", className, origBytes);
            log.severe(e, "Failed to instrument " + className + " : " + e.getMessage(), new Object[0]);
        }
        return this.config.isDryRun() ? origBytes : transformedCode;
    }

    private boolean isAop(String className) {
        for (AopPoincut pointcut : this.aopPoincuts) {
            if (!pointcut.classMatches(className)) continue;
            return true;
        }
        return false;
    }

    private void dumpClass(ClassLoader cl, String folder, String className, byte[] bytes) {
        if (null == cl) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if (null != cl) {
            NudgeClassFileTransformer.writeToFile(bytes, new File(this.config.dumpClassesDirectory(), "/" + folder + "/" + NudgeClassFileTransformer.safeClassLoaderName(cl) + "/" + NudgeClassFileTransformer.safeFileName(className) + ".class"));
        }
    }

    private static String safeClassLoaderName(ClassLoader cl) {
        return null == cl ? "BootstrapClassLoader" : NudgeClassFileTransformer.safeFileName(String.format("%s_%x", cl.getClass().getName(), cl.hashCode()));
    }

    private static String safeFileName(String name) {
        return name.replace('$', '_');
    }

    private static void writeToFile(byte[] bytes, File file) {
        FileUtils.deleteQuietly(file);
        file.getParentFile().mkdirs();
        try {
            FileUtils.writeByteArrayToFile(file, bytes);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

