/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.nudge.javassist.CannotCompileException;
import org.nudge.javassist.ClassPool;
import org.nudge.javassist.CtClass;
import org.nudge.javassist.LoaderClassPath;
import org.nudge.javassist.NotFoundException;
import org.nudge.probe.log.Level;
import org.nudge.probe.log.Logger;
import org.nudge.probe.spi.NudgeProbe;
import org.nudge.probe.util.Checker;
import org.nudge.probe.weave.AbstractWeaver;
import org.nudge.probe.weave.ClassDef;

public class NudgeClassVisitor {
    private static final Logger log = Logger.getLogger(NudgeClassVisitor.class.getName());
    private final String className;
    private byte[] classBytes;
    private ClassLoader cl;
    private boolean iterateThroughSuperClass = false;
    private List<AbstractWeaver> classChain;
    private List<AbstractWeaver> superClassChain;
    private List<AbstractWeaver> interfaceChain;
    private ClassPool classPool;
    private CtClass ctClass;
    boolean instrumentProxyClasses;
    private long estimatedInstrumentationTime;
    private final List<String> weaverNames;
    private boolean instrumentationSuccess = false;
    private boolean useAsm = false;
    private boolean useJavassist = false;
    private final NudgeProbe nudgeProbe;

    public NudgeClassVisitor(String className, byte[] classBytes, ClassLoader cl, NudgeProbe nudgeProbe, boolean instrumentProxyClasses) {
        this.className = className;
        this.classBytes = classBytes;
        this.cl = cl;
        this.nudgeProbe = nudgeProbe;
        this.weaverNames = new ArrayList<String>(0);
        this.instrumentProxyClasses = instrumentProxyClasses;
    }

    public boolean instrumentProxyClasses(ClassDef classDef) {
        return classDef.isJdkProxy() && !this.instrumentProxyClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] transform() {
        block28: {
            ClassDef classDef = ClassDef.fromBytecode(this.classBytes, this.cl);
            if (classDef.isInterface() || classDef.isAnnotation() || classDef.isEnum() || this.instrumentProxyClasses(classDef)) {
                return null;
            }
            if (this.className.startsWith("java/") || this.className.startsWith("sun/")) {
                this.classChain = this.nudgeProbe.buildJdkChain();
            } else if (this.className.startsWith("javax/swing")) {
                this.superClassChain = this.nudgeProbe.buildSwingChain();
            } else if (this.isJdbcDriver()) {
                this.interfaceChain = this.nudgeProbe.buildJdbcInterfaceChain();
            } else if (this.className.startsWith("com/rabbitmq/client")) {
                this.interfaceChain = this.nudgeProbe.buildInterfaceRabbitMQDriver();
            } else if (this.className.startsWith("org/springframework/web")) {
                this.superClassChain = this.nudgeProbe.buildSpringWebSuperClassChain();
                this.iterateThroughSuperClass = true;
            } else if (this.className.startsWith("com/mongodb/client/internal") || this.className.equals("com/mongodb/client/MongoClients")) {
                this.classChain = this.nudgeProbe.buildMongoChain();
            } else {
                this.classChain = this.nudgeProbe.buildClassChain(this.cl);
                this.superClassChain = this.nudgeProbe.buildSuperClassChain();
                this.interfaceChain = this.nudgeProbe.buildInterfaceChain();
            }
            try {
                String superName;
                if (this.classChain != null) {
                    for (AbstractWeaver weaver : this.classChain) {
                        boolean matches = weaver.matches(classDef, this.cl);
                        if (!matches) continue;
                        this.instrument(weaver);
                    }
                }
                this.processSuperClassChain(classDef);
                this.processInterfaceChain(classDef);
                ClassDef superClassDef = classDef;
                while (this.iterateThroughSuperClass && (superName = superClassDef.getSuperName()) != null && !"java/lang/object".equals(superClassDef.getSuperName())) {
                    superClassDef = ClassDef.fromClassLoaderResource(superName, this.cl);
                    if (superClassDef == null) {
                        log.fine("superclass couldn't be loaded: %s (%s)", superName, classDef.getName());
                        break;
                    }
                    this.processSuperClassChain(superClassDef);
                    this.processInterfaceChain(superClassDef);
                }
                if (!this.instrumentationSuccess) break block28;
                if (this.useJavassist) {
                    try {
                        this.classBytes = this.ctClass.toBytecode();
                    }
                    catch (IOException ioe) {
                        log.severe(ioe, "generate class bytecode", new Object[0]);
                    }
                    catch (CannotCompileException cce) {
                        log.severe(cce, "generate class bytecode", new Object[0]);
                    }
                }
                log.info("instrumentation : %s %s - %d ms", this.className, this.weaverNames.toString(), this.estimatedInstrumentationTime / 1000000L);
            }
            catch (Exception e) {
                log.severe("error during instrumentation : %s - %s [%s]", this.className, e.getMessage(), this.weaverNames.toString());
                if (log.isLoggable(Level.INFO)) {
                    log.info(e, e.getMessage());
                }
            }
            finally {
                this.releaseRessources();
            }
        }
        if (this.instrumentationSuccess) {
            return this.classBytes;
        }
        return null;
    }

    private void processSuperClassChain(ClassDef classDef) throws IOException, CannotCompileException, NotFoundException {
        if (classDef.getSuperName() == null || this.superClassChain == null || "java/lang/Object".equals(classDef.getSuperName())) {
            return;
        }
        ArrayList<AbstractWeaver> matches = new ArrayList<AbstractWeaver>();
        for (AbstractWeaver weaver : this.superClassChain) {
            if (!weaver.matches(classDef, this.cl)) continue;
            this.instrument(weaver);
            matches.add(weaver);
            this.instrumentationSuccess = true;
        }
        this.superClassChain.removeAll(matches);
    }

    private void processInterfaceChain(ClassDef cd) throws IOException, CannotCompileException, NotFoundException {
        if (this.interfaceChain == null) {
            return;
        }
        ArrayList<AbstractWeaver> matches = new ArrayList<AbstractWeaver>();
        for (AbstractWeaver weaver : this.interfaceChain) {
            if (!weaver.matches(cd, this.cl)) continue;
            this.instrument(weaver);
            matches.add(weaver);
            this.instrumentationSuccess = true;
        }
        this.interfaceChain.removeAll(matches);
    }

    private void instrument(AbstractWeaver weaver) throws CannotCompileException, NotFoundException, IOException {
        long t0 = System.nanoTime();
        String weaverName = weaver.getClass().getSimpleName();
        if (weaver.useAsmInstrumentation()) {
            this.useAsm = true;
            Checker.checkState(!this.useJavassist, "mixing asm and javassist weavers is not supported " + weaverName);
            try {
                this.classBytes = weaver.instrument(this.classBytes, this.className, this.cl);
                this.instrumentationSuccess = true;
            }
            catch (Throwable e) {
                this.instrumentationSuccess = false;
                log.severe(e, "instrumentation failure %s by %s", this.className, weaver.getClass());
            }
        } else {
            this.useJavassist = true;
            Checker.checkState(!this.useAsm, "mixing asm and javassist weavers is not supported " + weaverName);
            CtClass classDefinition = this.getCtClass();
            if (classDefinition.isFrozen()) {
                log.warning("class already instrumented indirectly : %s", this.className);
                this.instrumentationSuccess = false;
            } else {
                weaver.instrument(classDefinition);
            }
            this.instrumentationSuccess = true;
        }
        this.estimatedInstrumentationTime += System.nanoTime() - t0;
        if (this.instrumentationSuccess) {
            this.weaverNames.add(weaverName);
        }
    }

    private boolean isJdbcDriver() {
        return this.className.startsWith("com/mysql/jdbc/") || this.className.startsWith("oracle/jdbc/") || this.className.startsWith("org/postgresql/") || this.className.startsWith("net/sourceforge/jtds/") || this.className.startsWith("com/sybase/jdbc") || this.className.startsWith("org/apache/derby/jdbc") || this.className.startsWith("org/h2/") || this.className.startsWith("com/ibm/db2/jcc") || this.className.startsWith("com/zaxxer/hikari/") || this.className.startsWith("com/microsoft/sqlserver/jdbc") || this.className.startsWith("java/sql") || this.className.startsWith("javax/sql/") || this.className.startsWith("weblogic/jdbc/wrapper/");
    }

    private CtClass getCtClass() throws IOException {
        if (this.ctClass == null) {
            this.classPool = new ClassPool(true);
            this.classPool.appendSystemPath();
            this.classPool.insertClassPath(new LoaderClassPath(this.cl));
            this.ctClass = this.classPool.makeClass(new ByteArrayInputStream(this.classBytes));
        }
        return this.ctClass;
    }

    private void releaseRessources() {
        if (this.ctClass != null) {
            this.ctClass.detach();
            this.ctClass = null;
            this.classPool = null;
        }
        this.cl = null;
    }
}

