/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.nudge.dependency.cnab.probe.RawDataProtocol;
import org.nudge.probe.Anonymizer;
import org.nudge.probe.Configuration;
import org.nudge.probe.EventType;
import org.nudge.probe.NudgeLogger;
import org.nudge.probe.TxUuid;
import org.nudge.probe.Util;
import org.nudge.probe.collector.Collector;
import org.nudge.probe.events.ExtendedCode;
import org.nudge.probe.events.InstrumentationPoint;
import org.nudge.probe.events.LogEventBuilder;
import org.nudge.probe.events.LogEventBuilderFactory;
import org.nudge.probe.events.NudgeStack;
import org.nudge.probe.events.ProtocolFacade;
import org.nudge.probe.events.StackTracer;
import org.nudge.probe.log.Level;
import org.nudge.probe.log.Logger;
import org.nudge.probe.troubleshooting.NudgeConnectionLeakSuspected;
import org.nudge.probe.util.Checker;
import org.nudge.probe.util.RawdataUtil;
import org.nudge.probe.weave.jdbc.JdbcConnectionNudge;
import org.nudge.probe.weave.jdbc.JdbcMetadata;

public class NudgeLoggerImpl
implements NudgeLogger {
    private static final Logger log = Logger.getLogger(Configuration.DEFAULT_LOGGER_NAME);
    private final boolean safe;
    private final NudgeStack currentStack;
    private final TxUuid uuid;
    private final Configuration config;
    private final Collector collector;
    private final Anonymizer anonymizer;
    private final StackTracer tracer;
    private boolean isNewThread = false;
    private final Set<String> headerKeys = new HashSet<String>();
    private final DbMetric dbMetrics = new DbMetric();
    private String url;
    @Deprecated
    private boolean logSql = true;
    private long currentSqlId = 0L;
    private long currentSqlExecStart;
    private int currentSqlExecCount;
    private String currentDbUrl;
    private String currentSql;
    private int currentJdbcFetchCount;
    private long currentJdbcCommitStart;
    private int currentJdbcCommitCount;
    private long currentJdbcRollbackStart;
    private int currentJdbcRollbackCount;
    private final Map<Integer, Map<Integer, Object>> sqlParametersValue = new HashMap<Integer, Map<Integer, Object>>();
    private long currentJMSExecStart;
    private int currentJMSExecCount;
    private boolean currentJMSExecStatus = true;
    private int currentMemcachedCount;
    private long currentMemcachedStart;
    private int swingEdtCounter;
    private final HashSet<String> swingEdtSet = new HashSet();

    public NudgeLoggerImpl(Collector collector, Configuration config, TxUuid uuid, NudgeStack stack, StackTracer tracer, boolean safe) {
        Checker.checkArgument(null != collector);
        Checker.checkArgument(null != config);
        Checker.checkArgument(null != uuid);
        Checker.checkArgument(null != stack);
        this.collector = collector;
        this.config = config;
        this.uuid = uuid;
        this.currentStack = stack;
        this.tracer = tracer;
        this.anonymizer = new Anonymizer();
        this.safe = safe;
    }

    @Override
    public void enteringJdbcStmtSet(int index, Object value) {
        if (!this.collector.isEnabled()) {
            return;
        }
        Map<Integer, Object> params = this.sqlParametersValue.get(this.currentSqlExecCount);
        if (params == null) {
            params = new TreeMap<Integer, Object>();
            this.sqlParametersValue.put(this.currentSqlExecCount, params);
        }
        params.put(index, value);
    }

    @Override
    public void enteringJdbcStmtSet(int index, int value) {
        this.enteringJdbcStmtSet(index, (Object)value);
    }

    @Override
    public void enteringJdbcStmtSet(int index, float value) {
        this.enteringJdbcStmtSet(index, Float.valueOf(value));
    }

    @Override
    public void enteringJdbcStmtSet(int index, double value) {
        this.enteringJdbcStmtSet(index, (Object)value);
    }

    @Override
    public void enteringJdbcStmtSet(int index, long value) {
        this.enteringJdbcStmtSet(index, (Object)value);
    }

    @Override
    public void enteringJdbcStmtSet(int index, boolean value) {
        this.enteringJdbcStmtSet(index, (Object)value);
    }

    @Override
    public void enteringJdbcStmtSet(int index, short value) {
        this.enteringJdbcStmtSet(index, (Object)value);
    }

    @Override
    public void enteringJdbcStmtSet(int index, byte value) {
        this.enteringJdbcStmtSet(index, (Object)value);
    }

    @Override
    public String getUUID() {
        return this.uuid.get();
    }

    @Override
    public String getRumId() {
        ProtocolFacade protocol = this.currentStack.getCurrentProtocolFacade();
        if (null != protocol) {
            protocol.addExtendedCode(ExtendedCode.extCode("nudge.rum", ""));
        }
        return this.getUUID();
    }

    @Override
    public void setRequest(Object httpServletRequest) {
    }

    @Override
    public int getLevel() {
        InstrumentationPoint ip = this.currentStack.getCurrentInstrumentationPoint();
        return null != ip && ip.isInTx() ? 1 : 0;
    }

    @Override
    public String getServerId() {
        return this.collector.getServerId();
    }

    @Override
    public String getServerInfo() {
        return this.collector.getServerInfo();
    }

    @Override
    public void setServerInfo(String serverInfo) {
        this.collector.setServerInfo(serverInfo);
    }

    @Override
    public void logNudgeCpuOverhead(long elapsedTime) {
    }

    @Override
    public boolean entering(EventType eventType, String name) {
        return this.entering(eventType, name, null);
    }

    private LogEventBuilder newLegacyEvent(EventType eventType) {
        String handlerClass = eventType.getHandlerClass();
        if (null == handlerClass) {
            handlerClass = "org.nudge.probe.events.BaseEventHandler";
        }
        return this.newEvent(this.getClass().getClassLoader()).handler(handlerClass).type(eventType.getType());
    }

    @Override
    public boolean entering(EventType eventType, String method, String alias) {
        if (!this.collector.isEnabled()) {
            return true;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("entering --> %s %s %s", new Object[]{eventType, method, alias}), new Object[0]);
        }
        this.newLegacyEvent(eventType).method(method).entering();
        if (!this.currentStack.isInTransaction()) {
            return false;
        }
        if (this.currentStack.getCurrentInstrumentationPoint().isDefineTx()) {
            this.dbMetrics.reset();
        }
        return true;
    }

    @Override
    public void exiting(EventType eventType, String method) {
        if (!this.collector.isEnabled()) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("exiting <-- %s %s", new Object[]{eventType, method}), new Object[0]);
        }
        if (!this.currentStack.isInTransaction()) {
            this.reset();
            return;
        }
        boolean leavingTx = this.currentStack.getCurrentInstrumentationPoint().isDefineTx();
        if (leavingTx) {
            this.dbMetrics.write(this.currentStack.getCurrentProtobuf());
            this.dbMetrics.reset();
        }
        try {
            this.newLegacyEvent(eventType).method(method).exiting();
        }
        catch (RuntimeException e) {
            log.severe(e, "error", new Object[0]);
        }
        if (leavingTx) {
            this.reset();
        }
    }

    private void addJDBCConnectionLeakInfo(RawDataProtocol.Transaction.Builder transaction) {
        RawDataProtocol.TroubleshootingEvents.Builder tsEvent = RawDataProtocol.TroubleshootingEvents.newBuilder();
        tsEvent.setTimestamp(new Date().getTime());
        tsEvent.setType(RawDataProtocol.TroubleshootingEvents.EventType.ConnectionLeak);
        tsEvent.setUuidAssociated(transaction.getUuid());
        this.collector.send(tsEvent);
        RawdataUtil.writeException(new NudgeConnectionLeakSuspected("Connection leak suspected, a connection is not closed"), transaction);
    }

    public void reset() {
        this.isNewThread = true;
        this.url = null;
        this.logSql = true;
        this.currentSqlId = 0L;
        this.currentSql = null;
        this.currentDbUrl = null;
        this.currentSqlExecStart = 0L;
        this.currentSqlExecCount = 0;
        this.currentJdbcFetchCount = 0;
        this.currentJdbcCommitStart = 0L;
        this.currentJdbcCommitCount = 0;
        this.currentJdbcRollbackStart = 0L;
        this.currentJdbcRollbackCount = 0;
        this.currentJMSExecStart = 0L;
        this.currentJMSExecCount = 0;
        this.currentJMSExecStatus = true;
        this.currentMemcachedCount = 0;
        this.currentMemcachedStart = 0L;
        this.dbMetrics.reset();
    }

    @Override
    public boolean swingThreadingAntiPattern() {
        int lastIndex;
        if (this.swingEdtCounter >= 10) {
            return false;
        }
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if ("java.lang.Thread".equals(stack[lastIndex = stack.length - 1].getClassName())) {
            --lastIndex;
        }
        StackTraceElement sta1 = stack[lastIndex];
        StackTraceElement sta2 = stack[lastIndex - 1];
        StringBuilder buf = new StringBuilder(200);
        buf.append(sta1.getClassName());
        buf.append(".");
        buf.append(sta1.getMethodName());
        buf.append(":");
        buf.append(sta1.getLineNumber());
        buf.append(":");
        buf.append(sta2.getClassName());
        buf.append(".");
        buf.append(sta2.getMethodName());
        String id = buf.toString();
        if (!this.swingEdtSet.contains(id)) {
            this.swingEdtSet.add(id);
            RawDataProtocol.TroubleshootingEvents.Builder tsEvent = RawDataProtocol.TroubleshootingEvents.newBuilder();
            tsEvent.setTimestamp(System.currentTimeMillis());
            tsEvent.setType(RawDataProtocol.TroubleshootingEvents.EventType.ConnectionLeak);
            tsEvent.setUuidAssociated("");
            this.collector.send(tsEvent);
        } else {
            ++this.swingEdtCounter;
        }
        return true;
    }

    @Override
    public void enteringJdbcCnxClose() {
        if (this.config.isLogStackTraceOnConnection()) {
            StringBuilder b = new StringBuilder("Exiting connection here: [");
            for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                b.append(e.toString());
                b.append(" __ ");
            }
            b.append("]");
            log.info(b.toString(), new Object[0]);
        }
    }

    @Override
    public void exitingJdbcCnxClose() {
    }

    @Override
    public void enteringJdbcStmtExecute() {
        if (!this.collector.isEnabled()) {
            return;
        }
        if (!this.currentStack.isInTransaction()) {
            if (null != this.tracer) {
                this.tracer.traceInstrumentedMethod("JDBC", "execute");
            }
            return;
        }
        if (this.alreadyInSqlLayer()) {
            return;
        }
        this.pruneOutputLayer();
        if (this.currentSqlExecCount == 0) {
            this.currentSqlExecStart = System.currentTimeMillis();
        }
        ++this.currentSqlExecCount;
    }

    private boolean alreadyInSqlLayer() {
        InstrumentationPoint ip = this.currentStack.getCurrentInstrumentationPoint();
        return null != ip && "SQL".equals(ip.getType()) && (ip.isDefineOutput() || ip.isBeyondOutput());
    }

    private void pruneOutputLayer() {
        try {
            if (!this.currentStack.isInTransaction()) {
                return;
            }
            InstrumentationPoint ip = this.currentStack.getCurrentInstrumentationPoint();
            if (ip.isDefineOutput() || ip.isBeyondOutput()) {
                ip.makeNotOutput();
            }
        }
        catch (Exception e) {
            log.severe(e, "unable to prune output layer", new Object[0]);
        }
    }

    @Override
    public String getDbUrl(Connection connection) {
        String url = null;
        if (null != connection) {
            if (connection instanceof JdbcConnectionNudge) {
                url = ((JdbcConnectionNudge)((Object)connection)).nudgeGetDbUrl();
            }
            if (null == url) {
                try {
                    DatabaseMetaData meta = JdbcMetadata.safeGetMetadata(connection);
                    if (null != meta) {
                        try {
                            url = meta.getURL();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
            }
        }
        return url;
    }

    @Override
    public long exitingJdbcStmtExecute(String sql, String dbUrl, @Deprecated boolean statement, @Deprecated int rowCount) {
        if (!this.collector.isEnabled()) {
            return 0L;
        }
        if (null != dbUrl && !dbUrl.equals(this.currentDbUrl)) {
            this.currentDbUrl = dbUrl;
        }
        if (null != sql && !sql.equals(this.currentSql)) {
            this.currentSql = sql;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("SQL execute %d %d ms \"%s\" on \"%s\"", this.currentSqlExecCount, System.currentTimeMillis() - this.currentSqlExecStart, this.currentSql, this.currentDbUrl);
        }
        if (!this.currentStack.isInTransaction() || this.alreadyInSqlLayer()) {
            return 0L;
        }
        --this.currentSqlExecCount;
        if (this.currentSqlExecCount == 0) {
            long execEnd = System.currentTimeMillis();
            long totalTime = execEnd - this.currentSqlExecStart;
            boolean anonymizeQuery = this.config.isAnonymizableQuery(totalTime);
            String parametersString = null;
            if (anonymizeQuery) {
                this.currentSql = this.anonymizer.anonymiseSql(this.currentSql);
            } else {
                Map<Integer, Object> params = this.sqlParametersValue.remove(this.currentSqlExecCount);
                if (null != params && !params.isEmpty()) {
                    parametersString = Arrays.toString(params.values().toArray());
                    this.currentSql = this.currentSql + " " + parametersString;
                }
            }
            RawDataProtocol.Transaction.Builder tx = this.currentStack.getCurrentProtobuf();
            if (this.logSql && tx != null && (long)tx.getSqlRequestsCount() < this.config.getQueryCountLimit()) {
                String[] parts;
                String NUDGE2 = "#nudge#";
                String cleanDbUrl = this.currentDbUrl;
                String productName = null;
                String productVersion = null;
                if (null != this.currentDbUrl && this.currentDbUrl.contains("#nudge#") && (parts = this.currentDbUrl.split("#nudge#")).length == 3) {
                    cleanDbUrl = parts[0];
                    productName = parts[1];
                    productVersion = parts[2];
                }
                if (null != this.currentSql && this.currentSql.length() > 0) {
                    this.currentStack.getCurrentProtocolFacade().createOrUpdateLayerItem(this.currentSqlExecStart, "SQL", this.currentSql, ExtendedCode.extCode("jdbc.url", cleanDbUrl), ExtendedCode.extCode("jdbc.parameters", parametersString), ExtendedCode.extCode("jdbc.product.name", productName), ExtendedCode.extCode("jdbc.product.version", productVersion)).addCall(totalTime, false);
                    RawDataProtocol.SqlRequest.Builder requestBuilder = RawDataProtocol.SqlRequest.newBuilder();
                    requestBuilder.setId(++this.currentSqlId);
                    requestBuilder.setSql(this.currentSql);
                    requestBuilder.setServerUrl(cleanDbUrl != null ? cleanDbUrl : "");
                    this.currentDbUrl = null;
                    this.currentSql = null;
                    requestBuilder.setCount(1);
                    requestBuilder.setStartTime(this.currentSqlExecStart);
                    requestBuilder.setEndTime(execEnd);
                }
                this.dbMetrics.logQueryExec(totalTime);
            }
        }
        return this.currentSqlId;
    }

    @Override
    public void enteringJdbcStmtClose() {
    }

    @Override
    public void exitingJdbcStmtClose() {
    }

    @Override
    public void enteringJdbcFetch() {
        if (!this.collector.isEnabled()) {
            return;
        }
        ++this.currentJdbcFetchCount;
    }

    @Override
    public void exitingJdbcFetch(long requestId, int count, double avg, long max, long min) {
        if (!this.collector.isEnabled()) {
            return;
        }
        --this.currentJdbcFetchCount;
        if (!this.currentStack.isInTransaction() || this.currentJdbcFetchCount != 0 || requestId <= 0L) {
            return;
        }
        this.dbMetrics.logFetch(count, avg, max, min);
        RawDataProtocol.Transaction.Builder tx = this.currentStack.getCurrentProtobuf();
        if ((long)tx.getSqlRequestsCount() >= requestId) {
            RawDataProtocol.SqlRequest.Builder builder = tx.getSqlRequestsBuilder((int)(requestId - 1L));
            builder.setFetchCount(count);
            builder.setFetchAvg((long)avg);
            builder.setFetchMax(max);
            builder.setFetchMin(min);
        }
    }

    @Override
    public void enteringJdbcCnxRollback() {
        if (!this.collector.isEnabled()) {
            return;
        }
        if (this.currentJdbcRollbackCount == 0) {
            this.currentJdbcRollbackStart = System.currentTimeMillis();
        }
        ++this.currentJdbcRollbackCount;
    }

    @Override
    public void exitingJdbcCnxRollback() {
        if (!this.collector.isEnabled()) {
            return;
        }
        --this.currentJdbcRollbackCount;
        if (this.currentJdbcRollbackCount == 0 && this.currentStack.isInTransaction()) {
            this.dbMetrics.logRollback(System.currentTimeMillis() - this.currentJdbcRollbackStart);
        }
    }

    @Override
    public void enteringJdbcCnxCommit() {
        if (!this.collector.isEnabled()) {
            return;
        }
        if (this.currentJdbcCommitCount == 0) {
            this.currentJdbcCommitStart = System.currentTimeMillis();
        }
        ++this.currentJdbcCommitCount;
    }

    @Override
    public void exitingJdbcCnxCommit() {
        if (!this.collector.isEnabled()) {
            return;
        }
        --this.currentJdbcCommitCount;
        if (this.currentJdbcCommitCount == 0 && this.currentStack.isInTransaction()) {
            this.dbMetrics.logCommit(System.currentTimeMillis() - this.currentJdbcCommitStart);
        }
    }

    @Override
    public void enteringWSRequest() {
    }

    @Override
    public void exitingWSRequest(EventType eventType, String wsurl, String method, String javaCodeInvoker) {
    }

    @Override
    public void enteringJMS() {
        if (!this.collector.isEnabled()) {
            return;
        }
        if (this.currentJMSExecCount == 0) {
            this.currentJMSExecStart = System.currentTimeMillis();
        }
        ++this.currentJMSExecCount;
    }

    @Override
    public void exitingJMS(EventType eventType, String serverUrl, String destinationName) {
        if (!this.collector.isEnabled()) {
            return;
        }
        --this.currentJMSExecCount;
        if (this.currentJMSExecCount != 0 || !this.currentStack.isInTransaction()) {
            return;
        }
        long time = System.currentTimeMillis() - this.currentJMSExecStart;
        boolean isMessageProduced = false;
        boolean isQueue = false;
        switch (eventType) {
            case JMS_QUEUE_SEND: {
                isMessageProduced = true;
                isQueue = true;
                break;
            }
            case JMS_QUEUE_RECEIVE: {
                isMessageProduced = false;
                isQueue = true;
                break;
            }
            case JMS_TOPIC_PUB: {
                isMessageProduced = true;
                isQueue = false;
                break;
            }
            case JMS_TOPIC_SUB: {
                isMessageProduced = false;
                isQueue = false;
            }
        }
        this.currentStack.getCurrentProtocolFacade().createOrUpdateLayerItem(this.currentJMSExecStart, "JMS", destinationName != null && destinationName.length() > 0 ? destinationName : "Messaging destination undefined", ExtendedCode.extCode("jms.type", isQueue ? "queue" : "topic"), ExtendedCode.extCode("jms.action", isMessageProduced ? "send" : "receive"), ExtendedCode.extCode("jms.serverUrl", serverUrl)).addCall(time, !this.currentJMSExecStatus);
    }

    @Override
    public void enteringMemcached() {
        if (!this.collector.isEnabled()) {
            return;
        }
        if (this.currentMemcachedCount == 0) {
            this.currentMemcachedStart = System.currentTimeMillis();
        }
        ++this.currentMemcachedCount;
    }

    @Override
    public void exitingMemcached(String cacheUrl, String cacheMethodName) {
        if (!this.collector.isEnabled()) {
            return;
        }
        --this.currentMemcachedCount;
        if (this.currentMemcachedCount != 0 && !this.currentStack.isInTransaction()) {
            return;
        }
        long time = System.currentTimeMillis() - this.currentMemcachedStart;
        this.currentStack.getCurrentProtocolFacade().createOrUpdateLayerItem(this.currentMemcachedStart, "Memcached", cacheMethodName, new ExtendedCode[0]).addCall(time, false);
    }

    @Override
    @Deprecated
    public void stopSqlLog() {
        this.logSql = false;
    }

    @Override
    @Deprecated
    public void startSqlLog() {
        this.logSql = true;
    }

    @Override
    public void setTransactionUrl(String value) {
        this.setTransactionUrl(value, true);
    }

    @Override
    public void setTransactionUrl(String value, boolean override) {
        if (!override && this.url != null) {
            return;
        }
        this.url = Util.simplifyUrl(value);
        if (this.currentStack.isInTransaction()) {
            this.currentStack.getCurrentProtobuf().setUrl(this.url);
        }
    }

    @Override
    public void setSessionId(String value) {
        if (!this.currentStack.isInTransaction() || null == value) {
            return;
        }
        this.currentStack.getCurrentProtobuf().setSessionId(value);
    }

    @Override
    public void log(String name, int value) {
        if ("LOCAL_PORT".equals(name)) {
            this.collector.setPort(value);
        }
    }

    @Override
    public void logReqMethod(String name) {
        if (!this.currentStack.isInTransaction()) {
            return;
        }
        RawDataProtocol.Transaction.Builder transaction = this.currentStack.getCurrentProtobuf();
        if ("GET".equals(name)) {
            transaction.setReqMethod(RawDataProtocol.Transaction.ReqMethod.GET);
        } else if ("POST".equals(name)) {
            transaction.setReqMethod(RawDataProtocol.Transaction.ReqMethod.POST);
        } else if ("PUT".equals(name)) {
            transaction.setReqMethod(RawDataProtocol.Transaction.ReqMethod.PUT);
        } else if ("DELETE".equals(name)) {
            transaction.setReqMethod(RawDataProtocol.Transaction.ReqMethod.DELETE);
        } else if ("HEAD".equals(name)) {
            transaction.setReqMethod(RawDataProtocol.Transaction.ReqMethod.HEAD);
        } else if ("CONNECT".equals(name)) {
            transaction.setReqMethod(RawDataProtocol.Transaction.ReqMethod.CONNECT);
        } else if ("OPTIONS".equals(name)) {
            transaction.setReqMethod(RawDataProtocol.Transaction.ReqMethod.OPTIONS);
        } else if ("TRACE".equals(name)) {
            transaction.setReqMethod(RawDataProtocol.Transaction.ReqMethod.TRACE);
        }
    }

    @Override
    public void logHeader(String key, String value) {
        if (!this.currentStack.isInTransaction() || this.headerKeys.contains(key) || null == value) {
            return;
        }
        RawDataProtocol.Transaction.Builder transaction = this.currentStack.getCurrentProtobuf();
        this.headerKeys.add(key);
        transaction.addHeadersBuilder().setKey(key).setValue(value);
    }

    @Override
    public void logRemoteAddress(String adr, int port) {
        if (!this.currentStack.isInTransaction()) {
            return;
        }
        RawDataProtocol.Transaction.Builder transaction = this.currentStack.getCurrentProtobuf();
        transaction.setFromServerId(adr != null ? adr : "");
        transaction.setUserIp(adr != null ? adr : "");
    }

    @Override
    public void logUserAgent(String ua) {
        if (!this.currentStack.isInTransaction() || null == ua || ua.length() == 0) {
            return;
        }
        this.currentStack.getCurrentProtobuf().setUserAgent(ua);
    }

    @Override
    public void logParams(Map<?, ?> params) {
        if (params == null || !this.config.isParamsAllowed() || !this.currentStack.isInTransaction()) {
            return;
        }
        for (Map.Entry<?, ?> entry : params.entrySet()) {
            RawDataProtocol.Param.Builder param = RawDataProtocol.Param.newBuilder();
            String key = (String)entry.getKey();
            Object[] values = (String[])entry.getValue();
            param.setKey(key);
            if (values == null || values.length == 0) continue;
            if (this.config.isParamAllowed(key)) {
                if (values.length == 1) {
                    param.setValue((String)values[0]);
                } else {
                    param.setValue(Arrays.toString(values));
                }
            }
            this.currentStack.getCurrentProtobuf().addParams(param);
        }
    }

    @Override
    public void logParam(String key, String value) {
        if (!this.currentStack.isInTransaction() || key == null || value == null) {
            return;
        }
        RawDataProtocol.Param.Builder param = RawDataProtocol.Param.newBuilder();
        param.setKey(key);
        if (this.config.isParamAllowed(key)) {
            param.setValue(value);
        }
        this.currentStack.getCurrentProtobuf().addParams(param);
    }

    @Override
    public void log(Throwable throwable) {
        if (!this.collector.isEnabled()) {
            return;
        }
        if (!this.currentStack.isInTransaction()) {
            return;
        }
        if (throwable instanceof VirtualMachineError) {
            this.collector.notifyError((VirtualMachineError)throwable);
        }
        RawdataUtil.writeException(throwable, this.currentStack.getCurrentProtobuf());
    }

    @Override
    public void logHttpStatus(int code, String referer) {
        if (!this.currentStack.isInTransaction()) {
            return;
        }
        RawDataProtocol.Transaction.Builder transaction = this.currentStack.getCurrentProtobuf();
        if (code >= 400 && transaction.getStatus() != RawDataProtocol.Transaction.Status.KO) {
            RawDataProtocol.Error.Builder error = RawDataProtocol.Error.newBuilder();
            error.setCode("Http status: " + code);
            StringBuilder sb = new StringBuilder();
            sb.append("Referer: ").append(referer).append("\nUser-agent: ").append(transaction.getUserAgent());
            error.setJvmStacktrace(sb.toString());
            error.setStartTime(System.currentTimeMillis());
            transaction.addErrors(error);
            transaction.setStatus(RawDataProtocol.Transaction.Status.KO);
        }
    }

    @Override
    public void logJMSError() {
        this.currentJMSExecStatus = false;
    }

    @Override
    public void logEndUserTiming(String perf) {
        this.collector.sendEndUserTiming(perf);
    }

    @Override
    public void enteringRuntimeExec() {
    }

    @Override
    public void exitingRuntimeExec(String cmdarray) {
    }

    @Override
    public void exitingRuntimeExec(String[] cmdarray) {
    }

    @Override
    public void logErrorRuntimeExec() {
    }

    @Override
    public void enteringSocketConnect() {
    }

    @Override
    public void exitingSocketConnect(String adr) {
    }

    @Override
    public void logErrorSocketConnect() {
    }

    @Override
    public boolean isNewThread() {
        return this.isNewThread;
    }

    @Override
    public void setSeg1Id(String seg1Id) {
        if (!this.currentStack.isInTransaction()) {
            return;
        }
        this.currentStack.getCurrentProtobuf().setSeg1Id(seg1Id);
    }

    @Override
    public void setSeg2Id(String seg2Id) {
        if (!this.currentStack.isInTransaction()) {
            return;
        }
        this.currentStack.getCurrentProtobuf().setSeg2Id(seg2Id);
    }

    @Override
    public void setSeg3Id(String seg3Id) {
        if (!this.currentStack.isInTransaction()) {
            return;
        }
        this.currentStack.getCurrentProtobuf().setSeg3Id(seg3Id);
    }

    @Override
    public void log(String name, String value) {
        if (!this.currentStack.isInTransaction()) {
            return;
        }
        if ("NUDGE_SERVER".equals(name)) {
            this.currentStack.getCurrentProtobuf().setFromServerId(value != null ? value : "");
        } else if ("NUDGE_TRANSACTION".equals(name)) {
            this.currentStack.getCurrentProtobuf().setFromTransactionUrl(value != null ? value : "");
        }
    }

    protected static void aggregateWSReq(RawDataProtocol.Transaction.Builder t, long duration) {
        t.setWsAvg((t.getWsAvg() * (long)t.getWsCount() + duration) / (long)(t.getWsCount() + 1));
        t.setWsCount(t.getWsCount() + 1);
        if (t.getWsMax() < duration) {
            t.setWsMax(duration);
        }
        if (t.getWsMin() > duration) {
            t.setWsMin(duration);
        }
    }

    protected static void aggregateProducedJMS(RawDataProtocol.Transaction.Builder t, long duration) {
        t.setProdJMSAvg((t.getProdJMSAvg() * (long)t.getProdJMSCount() + duration) / (long)(t.getProdJMSCount() + 1));
        t.setProdJMSCount(t.getProdJMSCount() + 1);
        if (t.getProdJMSMax() < duration) {
            t.setProdJMSMax(duration);
        }
        if (t.getProdJMSMin() > duration) {
            t.setConsJMSMin(duration);
        }
    }

    protected static void aggregateConsumedJMS(RawDataProtocol.Transaction.Builder t, long duration) {
        t.setConsJMSAvg((t.getConsJMSAvg() * (long)t.getConsJMSCount() + duration) / (long)(t.getConsJMSCount() + 1));
        t.setConsJMSCount(t.getConsJMSCount() + 1);
        if (t.getConsJMSMax() < duration) {
            t.setConsJMSMax(duration);
        }
        if (t.getConsJMSMin() > duration) {
            t.setConsJMSMin(duration);
        }
    }

    @Override
    public LogEventBuilder newEvent(ClassLoader cl) {
        return this.newEvent(cl, this.safe);
    }

    public LogEventBuilder newEvent(ClassLoader cl, boolean safe) {
        if (!this.collector.isEnabled()) {
            return LogEventBuilderFactory.noOpEventBuilder();
        }
        LogEventBuilder eventBuilder = LogEventBuilderFactory.newEventBuilder(cl, this.currentStack, this.config, safe);
        return new LogEventBuilderWrapper(eventBuilder);
    }

    private class LogEventBuilderWrapper
    implements LogEventBuilder {
        private final LogEventBuilder eventBuilder;

        private LogEventBuilderWrapper(LogEventBuilder eventBuilder) {
            Checker.checkArgument(null != eventBuilder);
            this.eventBuilder = eventBuilder;
        }

        @Override
        public LogEventBuilder type(String type) {
            this.eventBuilder.type(type);
            return this;
        }

        @Override
        public LogEventBuilder handler(String handlerClass) {
            this.eventBuilder.handler(handlerClass);
            return this;
        }

        @Override
        public LogEventBuilder methodTarget(Object target) {
            this.eventBuilder.methodTarget(target);
            return this;
        }

        @Override
        public LogEventBuilder methodTargetType(Class<?> type) {
            this.eventBuilder.methodTargetType(type);
            return this;
        }

        @Override
        public LogEventBuilder method(String method) {
            this.eventBuilder.method(method);
            return this;
        }

        @Override
        public LogEventBuilder methodParam(Object o) {
            this.eventBuilder.methodParam(o);
            return this;
        }

        @Override
        public LogEventBuilder methodContext(Object o) {
            this.eventBuilder.methodContext(o);
            return this;
        }

        @Override
        public LogEventBuilder thrownException(Throwable exception) {
            this.eventBuilder.thrownException(exception);
            return this;
        }

        @Override
        public LogEventBuilder returnValue(Object returnValue) {
            this.eventBuilder.returnValue(returnValue);
            return this;
        }

        @Override
        public void entering() {
            this.eventBuilder.entering();
        }

        @Override
        public void exiting() {
            this.eventBuilder.exiting();
            this.resetIfNeeded();
        }

        private void resetIfNeeded() {
            if (null == NudgeLoggerImpl.this.currentStack.getCurrentInstrumentationPoint()) {
                NudgeLoggerImpl.this.reset();
            }
        }
    }

    private static class DbMetric {
        private int queryCount;
        private double queryAvg;
        private long queryMax;
        private long queryMin;
        private int cnxCount;
        private double cnxAvg;
        private long cnxMax;
        private long cnxMin;
        private int fetchCount;
        private double fetchAvg;
        private long fetchMax;
        private long fetchMin;
        private int commitCount;
        private double commitAvg;
        private long commitMax;
        private long commitMin;
        private int rollbackCount;
        private double rollbackAvg;
        private long rollbackMax;
        private long rollbackMin;

        public DbMetric() {
            this.reset();
        }

        public void reset() {
            this.queryCount = 0;
            this.queryAvg = 0.0;
            this.queryMax = 0L;
            this.queryMin = Long.MAX_VALUE;
            this.cnxCount = 0;
            this.cnxAvg = 0.0;
            this.cnxMax = 0L;
            this.cnxMin = Long.MAX_VALUE;
            this.fetchCount = 0;
            this.fetchAvg = 0.0;
            this.fetchMax = 0L;
            this.fetchMin = Long.MAX_VALUE;
            this.commitCount = 0;
            this.commitAvg = 0.0;
            this.commitMax = 0L;
            this.commitMin = Long.MAX_VALUE;
            this.rollbackCount = 0;
            this.rollbackAvg = 0.0;
            this.rollbackMax = 0L;
            this.rollbackMin = Long.MAX_VALUE;
        }

        public void agregate(DbMetric m) {
            this.queryAvg = (this.queryAvg * (double)this.queryCount + m.queryAvg * (double)m.queryCount) / (double)(this.queryCount + m.queryCount);
            this.queryCount += m.queryCount;
            if (this.queryMax < m.queryMax) {
                this.queryMax = m.queryMax;
            }
            if (this.queryMin > m.queryMin) {
                this.queryMin = m.queryMin;
            }
            this.cnxAvg = (this.cnxAvg * (double)this.cnxCount + m.cnxAvg * (double)m.cnxCount) / (double)(this.cnxCount + m.cnxCount);
            this.cnxCount += m.cnxCount;
            if (this.cnxMax < m.cnxMax) {
                this.cnxMax = m.cnxMax;
            }
            if (this.cnxMin > m.cnxMin) {
                this.cnxMin = m.cnxMin;
            }
            this.fetchAvg = (this.fetchAvg * (double)this.fetchCount + m.fetchAvg * (double)m.fetchCount) / (double)(this.fetchCount + m.fetchCount);
            this.fetchCount += m.fetchCount;
            if (this.fetchMax < m.fetchMax) {
                this.fetchMax = m.fetchMax;
            }
            if (this.fetchMin > m.fetchMin) {
                this.fetchMin = m.fetchMin;
            }
            this.commitAvg = (this.commitAvg * (double)this.commitCount + m.commitAvg * (double)m.commitCount) / (double)(this.commitCount + m.commitCount);
            this.commitCount += m.commitCount;
            if (this.commitMax < m.commitMax) {
                this.commitMax = m.commitMax;
            }
            if (this.commitMin > m.commitMin) {
                this.commitMin = m.commitMin;
            }
            this.rollbackAvg = (this.rollbackAvg * (double)this.rollbackCount + m.rollbackAvg * (double)m.rollbackCount) / (double)(this.rollbackCount + m.rollbackCount);
            this.rollbackCount += m.rollbackCount;
            if (this.rollbackMax < m.rollbackMax) {
                this.rollbackMax = m.rollbackMax;
            }
            if (this.rollbackMin > m.rollbackMin) {
                this.rollbackMin = m.rollbackMin;
            }
        }

        public void write(RawDataProtocol.Transaction.Builder builder) {
            builder.setDbCnxCount(this.cnxCount);
            builder.setDbCnxAvg((long)this.cnxAvg);
            builder.setDbCnxMax(this.cnxMax);
            builder.setDbCnxMin(this.cnxMin);
            builder.setDbQueryCount(this.queryCount);
            builder.setDbQueryAvg((long)this.queryAvg);
            builder.setDbQueryTotal((long)(this.queryAvg * (double)this.queryCount));
            builder.setDbQueryMax(this.queryMax);
            builder.setDbQueryMin(this.queryMin);
            builder.setDbFetchCount(this.fetchCount);
            builder.setDbFetchAvg((long)this.fetchAvg);
            builder.setDbFetchMax(this.fetchMax);
            builder.setDbFetchMin(this.fetchMin);
            builder.setDbCommitCount(this.commitCount);
            builder.setDbCommitAvg((long)this.commitAvg);
            builder.setDbCommitMax(this.commitMax);
            builder.setDbCommitMin(this.commitMin);
            builder.setDbRollbackCount(this.rollbackCount);
            builder.setDbRollbackAvg((long)this.rollbackAvg);
            builder.setDbRollbackMax(this.rollbackMax);
            builder.setDbRollbackMin(this.rollbackMin);
        }

        public void logQueryExec(long duration) {
            this.queryAvg = (this.queryAvg * (double)this.queryCount + (double)duration) / (double)(this.queryCount + 1);
            ++this.queryCount;
            if (this.queryMax < duration) {
                this.queryMax = duration;
            }
            if (this.queryMin > duration) {
                this.queryMin = duration;
            }
        }

        public void logCnxGet(long duration) {
            this.cnxAvg = (this.cnxAvg * (double)this.cnxCount + (double)duration) / (double)(this.cnxCount + 1);
            ++this.cnxCount;
            if (this.cnxMax < duration) {
                this.cnxMax = duration;
            }
            if (this.cnxMin > duration) {
                this.cnxMin = duration;
            }
        }

        public void logFetch(int count, double avg, long max, long min) {
            this.fetchAvg = (this.fetchAvg * (double)this.fetchCount + avg * (double)count) / (double)(this.fetchCount + count);
            this.fetchCount += count;
            if (this.fetchMax < max) {
                this.fetchMax = max;
            }
            if (this.fetchMin > min) {
                this.fetchMin = min;
            }
        }

        public void logCommit(long duration) {
            this.commitAvg = (this.commitAvg * (double)this.commitCount + (double)duration) / (double)(this.commitCount + 1);
            ++this.commitCount;
            if (this.commitMax < duration) {
                this.commitMax = duration;
            }
            if (this.commitMin > duration) {
                this.commitMin = duration;
            }
        }

        public void logRollback(long duration) {
            this.rollbackAvg = (this.rollbackAvg * (double)this.rollbackCount + (double)duration) / (double)(this.rollbackCount + 1);
            ++this.rollbackCount;
            if (this.rollbackMax < duration) {
                this.rollbackMax = duration;
            }
            if (this.rollbackMin > duration) {
                this.rollbackMin = duration;
            }
        }
    }
}

