/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nudge.probe.Configuration;
import org.nudge.probe.collector.HttpConnector;
import org.nudge.probe.collector.JdkHttpConnector;
import org.nudge.probe.jvm.JvmInfo;
import org.nudge.probe.log.Logger;
import org.nudge.probe.spi.NudgeProbe;
import org.nudge.probe.util.Checker;
import org.nudge.probe.weave.AbstractWeaver;
import org.nudge.probe.weave.aop.AopPoincut;
import org.nudge.probe.weave.aop.NudgePointcutWeaver;
import org.nudge.probe.weave.aop.NudgeTraceAnnotationWeaver;
import org.nudge.probe.weave.batch.QuartzJobWeaver;
import org.nudge.probe.weave.corba.CorbaWeaver;
import org.nudge.probe.weave.ejb.Ejb3Weaver;
import org.nudge.probe.weave.gwt.GwtRpcWeaver;
import org.nudge.probe.weave.http.HttpClient3Weaver;
import org.nudge.probe.weave.jdbc.JdbcConnectWeaver;
import org.nudge.probe.weave.jdbc.JdbcConnectionWeaver;
import org.nudge.probe.weave.jdbc.JdbcPreparedStatementWeaver;
import org.nudge.probe.weave.jdbc.JdbcResultSetWeaver;
import org.nudge.probe.weave.jdbc.JdbcStatementWeaver;
import org.nudge.probe.weave.jdk.HttpURLConnectionWeaver;
import org.nudge.probe.weave.jdk.RunnableWeaver;
import org.nudge.probe.weave.jdk.TimerTaskWeaver;
import org.nudge.probe.weave.jetty.JettyJakartaWeaver;
import org.nudge.probe.weave.jetty.JettyJavaxWeaver;
import org.nudge.probe.weave.jms.JmsReceiveWeaver;
import org.nudge.probe.weave.jms.JmsSendWeaver;
import org.nudge.probe.weave.jmx.MBeanServerWeaver;
import org.nudge.probe.weave.messaging.RabbitMQChannelWeaver;
import org.nudge.probe.weave.messaging.RabbitMQConnection;
import org.nudge.probe.weave.mongodb.MongoClientWeaver;
import org.nudge.probe.weave.mongodb.MongoClientsWeaver;
import org.nudge.probe.weave.mongodb.MongoCollectionWeaver;
import org.nudge.probe.weave.mongodb.MongoDatabaseWeaver;
import org.nudge.probe.weave.portlet.PortletWeaver;
import org.nudge.probe.weave.remoting.RmiWeaver;
import org.nudge.probe.weave.servlet.HttpFilter23Weaver;
import org.nudge.probe.weave.servlet.HttpJspWriterWeaver;
import org.nudge.probe.weave.servlet.HttpServlet23Weaver;
import org.nudge.probe.weave.servlet.HttpServletContextListenerWeaver;
import org.nudge.probe.weave.servlet.HttpServletWeaver;
import org.nudge.probe.weave.servlet.JakartaHttpServletWeaver;
import org.nudge.probe.weave.swing.ActionListenerWeaver;
import org.nudge.probe.weave.swing.JComponentWeaver;
import org.nudge.probe.weave.ws.Axis1HttpSenderWeaver;
import org.nudge.probe.weave.ws.Axis1ServerWeaver;
import org.nudge.probe.weave.ws.JaxRpcWeaver;
import org.nudge.probe.weave.ws.WebServiceJakartaWeaver;
import org.nudge.probe.weave.ws.WebServiceWeaver;

public class NudgeProbeJava5
implements NudgeProbe {
    private static final Logger log = Logger.getLogger(Configuration.DEFAULT_LOGGER_NAME);
    protected final Configuration config;
    protected final List<AopPoincut> aopList;
    protected final JvmInfo jvmInfo;

    public NudgeProbeJava5(Configuration config, JvmInfo jvmInfo) {
        Checker.checkArgument(null != config);
        this.config = config;
        this.aopList = AopPoincut.parseList(config.getAopPointcuts());
        this.jvmInfo = jvmInfo;
    }

    @Override
    public List<NudgeProbe.DiskUsage> getDiskUsage() {
        return Collections.emptyList();
    }

    @Override
    public HttpConnector newHttpConnector() {
        return new JdkHttpConnector(this.config.getConnectorConfig());
    }

    @Override
    public List<AbstractWeaver> buildJdkChain() {
        ArrayList<AbstractWeaver> lst = new ArrayList<AbstractWeaver>();
        lst.add(new HttpURLConnectionWeaver());
        return lst;
    }

    @Override
    public List<AbstractWeaver> buildJdbcInterfaceChain() {
        ArrayList<AbstractWeaver> lst = new ArrayList<AbstractWeaver>();
        lst.add(new JdbcConnectionWeaver(this.config));
        lst.add(new JdbcConnectWeaver(this.config));
        lst.add(new JdbcPreparedStatementWeaver(this.config));
        lst.add(new JdbcStatementWeaver(this.config));
        lst.add(new JdbcResultSetWeaver(this.config));
        return lst;
    }

    @Override
    public List<AbstractWeaver> buildSpringWebSuperClassChain() {
        ArrayList<AbstractWeaver> lst = new ArrayList<AbstractWeaver>();
        this.addServlet(lst);
        this.addPortlet(lst);
        if (this.config.isRumActivated()) {
            lst.add(new HttpJspWriterWeaver());
        }
        return lst;
    }

    private void addPortlet(List<AbstractWeaver> lst) {
        if (this.config.isLogPortlet()) {
            lst.add(new PortletWeaver());
        }
    }

    @Override
    public List<AbstractWeaver> buildSuperClassChain() {
        ArrayList<AbstractWeaver> lst = new ArrayList<AbstractWeaver>();
        this.addServlet(lst);
        this.addPortlet(lst);
        lst.add(new GwtRpcWeaver());
        lst.add(new JComponentWeaver(this.jvmInfo));
        if (this.config.isRumActivated()) {
            lst.add(new HttpJspWriterWeaver());
        }
        return lst;
    }

    @Override
    public List<AbstractWeaver> buildClassChain(ClassLoader cl) {
        ArrayList<AbstractWeaver> lst = new ArrayList<AbstractWeaver>();
        if (this.config.isEjb3Logged()) {
            lst.add(new Ejb3Weaver());
        }
        if (this.config.isWebServiceLogged()) {
            lst.add(new WebServiceWeaver());
            lst.add(new WebServiceJakartaWeaver());
        }
        lst.add(new JaxRpcWeaver());
        lst.add(new Axis1ServerWeaver());
        lst.add(new Axis1HttpSenderWeaver());
        lst.add(new NudgeTraceAnnotationWeaver());
        lst.add(new QuartzJobWeaver());
        for (AopPoincut pc : this.aopList) {
            lst.add(new NudgePointcutWeaver(pc));
        }
        lst.add(new JettyJavaxWeaver());
        lst.add(new JettyJakartaWeaver());
        lst.add(new HttpClient3Weaver());
        return lst;
    }

    private void addServlet(List<AbstractWeaver> lst) {
        if (this.config.isServletVersionPost_2_3()) {
            if (this.config.isLogServlet()) {
                lst.add(new HttpServletWeaver());
                lst.add(new JakartaHttpServletWeaver());
            }
            if (this.config.isLogServletContextListener()) {
                lst.add(new HttpServletContextListenerWeaver());
            }
        } else {
            lst.add(new HttpFilter23Weaver());
            lst.add(new HttpServlet23Weaver());
        }
    }

    @Override
    public List<AbstractWeaver> buildInterfaceChain() {
        ArrayList<AbstractWeaver> lst = new ArrayList<AbstractWeaver>();
        lst.add(new MBeanServerWeaver());
        lst.add(new JmsSendWeaver());
        lst.add(new JmsReceiveWeaver());
        lst.addAll(this.buildJdbcInterfaceChain());
        lst.add(new ActionListenerWeaver());
        lst.addAll(this.buildMongoChain());
        if (this.config.isLogRunnable()) {
            log.finest("Thread instrumentation activated", new Object[0]);
            lst.add(new RunnableWeaver());
        } else {
            log.finest("Thread instrumentation deactivated", new Object[0]);
        }
        if (this.config.isTimerTaskActivated()) {
            lst.add(new TimerTaskWeaver());
            log.finest("Timer task instrumentation activated", new Object[0]);
        } else {
            log.finest("Timer task instrumentation deactivated", new Object[0]);
        }
        if (this.config.isRmiActivated()) {
            lst.add(new RmiWeaver());
            log.finest("RMI instrumentation activated", new Object[0]);
        } else {
            log.finest("RMI instrumentation deactivated", new Object[0]);
        }
        if (this.config.isCorbaActivated()) {
            lst.add(new CorbaWeaver());
            log.finest("Corba instrumentation activated", new Object[0]);
        } else {
            log.finest("Corba instrumentation deactivated", new Object[0]);
        }
        return lst;
    }

    @Override
    public List<AbstractWeaver> buildSwingChain() {
        ArrayList<AbstractWeaver> lst = new ArrayList<AbstractWeaver>();
        lst.add(new JComponentWeaver(this.jvmInfo));
        return lst;
    }

    @Override
    public List<AbstractWeaver> buildInterfaceRabbitMQDriver() {
        ArrayList<AbstractWeaver> lst = new ArrayList<AbstractWeaver>();
        lst.add(new RabbitMQConnection());
        lst.add(new RabbitMQChannelWeaver());
        return lst;
    }

    @Override
    public List<AbstractWeaver> buildMongoChain() {
        ArrayList<AbstractWeaver> lst = new ArrayList<AbstractWeaver>();
        lst.add(new MongoCollectionWeaver());
        lst.add(new MongoClientWeaver());
        lst.add(new MongoDatabaseWeaver());
        lst.add(new MongoClientsWeaver());
        return lst;
    }
}

