/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.nudge.probe.Configuration;
import org.nudge.probe.NudgeProbeJava5;
import org.nudge.probe.collector.ApacheHttpConnector;
import org.nudge.probe.collector.HttpConnector;
import org.nudge.probe.jvm.JvmInfo;
import org.nudge.probe.spi.NudgeProbe;
import org.nudge.probe.weave.AbstractWeaver;
import org.nudge.probe.weave.http.HttpClient4Weaver;
import org.nudge.probe.weave.jakartars.JakartaRsResourceWeaver;
import org.nudge.probe.weave.jaxrs.JaxRsResourceWeaver;
import org.nudge.probe.weave.springmvc.Spring3MvcControllerWeaverImpl;
import org.nudge.probe.weave.springmvc.SpringMvcControllerWeaverImpl;

public class NudgeProbeJava6
extends NudgeProbeJava5
implements NudgeProbe {
    public NudgeProbeJava6(Configuration config, JvmInfo jvmInfo) {
        super(config, jvmInfo);
    }

    @Override
    public List<NudgeProbe.DiskUsage> getDiskUsage() {
        ArrayList<NudgeProbe.DiskUsage> diskUsage = new ArrayList<NudgeProbe.DiskUsage>();
        for (File root : File.listRoots()) {
            diskUsage.add(new Java6DiskUsage(root));
        }
        return diskUsage;
    }

    @Override
    public HttpConnector newHttpConnector() {
        return new ApacheHttpConnector(this.config.getConnectorConfig());
    }

    @Override
    public List<AbstractWeaver> buildClassChain(ClassLoader cl) {
        List<AbstractWeaver> list = super.buildClassChain(cl);
        list.add(new HttpClient4Weaver());
        list.add(new JaxRsResourceWeaver());
        list.add(new JakartaRsResourceWeaver());
        if (this.config.isLogSpringMvc()) {
            SpringMvcControllerWeaverImpl springMvcControllerWeaver = new SpringMvcControllerWeaverImpl(cl);
            if (springMvcControllerWeaver.servletRequestIsLoadable.booleanValue()) {
                list.add(springMvcControllerWeaver);
            }
            Spring3MvcControllerWeaverImpl spring3MvcControllerWeaver = new Spring3MvcControllerWeaverImpl(cl);
            if (spring3MvcControllerWeaver.servletRequestIsLoadable.booleanValue()) {
                list.add(spring3MvcControllerWeaver);
            }
        }
        return list;
    }

    private class Java6DiskUsage
    implements NudgeProbe.DiskUsage {
        private final File root;

        private Java6DiskUsage(File root) {
            this.root = root;
        }

        @Override
        public String getPath() {
            return this.root.getAbsolutePath();
        }

        @Override
        public long getTotalSpace() {
            return this.root.getTotalSpace();
        }

        @Override
        public long getFreeSpace() {
            return this.root.getUsableSpace();
        }
    }
}

