/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.nudge.probe.ProbeJarMBean;

public class ProbeJar
implements ProbeJarMBean {
    private final String jarPath;
    private final String version;
    private final String scmId;
    private final String bootClassPath;

    private ProbeJar(String jarPath, String version, String scmId, String bootClassPath) {
        this.jarPath = jarPath;
        this.version = version;
        this.scmId = scmId;
        this.bootClassPath = bootClassPath;
    }

    public static ProbeJar notAvailable() {
        return new ProbeJar(null, null, null, null);
    }

    public static ProbeJar fromPackaging() {
        URL url = ClassLoader.getSystemClassLoader().getResource("org/nudge/probe/ProbeJar.class");
        if (url == null) {
            throw new IllegalStateException("NUDGE - unable to locate class");
        }
        String jarPath = url.toString();
        if (jarPath.indexOf(33) < 0) {
            throw new IllegalStateException("unable to detect jar location");
        }
        jarPath = jarPath.substring(jarPath.indexOf("file:") + 5, jarPath.indexOf(33));
        jarPath = jarPath.replace("%20", " ");
        String version = null;
        String scmId = null;
        String bootClassPath = null;
        if (null != jarPath) {
            try {
                JarFile jar = new JarFile(jarPath);
                Manifest manifest = jar.getManifest();
                Attributes attr = manifest.getMainAttributes();
                version = attr.getValue("Implementation-Version");
                scmId = attr.getValue("Implementation-Scm-Id");
                bootClassPath = attr.getValue("Boot-Class-Path");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new ProbeJar(jarPath, version, scmId, bootClassPath);
    }

    @Override
    public String getJarPath() {
        return this.jarPath;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getScmId() {
        return this.scmId;
    }

    public void checkJarName() {
        if (null == this.jarPath) {
            return;
        }
        Object[] bootJarNames = this.bootClassPath.split(" ");
        int matchCount = 0;
        for (String string : bootJarNames) {
            if (matchCount == 0 && this.jarPath.endsWith(string)) {
                ++matchCount;
                continue;
            }
            File folder = new File(this.jarPath).getParentFile();
            File other = new File(folder, string);
            if (!other.isFile()) continue;
            throw new IllegalStateException(String.format("ambiguous setup, multiple probe JARs found in same folder : %s and %s", this.jarPath, other.getAbsolutePath()));
        }
        if (matchCount == 0) {
            throw new IllegalStateException(String.format("probe JAR name has been changed, valid names are %s", Arrays.toString(bootJarNames)));
        }
    }
}

