/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.nudge.dependency.oaci.IOUtils;

public final class ProxyClassLoader
extends ClassLoader {
    private static final Set<String> classNames = new HashSet<String>();
    private final ClassLoader parent;

    public ProxyClassLoader(ClassLoader parent) {
        super(parent);
        this.parent = parent;
    }

    public static void addClass(String name) {
        classNames.add(name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (!classNames.contains(name)) {
            return this.parent.loadClass(name);
        }
        InputStream classBytes = this.parent.getResourceAsStream(name.replace('.', '/') + ".class");
        if (null == classBytes) {
            return this.parent.loadClass(name);
        }
        try {
            byte[] bytes = IOUtils.toByteArray(classBytes);
            Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
            return clazz;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(String.format("class not found : %s", name));
        }
        finally {
            IOUtils.closeQuietly(classBytes);
        }
    }

    static {
        ProxyClassLoader.addClass("org.nudge.probe.weave.jmx.MBeanServerHandler");
        ProxyClassLoader.addClass("org.nudge.probe.events.LogEventBuilderImpl");
        ProxyClassLoader.addClass("org.nudge.probe.weave.jms.JmsCommonHandler");
        ProxyClassLoader.addClass("org.nudge.probe.events.OutputOnlyHandler");
        ProxyClassLoader.addClass("org.nudge.probe.events.BaseEventHandler");
        ProxyClassLoader.addClass("org.nudge.probe.weave.servlet.HttpServletHandler");
        ProxyClassLoader.addClass("org.nudge.probe.weave.http.AbstractHttpClientHandler");
        ProxyClassLoader.addClass("org.nudge.probe.weave.http.HttpClient3Handler$1");
        ProxyClassLoader.addClass("org.nudge.probe.weave.http.HttpClient4Handler$1");
        ProxyClassLoader.addClass("org.nudge.probe.weave.jdk.HttpURLConnectionHandler$1");
        ProxyClassLoader.addClass("org.nudge.probe.weave.jaxrs.JaxRsResourceHandler$1");
    }
}

