/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.nudge.probe.TxUuid;
import org.nudge.probe.util.Checker;

public class ThreadBasedTxUuid
implements TxUuid {
    private static final State EMPTY_STATE = new State(null);
    private final Map<Long, TxUuid.TxThread> threadStates = new ConcurrentHashMap<Long, TxUuid.TxThread>();
    private final InheritableThreadLocal<State> TID = new InheritableThreadLocal<State>(){

        @Override
        protected State initialValue() {
            return EMPTY_STATE;
        }

        @Override
        protected State childValue(State parentId) {
            if (!parentId.isActive()) {
                return EMPTY_STATE;
            }
            String id = parentId.id;
            int idx = id.indexOf("#");
            if (idx > 0) {
                id = id.substring(0, idx);
            }
            return new State(id + "#" + UUID.randomUUID().toString());
        }
    };

    @Override
    public void startMethod(String method) {
        this.startMethod(method, UUID.randomUUID().toString());
    }

    @Override
    public void startMethod(final String method, String uuid) {
        Checker.checkArgument(null != method && method.length() > 0);
        Checker.checkArgument(null != uuid && uuid.length() > 0);
        State state = (State)this.TID.get();
        Checker.checkState(!state.isActive(), "method already started in this thread");
        if (EMPTY_STATE == state) {
            state = new State(uuid);
            this.TID.set(state);
        }
        state.activate();
        final String effectiveUuid = state.id;
        this.threadStates.put(Thread.currentThread().getId(), new TxUuid.TxThread(){

            @Override
            public String getMethod() {
                return method;
            }

            @Override
            public String getUuid() {
                return effectiveUuid;
            }
        });
    }

    @Override
    public String get() {
        State state = (State)this.TID.get();
        return state.isActive() ? state.id : null;
    }

    @Override
    public void endMethod() {
        State state = (State)this.TID.get();
        Checker.checkState(state.isActive(), "method not started");
        this.TID.set(EMPTY_STATE);
        long threadId = Thread.currentThread().getId();
        TxUuid.TxThread removed = this.threadStates.remove(threadId);
        Checker.checkState(removed.getUuid().equals(state.id));
    }

    @Override
    public TxUuid.TxThread getThreadState(long threadId) {
        ThreadInfo threadInfo;
        TxUuid.TxThread txThread = this.threadStates.get(threadId);
        if (null == txThread) {
            return null;
        }
        boolean doCleanup = true;
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (null != threadMXBean && null != (threadInfo = threadMXBean.getThreadInfo(threadId)) && Thread.State.TERMINATED != threadInfo.getThreadState()) {
            doCleanup = false;
        }
        if (doCleanup) {
            this.threadStates.remove(threadId);
            txThread = null;
        }
        return txThread;
    }

    private static class State {
        private final String id;
        private boolean active;

        State(String id) {
            this.id = id;
        }

        void activate() {
            Checker.checkState(null != this.id && !this.active);
            this.active = true;
        }

        boolean isActive() {
            return this.active && null != this.id;
        }
    }
}

