/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe;

import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.StandardMBean;
import org.nudge.dependency.oaci.IOUtils;
import org.nudge.probe.Configuration;
import org.nudge.probe.CurrentTime;
import org.nudge.probe.log.Logger;
import org.nudge.probe.util.Checker;

public class Util {
    private static final Logger log = Logger.getLogger(Configuration.DEFAULT_LOGGER_NAME);
    private static final int MAX_FRAMES = 100;

    private Util() {
    }

    public static URL createUrl(String format, Object ... args) {
        String urlString = String.format(format, args);
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("invalid url : " + urlString, e);
        }
    }

    public static String simplifyUrl(String uri) {
        int idx = uri.indexOf("?");
        if (idx != -1) {
            return uri.substring(0, idx);
        }
        return uri;
    }

    public static Map<String, String> getParams(String uri) {
        HashMap<String, String> map = new HashMap<String, String>();
        int idx = uri.indexOf("?");
        if (idx != -1 && idx != uri.length()) {
            for (String param : uri.substring(idx).split("&")) {
                String[] kv = param.split("=");
                if (kv.length == 2) {
                    map.put(kv[0], kv[1]);
                    continue;
                }
                if (kv.length != 1) continue;
                map.put(kv[0], "");
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpThreads(String dir) {
        block6: {
            long d = System.currentTimeMillis();
            String fileName = String.format("%s/thread_dump_%d.zip", dir, d);
            FileOutputStream fos = null;
            ZipOutputStream zos = null;
            try {
                fos = new FileOutputStream(fileName);
                zos = new ZipOutputStream(fos);
                zos.putNextEntry(new ZipEntry("thread_dump_" + d));
                zos.write("Full thread dump Nudge:\n\n".getBytes());
                ThreadMXBean bean = ManagementFactory.getThreadMXBean();
                for (long id : bean.getAllThreadIds()) {
                    ThreadInfo info = bean.getThreadInfo(id, Integer.MAX_VALUE);
                    if (info == null) continue;
                    zos.write(Util.infoToString(info).getBytes());
                }
                IOUtils.closeQuietly(zos);
            }
            catch (IOException e) {
                log.info(e, "Failed to dump thread");
                break block6;
            }
            finally {
                IOUtils.closeQuietly(zos);
                IOUtils.closeQuietly(fos);
            }
            IOUtils.closeQuietly(fos);
        }
    }

    public static String infoToString(ThreadInfo info) {
        int i;
        StringBuilder sb = new StringBuilder("\"" + info.getThreadName() + "\" Id=" + info.getThreadId() + " " + (Object)((Object)info.getThreadState()));
        if (info.getLockName() != null) {
            sb.append(" on ").append(info.getLockName());
        }
        if (info.getLockOwnerName() != null) {
            sb.append(" owned by \"").append(info.getLockOwnerName()).append("\" Id=").append(info.getLockOwnerId());
        }
        if (info.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (info.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        for (i = 0; i < info.getStackTrace().length && i < 100; ++i) {
            StackTraceElement ste = info.getStackTrace()[i];
            sb.append("\tat ").append(ste.toString());
            sb.append('\n');
        }
        if (i < info.getStackTrace().length) {
            sb.append("\t...");
            sb.append('\n');
        }
        sb.append('\n');
        return sb.toString();
    }

    public static Method getMethod(String signature, ClassLoader cl) {
        Checker.checkArgument(null != signature);
        int paramStart = signature.indexOf(40);
        int paramEnd = signature.indexOf(41);
        if (paramStart < 0 || paramEnd < 0) {
            return null;
        }
        String[] parameters = signature.substring(paramStart + 1, paramEnd).split(",");
        ArrayList paramTypes = new ArrayList();
        for (String parameter : parameters) {
            if ((parameter = parameter.trim()).length() <= 0) continue;
            String param = Util.getClassName(parameter);
            try {
                Class<?> paramType = Util.classFromName(cl, param);
                paramTypes.add(paramType);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        String methodName = signature.substring(0, paramStart);
        int classNameEnd = methodName.lastIndexOf(46);
        if (classNameEnd < 0) {
            return null;
        }
        String className = methodName.substring(0, classNameEnd);
        methodName = methodName.substring(className.length() + 1, methodName.length());
        try {
            Class<?> type = Class.forName(className, true, cl);
            return type.getDeclaredMethod(methodName, paramTypes.toArray(new Class[paramTypes.size()]));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class<?> classFromName(ClassLoader cl, String param) throws ClassNotFoundException {
        if (param.equals("char")) {
            return Character.TYPE;
        }
        if (param.equals("byte")) {
            return Byte.TYPE;
        }
        if (param.equals("short")) {
            return Short.TYPE;
        }
        if (param.equals("int")) {
            return Integer.TYPE;
        }
        if (param.equals("long")) {
            return Long.TYPE;
        }
        if (param.equals("float")) {
            return Float.TYPE;
        }
        if (param.equals("double")) {
            return Double.TYPE;
        }
        if (param.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (param.equals("void")) {
            return Void.TYPE;
        }
        return Class.forName(param, true, cl);
    }

    private static String getClassName(String def) {
        String type = def;
        StringBuilder arrayDim = new StringBuilder();
        while (type.endsWith("[]")) {
            arrayDim.append("[");
            type = type.substring(0, type.length() - 2);
        }
        if (arrayDim.length() > 0) {
            type = String.format("%sL%s;", arrayDim.toString(), type);
        }
        return type;
    }

    public static CurrentTime getSystemTime() {
        return new CurrentTime(){

            @Override
            public long currentTimeMillis() {
                return System.currentTimeMillis();
            }

            @Override
            public long nanoTime() {
                return System.nanoTime();
            }
        };
    }

    public static void doWait(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean isNumeric(String s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static <T> void registerJmxBean(MBeanServer mbs, T o, Class<T> mbeanClass, String name) {
        try {
            StandardMBean mBean = new StandardMBean(o, mbeanClass);
            ObjectName objectName = new ObjectName(name);
            mbs.registerMBean(mBean, objectName);
        }
        catch (OperationsException e) {
            log.severe(e, "registering Nudge MBean failed : %s", e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            log.severe(e, "registering Nudge MBean failed : %s", e.getMessage());
        }
    }
}

