/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.collector;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.nudge.dependency.oaci.IOUtils;
import org.nudge.dependency.oah5.client5.http.auth.AuthScope;
import org.nudge.dependency.oah5.client5.http.auth.UsernamePasswordCredentials;
import org.nudge.dependency.oah5.client5.http.classic.methods.HttpUriRequestBase;
import org.nudge.dependency.oah5.client5.http.config.ConnectionConfig;
import org.nudge.dependency.oah5.client5.http.impl.auth.BasicCredentialsProvider;
import org.nudge.dependency.oah5.client5.http.impl.classic.CloseableHttpClient;
import org.nudge.dependency.oah5.client5.http.impl.classic.CloseableHttpResponse;
import org.nudge.dependency.oah5.client5.http.impl.classic.HttpClients;
import org.nudge.dependency.oah5.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.nudge.dependency.oah5.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.nudge.dependency.oah5.client5.http.protocol.HttpClientContext;
import org.nudge.dependency.oah5.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.nudge.dependency.oah5.core5.http.ClassicHttpRequest;
import org.nudge.dependency.oah5.core5.http.Header;
import org.nudge.dependency.oah5.core5.http.HttpEntity;
import org.nudge.dependency.oah5.core5.http.HttpHost;
import org.nudge.dependency.oah5.core5.http.io.SocketConfig;
import org.nudge.dependency.oah5.core5.http.io.entity.AbstractHttpEntity;
import org.nudge.dependency.oah5.core5.http.ssl.TLS;
import org.nudge.dependency.oah5.core5.pool.PoolConcurrencyPolicy;
import org.nudge.dependency.oah5.core5.pool.PoolReusePolicy;
import org.nudge.dependency.oah5.core5.ssl.SSLContextBuilder;
import org.nudge.dependency.oah5.core5.util.TimeValue;
import org.nudge.dependency.oah5.core5.util.Timeout;
import org.nudge.probe.collector.HttpConnector;
import org.nudge.probe.collector.HttpConnectorResponse;
import org.nudge.probe.collector.WriteData;
import org.nudge.probe.conf.ConnectorConfig;
import org.nudge.probe.conf.ProxyConfig;

public class ApacheHttpConnector
implements HttpConnector {
    private static final String KEYSTORE_PWD = "changeit";
    private final HttpClientContext context = HttpClientContext.create();
    private final CloseableHttpClient httpClient;

    public ApacheHttpConnector(ConnectorConfig config) {
        HttpHost proxy = null;
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        ProxyConfig proxyConfig = config.getProxyConfig();
        if (proxyConfig.useProxy()) {
            proxy = new HttpHost(proxyConfig.getHost(), proxyConfig.getPort());
            if (proxyConfig.useCredentials()) {
                UsernamePasswordCredentials userPwd = new UsernamePasswordCredentials(proxyConfig.getLogin(), proxyConfig.getPassword().toCharArray());
                credentialsProvider.setCredentials(new AuthScope(proxy), userPwd);
                this.context.setCredentialsProvider(credentialsProvider);
            }
        }
        SSLContext sslContext = null;
        if (config.useInternalKeystore()) {
            sslContext = ApacheHttpConnector.createSSLContext();
        }
        PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create();
        if (sslContext != null) {
            connectionManagerBuilder.setSSLSocketFactory(SSLConnectionSocketFactoryBuilder.create().setSslContext(sslContext).setTlsVersions(TLS.V_1_3).build());
        }
        PoolingHttpClientConnectionManager connectionManager = connectionManagerBuilder.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(Timeout.ofMinutes(1L)).build()).setPoolConcurrencyPolicy(PoolConcurrencyPolicy.STRICT).setConnPoolPolicy(PoolReusePolicy.LIFO).setDefaultConnectionConfig(ConnectionConfig.custom().setSocketTimeout(Timeout.ofMinutes(1L)).setConnectTimeout(Timeout.ofMilliseconds(config.getConnectTimeout())).setTimeToLive(TimeValue.ofMilliseconds(config.getReadTimeout())).build()).build();
        this.httpClient = HttpClients.custom().setDefaultCredentialsProvider(credentialsProvider).setProxy(proxy).setConnectionManager(connectionManager).evictExpiredConnections().build();
    }

    private URI toUri(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public HttpConnectorResponse request(String method, URL url, WriteData body, Map<String, String> headers) throws IOException {
        HttpUriRequestBase request = new HttpUriRequestBase(method, this.toUri(url));
        if (null != body) {
            Iterator<Map.Entry<String, String>> entity = ApacheHttpConnector.getAbstractHttpEntity(body);
            request.setEntity((HttpEntity)((Object)entity));
        }
        if (null != headers) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                request.setHeader(entry.getKey(), entry.getValue());
            }
        }
        if (null != headers) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                request.setHeader(entry.getKey(), entry.getValue());
            }
        }
        CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)request, this.context);
        int status = response.getCode();
        byte[] responseBody = null;
        String responseEncoding = null;
        HttpEntity entity = response.getEntity();
        if (null != entity) {
            responseBody = IOUtils.toByteArray(entity.getContent());
            String contentEncoding = entity.getContentEncoding();
            if (null != contentEncoding) {
                responseEncoding = contentEncoding;
            }
            IOUtils.closeQuietly((Closeable)response);
        }
        Map<String, String> respHeaders = this.headersToMap(response.getHeaders());
        return new HttpConnectorResponse(url, status, responseBody, responseEncoding, respHeaders);
    }

    private static AbstractHttpEntity getAbstractHttpEntity(final WriteData body) {
        Boolean chunked = false;
        return new AbstractHttpEntity(body.getContentType(), null, chunked){

            @Override
            public boolean isRepeatable() {
                return true;
            }

            @Override
            public long getContentLength() {
                return body.getContentLength();
            }

            @Override
            public InputStream getContent() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void writeTo(OutputStream out) throws IOException {
                body.writeTo(out);
            }

            @Override
            public boolean isStreaming() {
                return false;
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    private Map<String, String> headersToMap(Header[] allHeaders) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Header h : allHeaders) {
            result.put(h.getName(), h.getValue());
        }
        return result;
    }

    private static SSLContext createSSLContext() {
        try {
            KeyStore keyStore = ApacheHttpConnector.getKeyStore();
            if (null != keyStore) {
                return SSLContextBuilder.create().loadTrustMaterial(keyStore, null).build();
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (KeyManagementException keyManagementException) {
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return null;
    }

    public static KeyStore getKeyStore() {
        try {
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            InputStream in = ApacheHttpConnector.class.getResourceAsStream("/org/nudge/probe/collector/nudge.jks");
            if (null != in) {
                try {
                    keystore.load(in, KEYSTORE_PWD.toCharArray());
                }
                finally {
                    in.close();
                }
            }
            return keystore;
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (CertificateException certificateException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

