/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.collector;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.nudge.dependency.cnab.probe.RawDataProtocol;
import org.nudge.probe.Configuration;
import org.nudge.probe.collector.Collector;
import org.nudge.probe.collector.CollectorMBean;
import org.nudge.probe.collector.FlushableCollection;
import org.nudge.probe.collector.FlushableCollectionMBean;
import org.nudge.probe.collector.NudgeConnector;
import org.nudge.probe.collector.NudgeOutOfMemoryMonitor;
import org.nudge.probe.collector.Orchestrator;
import org.nudge.probe.collector.TransactionFilter;
import org.nudge.probe.jmx.GcActivityBuilder;
import org.nudge.probe.jmx.HeapMemoryBuilder;
import org.nudge.probe.jmx.ServerConfigBuilder;
import org.nudge.probe.jmx.ThreadActivityBuilder;
import org.nudge.probe.jvm.JvmInfo;
import org.nudge.probe.libscan.JarInfo;
import org.nudge.probe.log.Logger;
import org.nudge.probe.util.Checker;

public class CollectorImpl
implements Collector,
CollectorMBean {
    private static final Logger log = Logger.getLogger(Configuration.DEFAULT_LOGGER_NAME);
    private final NudgeConnector connector;
    private long packetCounter = 1L;
    private String serverInfo;
    private Long serverPort;
    private final FlushableCollection<RawDataProtocol.Transaction.Builder> transactions;
    private final FlushableCollection<String> browserTimings;
    private final FlushableCollection<RawDataProtocol.ThreadInfo.Builder> threadInfos;
    private final FlushableCollection<RawDataProtocol.MBean.Builder> mBeans;
    private final FlushableCollection<RawDataProtocol.TroubleshootingEvents.Builder> tsEvents;
    private final FlushableCollection<RawDataProtocol.SystemMetricSample> sysMetrics;
    private final FlushableCollection<String> components;
    private final String serverId = UUID.randomUUID().toString();
    private final GcActivityBuilder gcActivityBuilder = new GcActivityBuilder();
    private final HeapMemoryBuilder heapMemoryBuilder = new HeapMemoryBuilder();
    private final ThreadActivityBuilder threadActivityBuilder = new ThreadActivityBuilder();
    private final JvmInfo jvmInfo;
    private final Configuration config;
    private final AtomicBoolean firstLogUpload = new AtomicBoolean(true);
    private final AtomicBoolean firstConfigUpload = new AtomicBoolean(true);
    private final AtomicBoolean flushRunning = new AtomicBoolean(false);
    private final AtomicBoolean flushRequested = new AtomicBoolean(false);
    private RawDataProtocol.ServerConfig.Builder serverConfig;
    private Orchestrator orchestrator;
    private final AtomicBoolean enabled = new AtomicBoolean(true);
    private final TransactionFilter.ReducingType flushFilteringType;
    private final int flushFilteringRate;

    public CollectorImpl(Configuration config, JvmInfo jvmInfo, NudgeConnector connector) {
        Checker.checkArgument(null != config);
        this.config = config;
        Checker.checkArgument(null != jvmInfo);
        this.jvmInfo = jvmInfo;
        Checker.checkArgument(null != connector);
        this.connector = connector;
        int overflowLimit = config.getFlushOverflowLimitFactor();
        this.transactions = new FlushableCollection(overflowLimit * config.getFlushTxCount());
        this.browserTimings = new FlushableCollection<String>(overflowLimit * config.getFlushRumCount()){

            @Override
            protected Collection<String> newCollection() {
                return new HashSet<String>();
            }
        };
        this.threadInfos = new FlushableCollection(overflowLimit * config.getFlushThreadSamplesCount());
        this.mBeans = new FlushableCollection(overflowLimit * config.getFlushJmxSamplesCount());
        this.tsEvents = new FlushableCollection(500);
        this.sysMetrics = new FlushableCollection(overflowLimit * config.getFlushSystemMetricsSampleCount());
        this.components = new FlushableCollection(overflowLimit * config.getFlushComponentsCount());
        this.enabled.set(config.isCollectorEnabled());
        this.flushFilteringType = config.getFlushFilteringType(config.getFlushFilteringTypeStr());
        this.flushFilteringRate = config.getFlushFilteringRate();
    }

    void uploadLog() {
        boolean isFirstUpload = this.firstLogUpload.getAndSet(false);
        this.uploadFile(new File(this.config.getLogPath()), String.format("log/%s", Configuration.NUDGE_LOG));
        if (isFirstUpload && this.config.useFineLogOnStartup() && !this.config.hasExplicitLogLevel()) {
            Logger.getLogger(null).setLevel(Configuration.DEFAULT_LOG_LEVEL);
        }
    }

    void uploadConfig() {
        String properties = this.config.getPropertiesPath();
        if (null != properties) {
            this.uploadFile(new File(properties), Configuration.NUDGE_PROPERTIES);
        }
        this.firstConfigUpload.set(false);
    }

    private void uploadFile(File f, String path) {
        log.finest("uploading file %s -> %s", f, path);
        if (!f.isFile()) {
            log.warning("missing or invalid file : %s", f);
            return;
        }
        try {
            this.connector.uploadFile(f, path);
        }
        catch (IOException e) {
            log.severe("unable to upload file " + e.getMessage(), new Object[0]);
        }
    }

    @Override
    public int getTransactionsQueueSize() {
        return this.transactions.getSize();
    }

    @Override
    public int getJmxSamplesSize() {
        return this.mBeans.getSize();
    }

    @Override
    public int getRumQueueSize() {
        return this.browserTimings.getSize();
    }

    @Override
    public int getThreadSamplesSize() {
        return this.threadInfos.getSize();
    }

    @Override
    public String getServerId() {
        return this.serverId;
    }

    @Override
    public String getServerInfo() {
        return this.serverInfo;
    }

    @Override
    public void setServerInfo(String serverInfo) {
        this.serverInfo = serverInfo;
    }

    @Override
    public void setPort(long port) {
        if (this.serverPort != null) {
            return;
        }
        this.serverPort = port;
    }

    void setOrchestrator(Orchestrator orchestrator) {
        this.orchestrator = orchestrator;
    }

    @Override
    public void send(RawDataProtocol.Transaction.Builder transaction) {
        if (!this.enabled.get()) {
            return;
        }
        this.checkTransaction(transaction);
        this.addToFlushableCollection(this.transactions, transaction, this.config.getFlushTxCount(), "tx");
    }

    private <T> void addToFlushableCollection(FlushableCollection<T> collection, T item, int flushTrigger, String collectionDesc) {
        Checker.checkArgument(null != item);
        int count = collection.add(item);
        if (collection.isLimitReached()) {
            log.fine("%s capacity limit reached (%d), ", collectionDesc, collection.getSizeLimit());
        }
        if (flushTrigger > 0 && count >= flushTrigger) {
            this.requestFlush("%s count (%d) >= trigger (%d)", collectionDesc, count, flushTrigger);
        }
    }

    private void checkTransaction(RawDataProtocol.Transaction.Builder t) {
        Checker.checkArgument(t.hasStartTime(), "missing start time");
        Checker.checkArgument(t.hasEndTime(), "missing end time");
        Checker.checkArgument(t.getStartTime() <= t.getEndTime(), "invalid start/end time");
        Checker.checkArgument(t.hasCode() && t.getCode().length() > 0, "missing or empty code");
    }

    @Override
    public void send(RawDataProtocol.ThreadInfo.Builder threadInfo) {
        if (!this.enabled.get()) {
            return;
        }
        this.addToFlushableCollection(this.threadInfos, threadInfo, this.config.getFlushThreadSamplesCount(), "thread samples");
    }

    @Override
    public void send(RawDataProtocol.MBean.Builder mBean) {
        if (!this.enabled.get()) {
            return;
        }
        this.addToFlushableCollection(this.mBeans, mBean, this.config.getFlushJmxSamplesCount(), "jmx samples");
    }

    @Override
    public void send(RawDataProtocol.TroubleshootingEvents.Builder event) {
        if (!this.enabled.get()) {
            return;
        }
        this.addToFlushableCollection(this.tsEvents, event, -1, "events");
    }

    @Override
    public void send(RawDataProtocol.SystemMetricSample sysMetric) {
        if (!this.enabled.get()) {
            return;
        }
        this.addToFlushableCollection(this.sysMetrics, sysMetric, this.config.getFlushSystemMetricsSampleCount(), "system metrics");
    }

    @Override
    public synchronized void notifyError(VirtualMachineError error) {
        if (!this.enabled.get()) {
            return;
        }
        if (NudgeOutOfMemoryMonitor.isAlive()) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("VirtualMachineError interception : ");
        buf.append(error.getClass().getName());
        buf.append(" (");
        buf.append(error.getMessage());
        buf.append(")");
        log.severe(buf.toString(), new Object[0]);
        if (error instanceof OutOfMemoryError) {
            RawDataProtocol.TroubleshootingEvents.Builder oom = RawDataProtocol.TroubleshootingEvents.newBuilder();
            oom.setTimestamp(System.currentTimeMillis());
            oom.setType(RawDataProtocol.TroubleshootingEvents.EventType.OutOfMemory);
            RawDataProtocol.ThreadInfo.Builder threadInfo = RawDataProtocol.ThreadInfo.newBuilder();
            threadInfo.setUrl("");
            threadInfo.setUuid("");
            threadInfo.setState(RawDataProtocol.ThreadInfo.State.RUNNABLE);
            threadInfo.setTimeStamp(System.currentTimeMillis());
            for (StackTraceElement ste : error.getStackTrace()) {
                threadInfo.addFramesBuilder().setClassName(ste.getClassName()).setMethodName(ste.getMethodName()).setLineNumber(ste.getLineNumber());
            }
            oom.addThreadInfos(threadInfo);
            this.tsEvents.add(oom);
        }
        NudgeOutOfMemoryMonitor.start(this);
    }

    @Override
    public void sendEndUserTiming(String perf) {
        if (!this.enabled.get()) {
            return;
        }
        this.addToFlushableCollection(this.browserTimings, perf, this.config.getFlushRumCount(), "browser timing");
    }

    void requestFlush(String reason, Object ... reasonArgs) {
        boolean skip;
        log.fine("flush : " + reason, reasonArgs);
        boolean bl = skip = this.flushRequested.getAndSet(true) || this.flushRunning.get();
        if (skip) {
            log.fine("flush already requested or running, request will be ignored", new Object[0]);
            return;
        }
        if (null == this.orchestrator) {
            log.finest("direct flush execution", new Object[0]);
            this.doFlush();
        } else {
            log.finest("schedule flush execution", new Object[0]);
            this.orchestrator.delegate(new Runnable(){

                @Override
                public void run() {
                    CollectorImpl.this.doFlush();
                }
            });
        }
    }

    boolean isFlushRunning() {
        return this.flushRunning.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFlush() {
        boolean running = this.flushRunning.getAndSet(true);
        if (running) {
            log.fine("collector already flushing, skipping execution", new Object[0]);
            return;
        }
        try {
            long start = System.currentTimeMillis();
            Collection<RawDataProtocol.Transaction.Builder> txToFlush = this.transactions.flush();
            Collection<String> rumToFlush = this.browserTimings.flush();
            Collection<RawDataProtocol.ThreadInfo.Builder> threadsToFlush = this.threadInfos.flush();
            Collection<RawDataProtocol.MBean.Builder> mbeansToFlush = this.mBeans.flush();
            Collection<RawDataProtocol.SystemMetricSample> sysMetricsToFlush = this.sysMetrics.flush();
            Collection<RawDataProtocol.TroubleshootingEvents.Builder> eventsToFlush = this.tsEvents.flush();
            TransactionFilter.filterTransactions(txToFlush, this.flushFilteringRate, this.flushFilteringType, rumToFlush.size(), threadsToFlush.size(), mbeansToFlush.size(), eventsToFlush.size(), sysMetricsToFlush.size(), log);
            Collection<String> componentsFiles = this.components.flush();
            Thread.currentThread().setName("nudge-collector");
            RawDataProtocol.RawData.Builder rawdata = RawDataProtocol.RawData.newBuilder();
            rawdata.setId(this.packetCounter++);
            rawdata.setAgentId(this.serverId);
            if (this.packetCounter < 20L) {
                if (this.serverConfig == null) {
                    ServerConfigBuilder builder = new ServerConfigBuilder();
                    String version = this.config.getVersion();
                    if (null == version) {
                        version = "";
                    }
                    this.serverConfig = builder.getBuffer(this.jvmInfo, this.serverPort, this.serverInfo, version, this.config.isAllowedInstanceConfig());
                }
                rawdata.setServerConfig(this.serverConfig);
            }
            for (String file : componentsFiles) {
                CollectorImpl.writeComponent(rawdata, JarInfo.fromJar(file));
            }
            String hostNamePort = this.jvmInfo.getHostName();
            if (null != this.serverPort) {
                hostNamePort = hostNamePort + ":" + this.serverPort;
            }
            rawdata.setHostname(hostNamePort);
            rawdata.setHostkey(this.config.getHostKey());
            try {
                rawdata.setHeapMemory(this.heapMemoryBuilder.getBuffer());
                rawdata.setGcActivity(this.gcActivityBuilder.getBuffer());
                rawdata.setThreadActivity(this.threadActivityBuilder.getBuffer());
            }
            catch (Throwable file) {
                // empty catch block
            }
            HashMap<String, Integer> classDictionary = new HashMap<String, Integer>();
            HashMap<String, Integer> methodDictionary = new HashMap<String, Integer>();
            for (RawDataProtocol.ThreadInfo.Builder builder : threadsToFlush) {
                for (RawDataProtocol.ThreadInfo.StackTraceElement.Builder builder2 : builder.getFramesBuilderList()) {
                    builder2.setClassNameId(CollectorImpl.getIdFromDictionaryMap(classDictionary, builder2.getClassName()));
                    builder2.clearClassName();
                    builder2.setMethodNameId(CollectorImpl.getIdFromDictionaryMap(methodDictionary, builder2.getMethodName()));
                    builder2.clearMethodName();
                }
                rawdata.addThreadInfos(builder.build());
            }
            HashMap<String, Integer> mbeanDictionary = new HashMap<String, Integer>();
            for (RawDataProtocol.MBean.Builder builder : mbeansToFlush) {
                for (RawDataProtocol.MBeanAttributeInfo.Builder attr : builder.getAttributeInfoBuilderList()) {
                    attr.setNameId(CollectorImpl.getIdFromDictionaryMap(mbeanDictionary, attr.getName()));
                    attr.clearName();
                    attr.setTypeId(CollectorImpl.getIdFromDictionaryMap(mbeanDictionary, attr.getType()));
                    attr.clearType();
                    attr.setDescriptionId(CollectorImpl.getIdFromDictionaryMap(mbeanDictionary, attr.getDescription()));
                    attr.clearDescription();
                }
                rawdata.addMBean(builder);
            }
            for (RawDataProtocol.SystemMetricSample systemMetricSample : sysMetricsToFlush) {
                rawdata.addSystemMetrics(systemMetricSample);
            }
            for (RawDataProtocol.TroubleshootingEvents.Builder builder : eventsToFlush) {
                rawdata.addTroubleshootingEvents(builder);
            }
            for (String string : rumToFlush) {
                rawdata.addEndUserTiming(string);
            }
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
            HashMap<String, Integer> hashMap3 = new HashMap<String, Integer>();
            HashMap<String, Integer> sqlDictionary = new HashMap<String, Integer>();
            for (RawDataProtocol.Transaction.Builder t : txToFlush) {
                if (this.config.prependTxTypeToUrl() && t.hasTxType()) {
                    t.setUrl(String.format("%s %s", t.getTxType(), t.getUrl()));
                }
                t.setUrlID(CollectorImpl.getIdFromDictionaryMap(hashMap2, t.getUrl()));
                t.clearUrl();
                t.setUseragentID(CollectorImpl.getIdFromDictionaryMap(hashMap3, t.getUserAgent()));
                t.clearUserAgent();
                t.clearSqlRequests();
                if (t.getProducedJMSList() != null) {
                    for (RawDataProtocol.JMSMessage.Builder jmsMessage : t.getProducedJMSBuilderList()) {
                        jmsMessage.setUrlId(CollectorImpl.getIdFromDictionaryMap(hashMap, jmsMessage.getUrlName()));
                        jmsMessage.clearUrlName();
                        jmsMessage.setQueueId(CollectorImpl.getIdFromDictionaryMap(hashMap, jmsMessage.getQueueName()));
                        jmsMessage.clearQueueName();
                    }
                }
                if (t.getConsumedJMSList() != null) {
                    for (RawDataProtocol.JMSMessage.Builder jmsMessage : t.getConsumedJMSBuilderList()) {
                        jmsMessage.setUrlId(CollectorImpl.getIdFromDictionaryMap(hashMap, jmsMessage.getUrlName()));
                        jmsMessage.clearUrlName();
                        jmsMessage.setQueueId(CollectorImpl.getIdFromDictionaryMap(hashMap, jmsMessage.getQueueName()));
                        jmsMessage.clearQueueName();
                    }
                }
                rawdata.addTransactions(t.build());
            }
            CollectorImpl.buildDictionaryEntries(rawdata.getJmsDictionaryBuilder(), hashMap);
            CollectorImpl.buildDictionaryEntries(rawdata.getSegmentDictionaryBuilder(), hashMap2);
            CollectorImpl.buildDictionaryEntries(rawdata.getUserAgentBuilder(), hashMap3);
            CollectorImpl.buildDictionaryEntries(rawdata.getQueryDictionaryBuilder(), sqlDictionary);
            CollectorImpl.buildDictionaryEntries(rawdata.getMbeanDictionaryBuilder(), mbeanDictionary);
            CollectorImpl.buildDictionaryEntries(rawdata.getClassDictionaryBuilder(), classDictionary);
            CollectorImpl.buildDictionaryEntries(rawdata.getMethodDictionaryBuilder(), methodDictionary);
            try {
                this.connector.sendRawdata(rawdata.build());
            }
            catch (IOException e) {
                log.severe(e, "flush error : %s", e.getMessage());
            }
            log.fine("collector flush end %d ms", System.currentTimeMillis() - start);
        }
        catch (Throwable t) {
            log.severe(t, "flush error : %s", t.getMessage());
        }
        finally {
            this.flushRequested.set(false);
            this.flushRunning.set(false);
        }
    }

    private static void writeComponent(RawDataProtocol.RawData.Builder rawdata, JarInfo jarInfo) {
        String sha1 = jarInfo.getSha1();
        RawDataProtocol.Component.Builder builder = rawdata.addComponentsBuilder().setKey(String.format("jar:%s", sha1)).setFileSha1(sha1).setFileName(jarInfo.getFileName());
        for (JarInfo.MavenGAV mavenGAV : jarInfo.getMaven()) {
            builder.addMavenComponentsBuilder().setGroupId(mavenGAV.getGroupId()).setArtifactId(mavenGAV.getArtifactId()).setVersion(mavenGAV.getVersion());
        }
        for (Map.Entry entry : jarInfo.getManifest().entrySet()) {
            builder.addJarManifestBuilder().setKey((String)entry.getKey()).setValue((String)entry.getValue());
        }
    }

    private static int getIdFromDictionaryMap(Map<String, Integer> dictionaryMap, String value) {
        if (dictionaryMap.containsKey(value)) {
            return dictionaryMap.get(value);
        }
        int newId = dictionaryMap.size();
        dictionaryMap.put(value, newId);
        return newId;
    }

    private static void buildDictionaryEntries(RawDataProtocol.Dictionary.Builder dictionaryBuilder, Map<String, Integer> dictionaryMap) {
        for (String value : dictionaryMap.keySet()) {
            RawDataProtocol.Dictionary.DictionaryEntry.Builder dictionaryEntry = RawDataProtocol.Dictionary.DictionaryEntry.newBuilder();
            dictionaryEntry.setId(dictionaryMap.get(value));
            dictionaryEntry.setName(value);
            dictionaryBuilder.addDictionary(dictionaryEntry);
        }
    }

    @Override
    public void addJarComponent(String path) {
        if (!this.enabled.get()) {
            return;
        }
        Checker.checkArgument(null != path);
        if (new File(path).isFile()) {
            this.components.add(path);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.get();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled.set(enabled);
    }

    public FlushableCollectionMBean getTransactionsQueueMBean() {
        return this.transactions;
    }

    public FlushableCollectionMBean getRumQueueMBean() {
        return this.browserTimings;
    }

    public FlushableCollectionMBean getProfilingQueueMBean() {
        return this.threadInfos;
    }

    public FlushableCollectionMBean getJmxQueueMBean() {
        return this.mBeans;
    }

    public FlushableCollectionMBean getTsEventsQueueMBean() {
        return this.tsEvents;
    }

    public FlushableCollectionMBean getSystemMetricsQueueMBean() {
        return this.sysMetrics;
    }

    public FlushableCollectionMBean getComponentsQueueMBean() {
        return this.components;
    }
}

