/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.collector;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.nudge.probe.collector.FlushableCollectionMBean;

public class FlushableCollection<T>
implements FlushableCollectionMBean {
    private final AtomicReference<Collection<T>> collection = new AtomicReference<Collection<T>>(this.newCollection());
    private final int sizeLimit;
    private volatile int count;

    FlushableCollection(int sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    protected Collection<T> newCollection() {
        return new ConcurrentLinkedQueue();
    }

    public int add(T item) {
        if (this.sizeLimit < 0 || this.count < this.sizeLimit) {
            this.collection.get().add(item);
            ++this.count;
        }
        return this.count;
    }

    @Override
    public int getSize() {
        return this.count;
    }

    @Override
    public int getSizeLimit() {
        return this.sizeLimit;
    }

    public Collection<T> flush() {
        this.count = 0;
        return this.collection.getAndSet(this.newCollection());
    }

    public boolean isLimitReached() {
        return this.count >= this.sizeLimit;
    }
}

