/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.collector;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;

public class HttpConnectorResponse {
    private final int status;
    private final InputStream body;
    private final String bodyEncoding;
    private final Exception exception;
    private final URL url;
    private final Map<String, String> headers;

    HttpConnectorResponse(URL url, int status, byte[] body, String encoding, Map<String, String> headers) {
        this.url = url;
        this.status = status;
        this.body = null != body ? new ByteArrayInputStream(body) : null;
        this.bodyEncoding = null;
        this.exception = null;
        this.headers = headers;
    }

    HttpConnectorResponse(URL url, int status, byte[] body, String encoding) {
        this.url = url;
        this.status = status;
        this.body = null != body ? new ByteArrayInputStream(body) : null;
        this.bodyEncoding = null;
        this.exception = null;
        this.headers = Collections.emptyMap();
    }

    HttpConnectorResponse(URL url, Exception exception) {
        this.url = url;
        this.status = -1;
        this.body = null;
        this.bodyEncoding = null;
        this.exception = exception;
        this.headers = Collections.emptyMap();
    }

    public int getStatus() {
        return this.status;
    }

    public String toString() {
        if (null != this.exception) {
            return String.format("%s %s", this.url, this.exception.getMessage());
        }
        return String.format("%s %d", this.url, this.status);
    }

    public InputStream getBody() {
        return this.body;
    }

    public String getBodyEncoding() {
        return this.bodyEncoding;
    }

    public Exception getThrownException() {
        return this.exception;
    }

    public URL getUrl() {
        return this.url;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }
}

