/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.collector;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.Map;
import org.nudge.dependency.oaci.IOUtils;
import org.nudge.probe.collector.HttpConnector;
import org.nudge.probe.collector.HttpConnectorResponse;
import org.nudge.probe.collector.WriteData;
import org.nudge.probe.conf.ConnectorConfig;
import org.nudge.probe.conf.ProxyConfig;

public class JdkHttpConnector
implements HttpConnector {
    private final ConnectorConfig config;

    public JdkHttpConnector(ConnectorConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public HttpConnectorResponse request(String method, URL url, WriteData body, Map<String, String> headers) throws IOException {
        void var8_16;
        int code;
        String contentType;
        HttpURLConnection connection;
        ProxyConfig proxyConfig = this.config.getProxyConfig();
        if (proxyConfig.useProxy()) {
            InetSocketAddress addr = new InetSocketAddress(proxyConfig.getHost(), proxyConfig.getPort());
            Proxy proxy = new Proxy(proxyConfig.getType(), addr);
            connection = (HttpURLConnection)url.openConnection(proxy);
        } else {
            connection = (HttpURLConnection)url.openConnection();
        }
        connection.setRequestMethod(method);
        if (method.equals("POST") || method.equals("PUT")) {
            connection.setDoOutput(true);
        }
        if (null != headers) {
            for (Map.Entry entry : headers.entrySet()) {
                connection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        connection.setConnectTimeout(this.config.getConnectTimeout());
        connection.setReadTimeout(this.config.getReadTimeout());
        connection.setInstanceFollowRedirects(false);
        if (null != body && null != (contentType = body.getContentType())) {
            connection.setRequestProperty("Content-Type", contentType);
        }
        connection.connect();
        if (null != body) {
            OutputStream output = connection.getOutputStream();
            try {
                body.writeTo(output);
            }
            finally {
                IOUtils.closeQuietly(output);
            }
        }
        try {
            code = connection.getResponseCode();
        }
        catch (IOException iOException) {
            code = connection.getResponseCode();
        }
        InputStream inputStream = null;
        String responseEncoding = null;
        byte[] responseBody = null;
        try {
            if (200 == code) {
                InputStream inputStream2 = connection.getInputStream();
            } else {
                InputStream inputStream3 = connection.getErrorStream();
            }
            if (var8_16 != null) {
                responseBody = IOUtils.toByteArray((InputStream)var8_16);
            }
            responseEncoding = connection.getContentEncoding();
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)var8_16);
        return new HttpConnectorResponse(url, code, responseBody, responseEncoding);
    }
}

