/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.collector;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.nudge.dependency.cnab.probe.RawDataProtocol;
import org.nudge.dependency.oaci.FileUtils;
import org.nudge.dependency.oaci.IOUtils;
import org.nudge.dependency.oaci.comparator.LastModifiedFileComparator;
import org.nudge.dependency.oaci.filefilter.PrefixFileFilter;
import org.nudge.dependency.oaci.output.CountingOutputStream;
import org.nudge.probe.Configuration;
import org.nudge.probe.CurrentTime;
import org.nudge.probe.Util;
import org.nudge.probe.collector.ConnectorStatus;
import org.nudge.probe.collector.HttpConnector;
import org.nudge.probe.collector.HttpConnectorResponse;
import org.nudge.probe.collector.WriteData;
import org.nudge.probe.log.Logger;
import org.nudge.probe.util.Checker;
import org.nudge.probe.util.Lz4;

public class NudgeConnector {
    private static final Logger LOG = Logger.getLogger(null);
    private static final String ERROR_FILE_PREFIX = "networkError";
    private static final String DUMP_FILE_PREFIX = "rawdata";
    private static final String UNCOMPRESSED_FILE_EXTENSION = "log";
    private static final String HANDLER_HTTP = "http";
    private static final String HANDLER_FILE = "file";
    private static final int RESPONSE_MSG_MAX_LENGTH = 200;
    private static final Comparator<File> RAWDATA_COMPARATOR = new RawdataComparator();
    public static final int DEFAULT_SERVER_RETRY = 50;
    private final FileFilter diskFallbackToSendFilter;
    private static final FileFilter FALLBACK_FILTER = new PrefixFileFilter("networkError");
    private static final FileFilter DUMP_FILTER = new PrefixFileFilter("rawdata");
    private static String knownNudgeConfigHash = "unknownn";
    private final HttpConnector connector;
    private final Configuration config;
    private final boolean dumpToDisk;
    private final CurrentTime time;
    private final Map<String, String> headers;
    private int currentServer = 0;
    private int currentServerSuccessCount = 0;

    public NudgeConnector(Configuration config, HttpConnector connector) {
        this(config, config.getHandlers().contains(HANDLER_HTTP) ? connector : null, config.getHandlers().contains(HANDLER_FILE), Util.getSystemTime());
    }

    NudgeConnector(Configuration config, HttpConnector httpConnector, boolean dumpToDisk, CurrentTime time) {
        Checker.checkArgument(null != config);
        this.config = config;
        this.dumpToDisk = dumpToDisk;
        this.connector = httpConnector;
        this.time = time;
        this.diskFallbackToSendFilter = new DiskFallbackFilefilter(config, time);
        this.headers = new HashMap<String, String>();
        this.headers.put("User-Agent", String.format("nudge/%s java/%s", config.getVersion(), System.getProperty("java.version")));
    }

    public void sendRawdata(final RawDataProtocol.RawData rawdata) throws IOException {
        WriteTo dumpData = new WriteTo(){

            @Override
            public void writeTo(OutputStream out) throws IOException {
                rawdata.writeTo(out);
            }
        };
        if (null != this.connector) {
            this.sendToNudge(dumpData);
        }
        if (this.dumpToDisk) {
            this.dumpToDisk(dumpData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToNudge(WriteTo dumpData) throws IOException {
        final boolean compressed = this.config.isCompressed();
        final File tempFile = compressed ? NudgeConnector.compressToTempFile(dumpData, this.config.getLogDirectory()) : NudgeConnector.dumpToTempFile(dumpData);
        try {
            String respConfigHash;
            WriteData data = new WriteData(){

                @Override
                public void writeTo(OutputStream out) throws IOException {
                    CountingOutputStream countingOutput = new CountingOutputStream(out);
                    FileUtils.copyFile(tempFile, countingOutput);
                    LOG.fine("%s sent to nudge platform", FileUtils.byteCountToDisplaySize(countingOutput.getByteCount()));
                }

                @Override
                public String getContentType() {
                    return compressed ? Lz4.LZ4_MIME_TYPE : null;
                }

                @Override
                public long getContentLength() {
                    return tempFile.length();
                }
            };
            String responseMsg = null;
            HttpConnectorResponse response = this.requestWithFallback("PUT", this.getRawDataUrl(), data);
            if (response.getStatus() != 200 && null != response.getBody() && (responseMsg = IOUtils.toString(response.getBody())).length() > 200) {
                responseMsg = responseMsg.substring(0, 200);
            }
            switch (response.getStatus()) {
                case 200: {
                    int sentCount = this.sendDiskFiles();
                    if (sentCount <= 0) break;
                    LOG.info("%d disk fallback file(s) sent", sentCount);
                    break;
                }
                case 400: {
                    LOG.severe("bad request %s : %s", response.getStatus(), responseMsg);
                    break;
                }
                default: {
                    LOG.severe("unable to send data : %s %s %s", response.getUrl(), response.getStatus(), responseMsg);
                    this.writeToDiskFallback(tempFile);
                }
            }
            if ((respConfigHash = response.getHeaders().get("Nudge-Config-Hash")) != null && !respConfigHash.equals(knownNudgeConfigHash)) {
                this.updateControllerConfiguration(knownNudgeConfigHash);
                knownNudgeConfigHash = respConfigHash;
            }
        }
        finally {
            FileUtils.deleteQuietly(tempFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateControllerConfiguration(String hash) {
        boolean responseOk = false;
        HttpConnectorResponse response = null;
        int serverCount = this.config.getServerUrls().size();
        for (int i = 0; !responseOk && i < serverCount; ++i) {
            URL url;
            block9: {
                String serverUrl = this.getCurrentServerUrl();
                url = Util.createUrl(serverUrl + "/api/config/" + this.config.getAppId() + "/properties", new Object[0]);
                try {
                    response = this.connector.request("GET", url, null, Collections.singletonMap("If-None-Match", "\"" + hash + "\""));
                    responseOk = response.getStatus() == 200;
                    ++this.currentServerSuccessCount;
                    if (responseOk) {
                        File controllerConfigFile = new File(this.config.getDiskDumpDirectory(), Configuration.CONTROLLER_PROPERTIES);
                        FileUtils.copyInputStreamToFile(response.getBody(), controllerConfigFile);
                        this.config.applyControllerConfig();
                    }
                    if (responseOk) break block9;
                }
                catch (IOException e) {
                    block10: {
                        try {
                            response = new HttpConnectorResponse(url, e);
                            if (responseOk) break block10;
                        }
                        catch (Throwable throwable) {
                            if (!responseOk) {
                                LOG.fine("unable to receive config from %s", response);
                                this.currentServer = (this.currentServer + 1) % serverCount;
                                this.currentServerSuccessCount = 0;
                            } else {
                                LOG.fine("config received from GET %s", url);
                                if (this.currentServer > 0 && this.currentServerSuccessCount > 50) {
                                    this.currentServer = 0;
                                    this.currentServerSuccessCount = 0;
                                }
                            }
                            throw throwable;
                        }
                        LOG.fine("unable to receive config from %s", response);
                        this.currentServer = (this.currentServer + 1) % serverCount;
                        this.currentServerSuccessCount = 0;
                        continue;
                    }
                    LOG.fine("config received from GET %s", url);
                    if (this.currentServer <= 0 || this.currentServerSuccessCount <= 50) continue;
                    this.currentServer = 0;
                    this.currentServerSuccessCount = 0;
                    continue;
                }
                LOG.fine("unable to receive config from %s", response);
                this.currentServer = (this.currentServer + 1) % serverCount;
                this.currentServerSuccessCount = 0;
                continue;
            }
            LOG.fine("config received from GET %s", url);
            if (this.currentServer <= 0 || this.currentServerSuccessCount <= 50) continue;
            this.currentServer = 0;
            this.currentServerSuccessCount = 0;
            continue;
        }
    }

    private void writeToDiskFallback(File tempFile) {
        File file = null;
        try {
            File directory = this.config.getDiskFallbackDirectory();
            this.enforceStorageLimitAndCleanup(directory, FALLBACK_FILTER, this.config.getDiskFallbackMaxSize(), tempFile.length());
            file = this.getNewFile(directory, ERROR_FILE_PREFIX, this.config.isCompressed() ? "lz4" : UNCOMPRESSED_FILE_EXTENSION);
            FileUtils.copyFile(tempFile, file);
        }
        catch (IOException e) {
            LOG.fine(e, "unable to store to disk fallback", new Object[0]);
            FileUtils.deleteQuietly(file);
        }
    }

    private void dumpToDisk(WriteTo dumpData) throws IOException {
        File dumpFile = null;
        File uncompressedDump = null;
        try {
            uncompressedDump = NudgeConnector.dumpToTempFile(dumpData);
            File directory = this.config.getDiskDumpDirectory();
            this.enforceStorageLimitAndCleanup(directory, DUMP_FILTER, this.config.getDiskDumpMaxSize(), uncompressedDump.length());
            dumpFile = this.getNewFile(directory, DUMP_FILE_PREFIX, UNCOMPRESSED_FILE_EXTENSION);
            FileUtils.moveFile(uncompressedDump, dumpFile);
        }
        catch (IOException e) {
            FileUtils.deleteQuietly(dumpFile);
            throw new NudgeConnectorException(e);
        }
        finally {
            FileUtils.deleteQuietly(uncompressedDump);
        }
    }

    private void enforceStorageLimitAndCleanup(File directory, FileFilter filter, long limit, long newFileSize) {
        if (limit <= 0L) {
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        long totalSize = 0L;
        for (File file : NudgeConnector.listFiles(directory, filter)) {
            long fileSize = file.length();
            if (0L == fileSize) {
                LOG.fine("delete empty file : %s", file);
                FileUtils.deleteQuietly(file);
                continue;
            }
            files.add(file);
            totalSize += fileSize;
        }
        for (int i = 0; i < files.size() && totalSize > limit - newFileSize; ++i) {
            File f = (File)files.get(i);
            long size = f.length();
            if (!FileUtils.deleteQuietly(f)) continue;
            totalSize -= size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFile(File file, String path) throws IOException {
        FileInputStream input;
        if (null == this.connector) {
            return;
        }
        HttpConnectorResponse response = null;
        try {
            input = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("file should exist : " + file);
        }
        WriteTo dumpFile = new WriteTo(){

            @Override
            public void writeTo(OutputStream out) throws IOException {
                IOUtils.copy((InputStream)input, out);
            }
        };
        File tempFile = null;
        try {
            final File finalTempFile = tempFile = this.config.isCompressed() ? NudgeConnector.compressToTempFile(dumpFile, this.config.getLogDirectory()) : NudgeConnector.dumpToTempFile(dumpFile);
            response = this.requestWithFallback("PUT", this.getUploadUrl(path), new WriteData(){

                @Override
                public void writeTo(OutputStream out) throws IOException {
                    FileUtils.copyFile(finalTempFile, out);
                }

                @Override
                public String getContentType() {
                    return NudgeConnector.this.config.isCompressed() ? Lz4.LZ4_MIME_TYPE : null;
                }

                @Override
                public long getContentLength() {
                    return finalTempFile.length();
                }
            });
        }
        catch (Throwable throwable) {
            FileUtils.deleteQuietly(tempFile);
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        FileUtils.deleteQuietly(tempFile);
        IOUtils.closeQuietly(input);
    }

    public ConnectorStatus testConnection() {
        Checker.checkState(null != this.connector, "no http connector available, unable to test connection, please check probe configuration");
        HttpConnectorResponse response = this.requestWithFallback("GET", "/", null);
        int code = response.getStatus();
        String responseBody = null;
        if (null != response.getBody()) {
            try {
                responseBody = IOUtils.toString(response.getBody());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (null != response.getThrownException()) {
            return new ConnectorStatus(response.getThrownException());
        }
        if (200 == code) {
            return new ConnectorStatus(String.format("Connection to %s successful", response.getUrl()), true);
        }
        return new ConnectorStatus(String.format("Error while connecting to %s, code: %d, response body: \n%s", response.getUrl(), code, responseBody), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpConnectorResponse requestWithFallback(String method, String path, WriteData body) {
        boolean responseOk = false;
        HttpConnectorResponse response = null;
        int serverCount = this.config.getServerUrls().size();
        for (int i = 0; !responseOk && i < serverCount; ++i) {
            URL url;
            block8: {
                String serverUrl = this.getCurrentServerUrl();
                url = Util.createUrl(serverUrl + path, new Object[0]);
                try {
                    response = this.connector.request(method, url, body, this.headers);
                    responseOk = response.getStatus() == 200;
                    ++this.currentServerSuccessCount;
                    if (responseOk) break block8;
                }
                catch (IOException e) {
                    block9: {
                        try {
                            response = new HttpConnectorResponse(url, e);
                            if (responseOk) break block9;
                        }
                        catch (Throwable throwable) {
                            if (!responseOk) {
                                LOG.fine("unable to send request to server %s", response);
                                this.currentServer = (this.currentServer + 1) % serverCount;
                                this.currentServerSuccessCount = 0;
                            } else {
                                LOG.fine("data sent to %s %s", method, url);
                                if (this.currentServer > 0 && this.currentServerSuccessCount > 50) {
                                    this.currentServer = 0;
                                    this.currentServerSuccessCount = 0;
                                }
                            }
                            throw throwable;
                        }
                        LOG.fine("unable to send request to server %s", response);
                        this.currentServer = (this.currentServer + 1) % serverCount;
                        this.currentServerSuccessCount = 0;
                        continue;
                    }
                    LOG.fine("data sent to %s %s", method, url);
                    if (this.currentServer <= 0 || this.currentServerSuccessCount <= 50) continue;
                    this.currentServer = 0;
                    this.currentServerSuccessCount = 0;
                    continue;
                }
                LOG.fine("unable to send request to server %s", response);
                this.currentServer = (this.currentServer + 1) % serverCount;
                this.currentServerSuccessCount = 0;
                continue;
            }
            LOG.fine("data sent to %s %s", method, url);
            if (this.currentServer <= 0 || this.currentServerSuccessCount <= 50) continue;
            this.currentServer = 0;
            this.currentServerSuccessCount = 0;
            continue;
        }
        return response;
    }

    public String getCurrentServerUrl() {
        return this.config.getServerUrls().get(this.currentServer);
    }

    private String getRawDataUrl() {
        return String.format("/collect/rawdata/%s", this.config.getAppId());
    }

    private String getUploadUrl(String path) {
        return String.format("/collect/upload/%s/%08X/%s", this.config.getAppId(), this.config.getHostKey(), path);
    }

    private static File compressToTempFile(WriteTo compress, String logDir) throws IOException {
        File compressedFile = null;
        OutputStream compressedOut = null;
        CountingOutputStream afterCompression = null;
        CountingOutputStream beforeCompression = null;
        boolean errorDeleteFile = false;
        try {
            compressedFile = File.createTempFile("nudge-upload", "compressed");
            if (compressedFile == null) {
                compressedFile = new File(logDir + File.separator + "nudge-upload" + UUID.randomUUID() + "compressed");
            }
            afterCompression = new CountingOutputStream(new FileOutputStream(compressedFile));
            compressedOut = Lz4.compressOutputStream(afterCompression);
            beforeCompression = new CountingOutputStream(compressedOut);
            compress.writeTo(beforeCompression);
            compressedOut.flush();
        }
        catch (IOException e) {
            try {
                String filePath = "";
                if (compressedFile != null) {
                    filePath = compressedFile.getAbsolutePath();
                }
                LOG.severe(e, "unable to compress to temp file : " + filePath, new Object[0]);
                errorDeleteFile = true;
                throw new NudgeConnectorException(e, " - File path involved : " + filePath);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(compressedOut);
                IOUtils.closeQuietly(afterCompression);
                IOUtils.closeQuietly(beforeCompression);
                if (errorDeleteFile) {
                    FileUtils.deleteQuietly(compressedFile);
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly(compressedOut);
        IOUtils.closeQuietly(afterCompression);
        IOUtils.closeQuietly(beforeCompression);
        if (errorDeleteFile) {
            FileUtils.deleteQuietly(compressedFile);
        }
        long beforeSize = beforeCompression.getByteCount();
        long afterSize = afterCompression.getByteCount();
        LOG.fine("compression ratio %.02f:1, before: %s, after %s", 1.0 * (double)beforeSize / (double)afterSize, beforeSize, afterSize);
        return compressedFile;
    }

    private static File dumpToTempFile(WriteTo data) throws IOException {
        File dump = File.createTempFile("nudge-upload", "dump");
        FileOutputStream out = new FileOutputStream(dump);
        try {
            data.writeTo(out);
        }
        catch (IOException e) {
            LOG.severe(e, "unable to compress to temp file", new Object[0]);
            FileUtils.deleteQuietly(dump);
            throw new NudgeConnectorException(e);
        }
        finally {
            IOUtils.closeQuietly(out);
        }
        return dump;
    }

    private static List<File> listFiles(File folder, FileFilter filter) {
        Checker.checkArgument(null != folder);
        ArrayList<File> files = new ArrayList<File>();
        File[] list = folder.listFiles(filter);
        if (null != list) {
            files.addAll(Arrays.asList(list));
            Collections.sort(files, RAWDATA_COMPARATOR);
        }
        return files;
    }

    private int sendDiskFiles() {
        List<File> files = NudgeConnector.listFiles(this.config.getDiskFallbackDirectory(), this.diskFallbackToSendFilter);
        for (File file : files) {
            if (file.length() != 0L) continue;
            FileUtils.deleteQuietly(file);
        }
        int limit = this.config.getDiskFallbackMaxSend();
        if (files.size() > limit) {
            files = files.subList(0, limit);
        }
        int sentCount = 0;
        for (final File file : files) {
            LOG.fine("sending data from disk fallback %s", file);
            final boolean compressed = file.getName().endsWith(".lz4");
            HttpConnectorResponse response = this.requestWithFallback("PUT", this.getRawDataUrl(), new WriteData(){

                @Override
                public void writeTo(OutputStream out) throws IOException {
                    FileUtils.copyFile(file, out);
                }

                @Override
                public String getContentType() {
                    return compressed ? Lz4.LZ4_MIME_TYPE : null;
                }

                @Override
                public long getContentLength() {
                    return file.length();
                }
            });
            if (response.getStatus() != 200) continue;
            ++sentCount;
            FileUtils.deleteQuietly(file);
        }
        return sentCount;
    }

    private File getNewFile(File folder, String prefix, String extension) {
        File file = new File(folder, String.format("%s-%d.%s", prefix, this.time.currentTimeMillis(), extension));
        int i = 0;
        while (file.exists()) {
            file = new File(folder, String.format("%s-%d-%d.%s", prefix, this.time.currentTimeMillis(), ++i, extension));
        }
        return file;
    }

    private static class NudgeConnectorException
    extends IOException {
        private final IOException ioException;

        public NudgeConnectorException(IOException e, String completedMessage) {
            super(e.getMessage() + completedMessage);
            this.ioException = e;
        }

        public NudgeConnectorException(IOException e) {
            super(e.getMessage());
            this.ioException = e;
        }

        @Override
        public Throwable getCause() {
            return this.ioException;
        }
    }

    private static class DiskFallbackFilefilter
    extends PrefixFileFilter {
        private final Configuration config;
        private final CurrentTime time;

        private DiskFallbackFilefilter(Configuration config, CurrentTime time) {
            super(NudgeConnector.ERROR_FILE_PREFIX);
            this.config = config;
            this.time = time;
        }

        private boolean isNotTooOld(File f) {
            return (this.time.currentTimeMillis() - f.lastModified()) / 1000L <= this.config.getDiskFallbackIgnoreThreshold();
        }

        @Override
        public boolean accept(File file) {
            return super.accept(file) && this.isNotTooOld(file);
        }

        @Override
        public boolean accept(File file, String name) {
            return super.accept(file, name) && this.isNotTooOld(file);
        }
    }

    private static interface WriteTo {
        public void writeTo(OutputStream var1) throws IOException;
    }

    private static class RawdataComparator
    extends LastModifiedFileComparator {
        private RawdataComparator() {
        }

        @Override
        public int compare(File file1, File file2) {
            int diff = super.compare(file1, file2);
            if (diff == 0) {
                diff = file1.getName().compareTo(file2.getName());
            }
            return diff;
        }
    }
}

