/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.collector;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import org.nudge.probe.Configuration;
import org.nudge.probe.collector.CollectorImpl;
import org.nudge.probe.log.Logger;

public class NudgeOutOfMemoryMonitor
implements Runnable {
    private static final Logger log = Logger.getLogger(Configuration.DEFAULT_LOGGER_NAME);
    private static NudgeOutOfMemoryMonitor nudgeMemoryMonitor;
    private CollectorImpl collector;

    static void start(CollectorImpl collector) {
        if (nudgeMemoryMonitor != null) {
            return;
        }
        nudgeMemoryMonitor = new NudgeOutOfMemoryMonitor(collector);
        Thread t = new Thread(nudgeMemoryMonitor);
        t.setName("nudge-memory-monitor");
        t.setDaemon(true);
        t.start();
    }

    static boolean isAlive() {
        return nudgeMemoryMonitor != null;
    }

    private NudgeOutOfMemoryMonitor(CollectorImpl collector) {
        this.collector = collector;
    }

    @Override
    public void run() {
        try {
            long freeHeap;
            Thread.currentThread().setName("nudge-memory-monitor");
            MemoryMXBean bean = ManagementFactory.getMemoryMXBean();
            do {
                Thread.sleep(10000L);
                MemoryUsage mu = bean.getHeapMemoryUsage();
                freeHeap = (mu.getCommitted() - mu.getUsed()) * 100L / mu.getCommitted();
                StringBuilder buf = new StringBuilder();
                buf.append("free heap : ");
                buf.append(freeHeap);
                buf.append("% - max:");
                buf.append(mu.getMax() / 0x100000L);
                buf.append(" Mo, committed:");
                buf.append(mu.getCommitted() / 0x100000L);
                buf.append(" Mo, used:");
                buf.append(mu.getUsed() / 0x100000L);
                buf.append(" Mo");
                log.severe(buf.toString(), new Object[0]);
            } while (freeHeap <= 15L);
            nudgeMemoryMonitor = null;
        }
        catch (Throwable e) {
            nudgeMemoryMonitor = null;
            log.severe("NudgeMemoryMonitor Exception : " + e.getMessage(), new Object[0]);
        }
    }
}

