/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.collector;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;
import org.nudge.probe.Configuration;
import org.nudge.probe.ConfigurationMBean;
import org.nudge.probe.ProbeJar;
import org.nudge.probe.ProbeJarMBean;
import org.nudge.probe.Util;
import org.nudge.probe.collector.CollectorImpl;
import org.nudge.probe.collector.CollectorMBean;
import org.nudge.probe.collector.FlushableCollectionMBean;
import org.nudge.probe.collector.OrchestratorMBean;
import org.nudge.probe.jvm.JvmInfo;
import org.nudge.probe.log.Logger;
import org.nudge.probe.log.LoggerMBean;
import org.nudge.probe.sampler.JmxBeansSampler;
import org.nudge.probe.sampler.LimitSampler;
import org.nudge.probe.sampler.ProfilingSampler;
import org.nudge.probe.sampler.SamplerMBean;
import org.nudge.probe.sampler.SystemSampler;
import org.nudge.probe.util.Checker;

public class Orchestrator
implements OrchestratorMBean {
    private static final Logger log = Logger.getLogger(Configuration.DEFAULT_LOGGER_NAME);
    private static final int LOG_UPLOAD_DELAY_SECONDS = 300;
    private static final int LOG_UPLOAD_INTERVAL_SECONDS = 3600;
    private final AtomicBoolean firstLogUpload = new AtomicBoolean(true);
    private final AtomicBoolean firstConfigUpload = new AtomicBoolean(true);
    private final Configuration config;
    private final long lateInitDelay;
    private final CollectorImpl collector;
    private Status status = Status.STOPPED;
    private ScheduledExecutorService pool;
    private ProfilingSampler profilingSampler;
    private JmxBeansSampler jmxSampler;
    private SystemSampler systemSampler;
    private ProbeJar jar;
    private JvmInfo jvmInfo;
    private final boolean batchMode;
    private final Runnable lateInitTask;

    public static Orchestrator batchMode(Configuration config, CollectorImpl collector) {
        return new Orchestrator(config, 0L, true, collector);
    }

    public static Orchestrator probeMode(Configuration config, int lateInitDelay, CollectorImpl collector) {
        return new Orchestrator(config, lateInitDelay, false, collector);
    }

    private Orchestrator(final Configuration config, long lateInitDelay, final boolean batchMode, final CollectorImpl collector) {
        this.batchMode = batchMode;
        Checker.checkArgument(null != config);
        Checker.checkArgument(lateInitDelay >= 0L);
        this.lateInitDelay = lateInitDelay;
        this.config = config;
        Checker.checkArgument(null != collector);
        this.collector = collector;
        collector.setOrchestrator(this);
        this.lateInitTask = new Runnable(){

            @Override
            public void run() {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
                if (!batchMode) {
                    if (null != Orchestrator.this.jmxSampler) {
                        Orchestrator.this.jmxSampler.setMBeanServer(mbs);
                        Util.registerJmxBean(mbs, Orchestrator.this.jmxSampler, SamplerMBean.class, "org.nudge:type=JmxBeansSampler");
                    }
                    if (null != Orchestrator.this.profilingSampler) {
                        Orchestrator.this.profilingSampler.setThreadMXBean(threadMXBean);
                        Util.registerJmxBean(mbs, Orchestrator.this.profilingSampler, SamplerMBean.class, "org.nudge:type=ProfilingSampler");
                    }
                    if (null != Orchestrator.this.systemSampler) {
                        Orchestrator.this.systemSampler.setup(osMXBean, threadMXBean);
                        Util.registerJmxBean(mbs, Orchestrator.this.systemSampler, SamplerMBean.class, "org.nudge:type=SystemSampler");
                    }
                    if (null != Orchestrator.this.jvmInfo) {
                        Orchestrator.this.jvmInfo.refresh();
                    }
                    if (null != Orchestrator.this.jar) {
                        Util.registerJmxBean(mbs, Orchestrator.this.jar, ProbeJarMBean.class, "org.nudge:type=ProbeJar");
                    }
                    collector.uploadConfig();
                }
                Util.registerJmxBean(mbs, Orchestrator.this, OrchestratorMBean.class, "org.nudge:type=Orchestrator");
                Util.registerJmxBean(mbs, config, ConfigurationMBean.class, "org.nudge:type=Configuration");
                Util.registerJmxBean(mbs, log, LoggerMBean.class, "org.nudge:type=Logger");
                Util.registerJmxBean(mbs, collector, CollectorMBean.class, "org.nudge:type=Collector");
                Util.registerJmxBean(mbs, collector.getTransactionsQueueMBean(), FlushableCollectionMBean.class, "org.nudge:type=Collector.Queue,name=transactions");
                Util.registerJmxBean(mbs, collector.getRumQueueMBean(), FlushableCollectionMBean.class, "org.nudge:type=Collector.Queue,name=rum");
                Util.registerJmxBean(mbs, collector.getJmxQueueMBean(), FlushableCollectionMBean.class, "org.nudge:type=Collector.Queue,name=jmx");
                Util.registerJmxBean(mbs, collector.getProfilingQueueMBean(), FlushableCollectionMBean.class, "org.nudge:type=Collector.Queue,name=profiling");
                Util.registerJmxBean(mbs, collector.getTsEventsQueueMBean(), FlushableCollectionMBean.class, "org.nudge:type=Collector.Queue,name=events");
                Util.registerJmxBean(mbs, collector.getSystemMetricsQueueMBean(), FlushableCollectionMBean.class, "org.nudge:type=Collector.Queue,name=systemMetrics");
                Util.registerJmxBean(mbs, collector.getComponentsQueueMBean(), FlushableCollectionMBean.class, "org.nudge:type=Collector.Queue,name=components");
            }
        };
    }

    public void register(ProfilingSampler sampler) {
        this.checkNotStarted();
        Checker.checkArgument(null != sampler, "sampler should not be null");
        this.profilingSampler = sampler;
    }

    public void register(JmxBeansSampler sampler) {
        this.checkNotStarted();
        Checker.checkArgument(null != sampler, "sampler should not be null");
        this.jmxSampler = sampler;
    }

    public void register(JvmInfo jvmInfo) {
        this.checkNotStarted();
        Checker.checkArgument(null != jvmInfo);
        this.jvmInfo = jvmInfo;
    }

    public void register(ProbeJar jar) {
        this.checkNotStarted();
        Checker.checkArgument(null != jar);
        this.jar = jar;
    }

    public void register(SystemSampler sampler) {
        this.checkNotStarted();
        Checker.checkArgument(null != sampler);
        this.systemSampler = sampler;
    }

    public synchronized void start() {
        int threadDumpDuration;
        int flushInterval;
        if (this.status != Status.STOPPED) {
            return;
        }
        this.status = Status.STARTING;
        if (this.batchMode) {
            Checker.checkState(null == this.profilingSampler, "profiling sampler irrelevant for batch mode");
            Checker.checkState(null == this.jmxSampler, "jmx sampler irrelevant for batch mode");
        }
        this.registerShutdownHook();
        this.pool = Executors.newScheduledThreadPool(2, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("nudge");
                t.setDaemon(true);
                return t;
            }
        });
        if (null != this.profilingSampler) {
            this.scheduleSampler(this.profilingSampler);
        }
        if (null != this.jmxSampler) {
            this.scheduleSampler(this.jmxSampler);
        }
        if (null != this.systemSampler) {
            this.scheduleSampler(this.systemSampler);
        }
        if ((flushInterval = this.config.getFlushInterval()) > 0) {
            this.pool.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    Orchestrator.this.collector.requestFlush("scheduled", new Object[0]);
                }
            }, 90L, flushInterval, TimeUnit.SECONDS);
        }
        if (this.config.uploadLogEnabled()) {
            this.pool.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    Orchestrator.this.collector.uploadLog();
                }
            }, 300L, 3600L, TimeUnit.SECONDS);
        }
        if ((threadDumpDuration = this.config.getThreadDumpDuration()) > 0) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    int occurences = threadDumpDuration / Orchestrator.this.config.getThreadDumpFrequency();
                    for (int i = 0; i < occurences; ++i) {
                        try {
                            Thread.sleep(Orchestrator.this.config.getThreadDumpFrequency() * 1000);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Util.dumpThreads(Orchestrator.this.config.getLogDirectory());
                    }
                }
            }).start();
        }
        this.pool.schedule(this.lateInitTask, this.lateInitDelay, TimeUnit.MILLISECONDS);
        this.status = Status.STARTED;
        log.info("Orchestrator STARTED", new Object[0]);
    }

    private ScheduledFuture<?> scheduleSampler(LimitSampler sampler) {
        return this.pool.scheduleAtFixedRate(sampler, sampler.getInitialDelay(), sampler.getSampleInterval(), TimeUnit.MILLISECONDS);
    }

    public synchronized void stop() {
        if (this.status != Status.STARTED) {
            return;
        }
        this.status = Status.STOPPING;
        int retry = 5;
        while (retry-- > 0 && this.collector.isFlushRunning()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.collector.requestFlush("before shutdown", new Object[0]);
        if (this.config.configUploadEnabled() && this.firstConfigUpload.get()) {
            this.collector.uploadConfig();
        }
        if (this.config.uploadLogEnabled() && this.firstLogUpload.get()) {
            this.collector.uploadLog();
        }
        this.pool.shutdown();
        try {
            if (!this.pool.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.pool.shutdownNow();
                if (!this.pool.awaitTermination(5L, TimeUnit.SECONDS)) {
                    log.warning("unable to properly shut down executor", new Object[0]);
                }
            }
        }
        catch (InterruptedException ignored) {
            this.pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
        this.status = Status.STOPPED;
        log.info("Orchestrator STOPPED", new Object[0]);
    }

    @Override
    public void requestFlush() {
        this.collector.requestFlush("explicit flush", new Object[0]);
    }

    public Status getStatus() {
        return this.status;
    }

    @Override
    public String getState() {
        return this.status.toString();
    }

    private void checkNotStarted() {
        if (this.status != Status.STOPPED) {
            throw new IllegalStateException("orchestrator already started");
        }
    }

    private void registerShutdownHook() {
        Thread shutdownHook = new Thread(){

            @Override
            public void run() {
                Orchestrator.this.stop();
                Logger.shutdown();
            }
        };
        shutdownHook.setName("nudge-shutdown-hook");
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    public void delegate(Runnable runnable) {
        Checker.checkState(null != this.pool);
        this.pool.execute(runnable);
    }

    public static enum Status {
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

