/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.collector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.nudge.dependency.cnab.probe.RawDataProtocol;
import org.nudge.probe.log.Logger;

public class TransactionFilter {
    public static Collection<RawDataProtocol.Transaction.Builder> filterTransactions(Collection<RawDataProtocol.Transaction.Builder> transactions, int flushFilteringRate, ReducingType reducingType, int rumToFlushSize, int threadsToFlushSize, int mbeansToFlushSize, int eventsToFlushSize, int sysMetricsToFlushSize, Logger log) {
        TransactionFilter.validateFlushPercentage(flushFilteringRate, log);
        ArrayList<RawDataProtocol.Transaction.Builder> transactionList = new ArrayList<RawDataProtocol.Transaction.Builder>(transactions);
        switch (reducingType) {
            case DURATION: {
                TransactionFilter.sortByDuration(transactionList);
                break;
            }
            case RANDOM: {
                break;
            }
            case NONE: {
                return transactions;
            }
        }
        int cutoffIndex = TransactionFilter.calculateCutoffIndex(transactionList.size(), flushFilteringRate);
        List<RawDataProtocol.Transaction.Builder> filteredTransactions = transactionList.subList(0, cutoffIndex);
        TransactionFilter.logTransactionReduction(log, transactions.size(), rumToFlushSize, threadsToFlushSize, mbeansToFlushSize, eventsToFlushSize, sysMetricsToFlushSize, reducingType, flushFilteringRate);
        return filteredTransactions;
    }

    private static void sortByDuration(List<RawDataProtocol.Transaction.Builder> transactions) {
        if (transactions.isEmpty()) {
            return;
        }
        Collections.sort(transactions, new Comparator<RawDataProtocol.Transaction.Builder>(){

            @Override
            public int compare(RawDataProtocol.Transaction.Builder t1, RawDataProtocol.Transaction.Builder t2) {
                long duration1 = t1.getEndTime() - t1.getStartTime();
                long duration2 = t2.getEndTime() - t2.getStartTime();
                return Long.compare(duration2, duration1);
            }
        });
    }

    private static int calculateCutoffIndex(int totalSize, int flushPercentage) {
        return (int)((double)totalSize * ((double)(100 - flushPercentage) / 100.0));
    }

    private static void logTransactionReduction(Logger log, int txCount, int rumCount, int threadsCount, int mbeansCount, int eventsCount, int sysMetricsCount, ReducingType reducingType, int flushFilteringRate) {
        switch (reducingType) {
            case DURATION: {
                log.info("collector flush Duration reduced by %d%% - tx: %d, rum: %d, threads: %d, mbeans: %d, events: %d, system: %d", flushFilteringRate, txCount, rumCount, threadsCount, mbeansCount, eventsCount, sysMetricsCount);
                break;
            }
            case RANDOM: {
                log.info("collector flush randomly reduced by %d%% - tx: %d, rum: %d, threads: %d, mbeans: %d, events: %d, system: %d", flushFilteringRate, txCount, rumCount, threadsCount, mbeansCount, eventsCount, sysMetricsCount);
                break;
            }
            case NONE: {
                log.info("collector flush - tx: %d, rum: %d, threads: %d, mbeans: %d, events: %d, system: %d", txCount, rumCount, threadsCount, mbeansCount, eventsCount, sysMetricsCount);
                break;
            }
            default: {
                log.info("collector flush - tx: %d, rum: %d, threads: %d, mbeans: %d, events: %d, system: %d", txCount, rumCount, threadsCount, mbeansCount, eventsCount, sysMetricsCount);
            }
        }
    }

    private static void validateFlushPercentage(int flushPercentage, Logger log) {
        if (flushPercentage < 0 || flushPercentage >= 100) {
            log.severe("flush_filtering_rate must be between 0 and 100, using default value of 0. Found: {0}", flushPercentage);
            throw new IllegalArgumentException("flush_filtering_rate must be between 0 and 100");
        }
    }

    public static enum ReducingType {
        DURATION,
        RANDOM,
        NONE;

    }
}

