/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.conf;

import java.util.Properties;
import org.nudge.probe.Configuration;
import org.nudge.probe.log.Logger;
import org.nudge.probe.util.Checker;

public class ConfigParam<T> {
    private static final Logger log = Logger.getLogger(Configuration.DEFAULT_LOGGER_NAME);
    private final String name;
    private final ConvertFunction<T> convert;
    private ValidateFunction<T> validate;
    private boolean mandatory;
    private boolean isReloadable;
    private T defaultValue;
    private T actualValue;
    private boolean confidential;
    private String legacyName;

    public ConfigParam(String name, ConvertFunction<T> convert) {
        this.name = name;
        this.mandatory = false;
        this.isReloadable = false;
        this.convert = convert;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T load(Properties properties, boolean isConfigReloading) {
        Checker.checkArgument(null != properties);
        String value = properties.getProperty(this.name);
        if (null != this.legacyName && null != (value = properties.getProperty(this.name))) {
            log.warning("%s property is deprecated, please update your configuration to use %s", this.name, this.legacyName);
        }
        if (null == value) {
            if (this.mandatory) {
                throw new IllegalArgumentException("missing mandatory configuration " + this.name);
            }
            this.actualValue = this.defaultValue;
        } else {
            value = value.trim();
            try {
                this.actualValue = this.convert.convert(value);
                if (null != this.validate) {
                    this.validate.validate(this.actualValue);
                }
            }
            catch (Exception e) {
                log.severe(e, "configuration error for parameter %s, invalid value : %s, will use default", this.name, value);
                this.actualValue = this.defaultValue;
            }
        }
        if (!isConfigReloading) {
            String printValue;
            String string = printValue = null != this.actualValue ? this.actualValue.toString() : "null";
            if (this.confidential) {
                printValue = "** secret **";
            }
            if (this.mandatory || !this.isDefaultValue()) {
                String commentSring = this.mandatory ? "[mandatory]" : String.format("[default = %s]", this.defaultValue);
                log.config("nudge config : %s = %s %s", this.name, printValue, commentSring);
            }
        } else if (isConfigReloading && this.isReloadable) {
            String printValue = null != this.actualValue ? this.actualValue.toString() : "null";
            log.config("nudge new config [%s = %s]", this.name, printValue);
        }
        return this.actualValue;
    }

    public boolean isDefaultValue() {
        return null != this.defaultValue ? this.defaultValue.equals(this.actualValue) : null == this.actualValue;
    }

    public T getValue() {
        return this.actualValue;
    }

    public String getName() {
        return this.name;
    }

    public ConfigParam<T> mandatory() {
        Checker.checkState(null == this.defaultValue, "mandatory items don't have default value");
        this.mandatory = true;
        return this;
    }

    public ConfigParam<T> reloadable() {
        this.isReloadable = true;
        return this;
    }

    public ConfigParam<T> confidential() {
        this.confidential = true;
        return this;
    }

    public ConfigParam<T> defaultValue(T value) {
        Checker.checkState(!this.mandatory, "mandatory items don't have default value");
        this.defaultValue = value;
        return this;
    }

    public ConfigParam<T> legacyName(String legacyName) {
        this.legacyName = legacyName;
        return this;
    }

    public ConfigParam<T> validate(ValidateFunction<T> validate) {
        this.validate = validate;
        return this;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public String getPrintValue() {
        String printValue;
        String string = printValue = null != this.actualValue ? this.actualValue.toString() : "null";
        if (this.confidential) {
            printValue = "** secret **";
        }
        String commentSring = "";
        if (this.mandatory || !this.isDefaultValue()) {
            commentSring = this.mandatory ? "(mandatory)" : String.format("(default = %s)", this.defaultValue);
        }
        return String.format("%s = %s %s", this.name, printValue, commentSring);
    }

    public static interface ValidateFunction<T> {
        public void validate(T var1);
    }

    public static interface ConvertFunction<T> {
        public T convert(String var1);
    }
}

