/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.conf;

import java.net.Proxy;
import org.nudge.probe.util.Checker;

public class ProxyConfig {
    private final Proxy.Type type;
    private final String host;
    private final int port;
    private final String login;
    private final String password;

    public ProxyConfig(Proxy.Type type, String host, int port, String login, String password) {
        Checker.checkArgument(null != type);
        if (host != null) {
            Checker.checkArgument(host.length() > 0);
            Checker.checkArgument(0 < port);
            if (null != login) {
                Checker.checkArgument(login.length() > 0);
            }
        }
        this.type = type;
        this.host = host;
        this.port = port;
        this.login = login;
        this.password = password;
    }

    public boolean useProxy() {
        return this.type != Proxy.Type.DIRECT && null != this.host;
    }

    public boolean useCredentials() {
        return null != this.login;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public Proxy.Type getType() {
        return this.type;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public static ProxyConfig direct() {
        return new ProxyConfig(Proxy.Type.DIRECT, null, 0, null, null);
    }
}

