/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.events;

import org.nudge.probe.events.EventContext;
import org.nudge.probe.events.EventHandler;
import org.nudge.probe.events.ExtendedCode;
import org.nudge.probe.events.InstrumentationPoint;
import org.nudge.probe.events.ProtocolFacade;

public class BaseEventHandler
implements EventHandler {
    @Override
    public void onEntering(EventContext context) {
    }

    @Override
    public void onExiting(EventContext context) {
        InstrumentationPoint ip = context.getInstrumentationPoint();
        if (ip.isDefineTx()) {
            this.exitAsTransaction(context);
        } else if (ip.isDefineOutput()) {
            this.exitAsOutput(context);
        }
    }

    protected void exitAsOutput(EventContext context) {
        InstrumentationPoint ip = context.getInstrumentationPoint();
        String code = ip.getAlias() != null ? ip.getAlias() : ip.getMethod();
        String layer = ip.getType();
        context.getProtocol().createOrUpdateLayerItem(ip.getStartTime(), layer, code, new ExtendedCode[0]).addCall(context);
    }

    protected void exitAsTransaction(EventContext context) {
        InstrumentationPoint ip = context.getInstrumentationPoint();
        ProtocolFacade protocol = context.getProtocol();
        protocol.setType(ip.getType()).setMethodname(ip.getMethod()).setCode(ip.getMethod()).setException(context.getThrownException()).setUpstreamToken(ip.getUpstreamToken());
        String alias = ip.getAlias();
        if (null != alias) {
            protocol.setCode(alias);
        }
    }
}

