/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.events;

import org.nudge.probe.events.EventHandler;
import org.nudge.probe.events.XApp;
import org.nudge.probe.events.XAppToken;
import org.nudge.probe.util.Checker;

public class InstrumentationPoint {
    private static final int INVALID_OUTPUT_CORRELATION_ID = -1;
    private final XApp xApps;
    private final String method;
    private final String type;
    private final InstrumentationPoint previous;
    private final long startTime;
    private State state;
    private SpanState spanState;
    private long endTime;
    private String alias;
    private int correlationId = -1;
    private String downstreamToken;
    private String upstreamToken;
    private EventHandler handler;

    public InstrumentationPoint(XApp xApps, InstrumentationPoint previous, String method, String type, long startTime) {
        Checker.checkArgument(null != xApps);
        this.xApps = xApps;
        Checker.checkArgument(null != method && method.length() > 0);
        this.method = method;
        Checker.checkArgument(null != type && type.length() > 0);
        this.type = type;
        Checker.checkArgument(0L <= startTime);
        this.previous = previous;
        this.startTime = startTime;
        if (null != previous) {
            switch (previous.state) {
                case BEFORE_TX: {
                    this.state = State.DEFINE_TX;
                    break;
                }
                case DEFINE_TX: 
                case WITHIN_TX: {
                    this.state = State.WITHIN_TX;
                    break;
                }
                case DEFINE_OUTPUT: 
                case BEYOND_OUTPUT: {
                    this.state = State.BEYOND_OUTPUT;
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown state : " + (Object)((Object)previous.state));
                }
            }
            this.upstreamToken = previous.upstreamToken;
        } else {
            this.state = State.DEFINE_TX;
        }
    }

    public String getMethod() {
        return this.method;
    }

    public String getType() {
        return this.type;
    }

    public InstrumentationPoint getPrevious() {
        return this.previous;
    }

    public boolean isDefineTx() {
        return this.state == State.DEFINE_TX;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        Checker.checkArgument(this.startTime <= endTime);
        Checker.checkState(0L == this.endTime);
        this.endTime = endTime;
    }

    public long getTotalTime() {
        Checker.checkState(this.endTime >= this.startTime);
        return this.endTime - this.startTime;
    }

    public int getDepth() {
        int i = 1;
        InstrumentationPoint ip = this.previous;
        while (null != ip) {
            ++i;
            ip = ip.previous;
        }
        return i;
    }

    public void setAlias(String alias) {
        Checker.checkState(null == this.alias);
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public String toString() {
        String previousString = null != this.previous ? " <- " + this.previous.toString() : "";
        return "{type='" + this.type + '\'' + ", method='" + this.method + "'}" + previousString;
    }

    public void makeDefineTx() {
        Checker.checkState(this.isInTx(), "can not take tx ownership when outside tx");
        if (this.state == State.DEFINE_TX) {
            return;
        }
        InstrumentationPoint ip = this.previous;
        while (null != ip && ip.isInTx()) {
            ip.state = State.BEFORE_TX;
            ip = ip.previous;
        }
        this.state = State.DEFINE_TX;
    }

    public void makeNotDefineTx() {
        Checker.checkState(this.state == State.DEFINE_TX, "moving before tx only allowed when defining transaction");
        this.state = State.BEFORE_TX;
    }

    public boolean isInTx() {
        return this.state.inTx();
    }

    public void makeDefineOutput(boolean generateXAppsToken) {
        if (generateXAppsToken) {
            XAppToken token = this.xApps.createToken();
            this.correlationId = token.getCorrelationId();
            this.downstreamToken = token.value();
        }
        this.doMakeDefineOutput();
    }

    public String getDownstreamToken() {
        if (this.state != State.BEYOND_OUTPUT && this.state != State.DEFINE_OUTPUT) {
            return null;
        }
        InstrumentationPoint ip = this;
        while (null != ip && ip.state != State.DEFINE_OUTPUT) {
            ip = ip.previous;
        }
        return null != ip ? ip.downstreamToken : null;
    }

    public void makeDefineOutput() {
        this.makeDefineOutput(false);
    }

    private boolean defineOrBeyondOuput() {
        return this.state == State.DEFINE_OUTPUT || this.state == State.BEYOND_OUTPUT;
    }

    public void makeNotOutput() {
        Checker.checkState(this.defineOrBeyondOuput());
        InstrumentationPoint ip = this;
        while (null != ip && ip.defineOrBeyondOuput()) {
            ip.state = State.WITHIN_TX;
            ip.correlationId = -1;
            ip.downstreamToken = null;
            ip = ip.previous;
        }
    }

    private void doMakeDefineOutput() {
        Checker.checkState(this.state.belowTx(), "output must be within transaction or beyond output");
        Checker.checkState(this.state != State.DEFINE_TX, "output must be beyond transaction bound");
        if (null != this.previous && this.previous.state.outputOrBeyond()) {
            this.previous.makeNotOutput();
        }
        this.state = State.DEFINE_OUTPUT;
    }

    public boolean isDefineOutput() {
        return this.state == State.DEFINE_OUTPUT;
    }

    public int getCorrelationId() {
        return this.correlationId;
    }

    public boolean isBeyondOutput() {
        return this.state == State.BEYOND_OUTPUT;
    }

    public State getState() {
        return this.state;
    }

    public void setUpstreamToken(String token) {
        if (null != token) {
            this.upstreamToken = token;
        }
    }

    public String getUpstreamToken() {
        InstrumentationPoint ip = this;
        while (null != ip && ip.state != State.DEFINE_TX) {
            ip = ip.previous;
        }
        return null == ip ? null : ip.upstreamToken;
    }

    public InstrumentationPoint getTxDefiner() {
        InstrumentationPoint ip = this;
        if (!this.isInTx()) {
            return null;
        }
        while (null != ip && !ip.isDefineTx()) {
            ip = ip.previous;
        }
        return ip;
    }

    public boolean isTxSpanStartOrContinue() {
        return this.spanState == SpanState.START_OR_CONTINUE;
    }

    public boolean isTxSpanEnd() {
        return this.spanState == SpanState.END;
    }

    public void makeTxSpanStartOrContinue() {
        this.setSpanState(SpanState.START_OR_CONTINUE);
    }

    public void makeTxSpanEnd() {
        this.setSpanState(SpanState.END);
    }

    private void setSpanState(SpanState spanState) {
        Checker.checkState(null != spanState);
        Checker.checkState(State.DEFINE_TX == this.state);
        this.spanState = spanState;
    }

    EventHandler getHandler() {
        return this.handler;
    }

    void setHandler(EventHandler handler) {
        this.handler = handler;
    }

    private static enum SpanState {
        START_OR_CONTINUE,
        END;

    }

    public static enum State {
        BEFORE_TX,
        DEFINE_TX,
        WITHIN_TX,
        DEFINE_OUTPUT,
        BEYOND_OUTPUT;


        public boolean inTx() {
            return this == DEFINE_TX || this == WITHIN_TX || this == DEFINE_OUTPUT;
        }

        public boolean outputOrBeyond() {
            return this == DEFINE_OUTPUT || this == BEYOND_OUTPUT;
        }

        public boolean belowTx() {
            return this == WITHIN_TX || this == DEFINE_OUTPUT || this == BEYOND_OUTPUT;
        }
    }
}

