/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.events;

import org.nudge.probe.util.Checker;

public class KeyValue<K, V> {
    private final K key;
    private final V value;

    public KeyValue(K key, V value) {
        Checker.checkArgument(null != key);
        this.key = key;
        this.value = value;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public String toString() {
        return "{key=" + this.key + ", value=" + this.value + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyValue)) {
            return false;
        }
        KeyValue keyValue = (KeyValue)o;
        if (!this.key.equals(keyValue.key)) {
            return false;
        }
        return !(this.value == null ? keyValue.value != null : !this.value.equals(keyValue.value));
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

