/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.events;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.nudge.probe.Configuration;
import org.nudge.probe.ProxyClassLoader;
import org.nudge.probe.events.LogEventBuilder;
import org.nudge.probe.events.NudgeStack;
import org.nudge.probe.events.SafeLogEventBuilder;
import org.nudge.probe.util.Checker;
import org.nudge.probe.util.ExceptionCounter;

public class LogEventBuilderFactory {
    private static final Map<ClassLoader, Constructor<?>> logEventConstructors = new HashMap();
    private static final String LOGGER_CLASS = "org.nudge.probe.events.LogEventBuilderImpl";
    private static final ExceptionCounter EXCEPTION_COUNTER = new ExceptionCounter();
    private static final LogEventBuilder NO_OP = new LogEventBuilder(){

        @Override
        public LogEventBuilder type(String type) {
            return this;
        }

        @Override
        public LogEventBuilder handler(String handlerClass) {
            return this;
        }

        @Override
        public LogEventBuilder methodTarget(Object target) {
            return this;
        }

        @Override
        public LogEventBuilder methodTargetType(Class<?> type) {
            return this;
        }

        @Override
        public LogEventBuilder method(String method) {
            return this;
        }

        @Override
        public LogEventBuilder methodParam(Object o) {
            return this;
        }

        @Override
        public LogEventBuilder methodContext(Object o) {
            return this;
        }

        @Override
        public LogEventBuilder thrownException(Throwable exception) {
            return this;
        }

        @Override
        public LogEventBuilder returnValue(Object returnValue) {
            return this;
        }

        @Override
        public void entering() {
        }

        @Override
        public void exiting() {
        }
    };

    private LogEventBuilderFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogEventBuilder newEventBuilder(ClassLoader cl, NudgeStack stack, Configuration config, boolean safe) {
        LogEventBuilder result;
        if (null == cl) {
            cl = ClassLoader.getSystemClassLoader();
        }
        Checker.checkArgument(null != cl);
        Constructor<?> constructor = logEventConstructors.get(cl);
        if (null == constructor) {
            ProxyClassLoader eventClassLoader = new ProxyClassLoader(cl);
            ProxyClassLoader.addClass(LOGGER_CLASS);
            try {
                Class<?> logEventClass = Class.forName(LOGGER_CLASS, false, eventClassLoader);
                constructor = logEventClass.getConstructor(NudgeStack.class, Configuration.class);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
            Map<ClassLoader, Constructor<?>> e = logEventConstructors;
            synchronized (e) {
                logEventConstructors.put(cl, constructor);
            }
        }
        try {
            result = (LogEventBuilder)constructor.newInstance(stack, config);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        if (safe) {
            result = new SafeLogEventBuilder(result, EXCEPTION_COUNTER);
        }
        return result;
    }

    public static LogEventBuilder noOpEventBuilder() {
        return NO_OP;
    }
}

