/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.events;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nudge.probe.Configuration;
import org.nudge.probe.ProxyClassLoader;
import org.nudge.probe.Util;
import org.nudge.probe.events.BaseEventHandler;
import org.nudge.probe.events.EventContext;
import org.nudge.probe.events.EventHandler;
import org.nudge.probe.events.InstrumentationPoint;
import org.nudge.probe.events.LogEventBuilder;
import org.nudge.probe.events.NudgeStack;
import org.nudge.probe.events.ProtocolFacade;
import org.nudge.probe.log.Level;
import org.nudge.probe.log.Logger;
import org.nudge.probe.util.Checker;

public class LogEventBuilderImpl
implements LogEventBuilder,
EventContext {
    private static final Logger log = Logger.getLogger(Configuration.DEFAULT_LOGGER_NAME);
    private final NudgeStack stack;
    private final Configuration config;
    private String type;
    private String method;
    private String alias;
    private String handlerClass;
    private List<Object> methodParams;
    private List<Object> methodContext;
    private Object methodTarget;
    private Class<?> methodTargetType;
    private Throwable thrownException;
    private Object returnValue;

    public LogEventBuilderImpl(NudgeStack stack, Configuration config) {
        Checker.checkArgument(null != stack);
        Checker.checkArgument(null != config);
        this.stack = stack;
        this.config = config;
        this.methodParams = new ArrayList<Object>();
        this.methodContext = new ArrayList<Object>();
    }

    @Override
    public LogEventBuilder handler(String handlerClass) {
        this.handlerClass = LogEventBuilderImpl.notEmptyValue(handlerClass);
        return this;
    }

    @Override
    public LogEventBuilder type(String type) {
        this.type = LogEventBuilderImpl.notEmptyValue(type);
        return this;
    }

    @Override
    public LogEventBuilder methodTargetType(Class<?> type) {
        Checker.checkArgument(null != type);
        this.methodTargetType = type;
        return this;
    }

    @Override
    public LogEventBuilder methodTarget(Object target) {
        Checker.checkArgument(null != target);
        this.methodTarget = target;
        return this.methodTargetType(target.getClass());
    }

    @Override
    public LogEventBuilder method(String method) {
        this.method = LogEventBuilderImpl.notEmptyValue(method);
        return this;
    }

    @Override
    public LogEventBuilder methodParam(Object o) {
        this.methodParams.add(o);
        return this;
    }

    @Override
    public LogEventBuilder methodContext(Object o) {
        this.methodContext.add(o);
        return this;
    }

    public LogEventBuilder alias(String alias) {
        if (null != alias && alias.length() > 0) {
            this.alias = alias;
        }
        return this;
    }

    @Override
    public LogEventBuilder thrownException(Throwable exception) {
        this.thrownException = exception;
        return this;
    }

    @Override
    public LogEventBuilder returnValue(Object returnValue) {
        this.returnValue = returnValue;
        return this;
    }

    private static String notEmptyValue(String value) {
        Checker.checkArgument(null != value && value.length() > 0);
        return value;
    }

    private void checkMandatoryFields() {
        Checker.checkState(null != this.method, "missing mandatory method");
        Checker.checkState(null != this.type, "missing mandatory type");
    }

    @Override
    public void entering() {
        this.checkMandatoryFields();
        Checker.checkState(null == this.returnValue, "entering event should not have a return value");
        Checker.checkArgument(null == this.thrownException, "entering event should not have a thrown exception");
        InstrumentationPoint ip = this.stack.pushInstrumentationPoint(this.method, this.type, System.currentTimeMillis());
        ip.setAlias(this.alias);
        try {
            EventHandler handler = this.getHandler(this.handlerClass);
            this.stack.setCurrentHandler(handler);
            handler.onEntering(this);
        }
        catch (Throwable throwable) {
            this.debugMessage("%s %s %s", this.type, ">>", this.method);
            this.stack.startCurrentInstrumentationPoint();
            throw throwable;
        }
        this.debugMessage("%s %s %s", this.type, ">>", this.method);
        this.stack.startCurrentInstrumentationPoint();
    }

    @Override
    public void exiting() {
        this.checkMandatoryFields();
        Checker.checkState(null == this.thrownException || null == this.returnValue, "thrown exception or return value expected, not both");
        Checker.checkState(null != this.handlerClass, "handler class required");
        InstrumentationPoint ip = this.stack.getCurrentInstrumentationPoint();
        this.debugMessage("%s %s %s", this.type, "<<", this.method);
        if (null == ip) {
            return;
        }
        ip.setEndTime(System.currentTimeMillis());
        try {
            EventHandler handler = this.stack.getCurrentHandler();
            if (null == handler) {
                handler = this.getHandler(this.handlerClass);
            }
            handler.onExiting(this);
        }
        finally {
            this.stack.popInstrumentationPoint();
        }
    }

    private EventHandler getHandler(String handlerClass) {
        EventHandler result;
        Checker.checkArgument(null != handlerClass, "handler class required");
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            result = (EventHandler)Class.forName(handlerClass, false, cl).newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        if (cl instanceof ProxyClassLoader) {
            for (Class<?> type = result.getClass(); null != type && type != Object.class && type != BaseEventHandler.class; type = type.getSuperclass()) {
                if (type.isInterface() || type.getClassLoader() == null || type.getClassLoader() instanceof ProxyClassLoader) continue;
                throw new IllegalStateException("handler class (or parent class) not loaded in proxy classloader : " + type);
            }
        }
        return result;
    }

    private void debugMessage(String template, Object ... params) {
        if (!log.isLoggable(Level.FINEST)) {
            return;
        }
        StringBuilder padding = new StringBuilder();
        InstrumentationPoint ip = this.stack.getCurrentInstrumentationPoint();
        if (null != ip) {
            for (int i = 0; i < ip.getDepth(); ++i) {
                padding.append(" ");
            }
        }
        log.finest(padding + template, params);
    }

    @Override
    public String getMethodFullName() {
        return this.method;
    }

    @Override
    public String getMethodName() {
        int parenThesis;
        int start;
        for (start = parenThesis = this.method.indexOf(40); 0 < start && this.method.charAt(start) != '.'; --start) {
        }
        return this.method.substring(start + 1, parenThesis);
    }

    @Override
    public String getClassName() {
        return this.methodTargetType.getSimpleName();
    }

    @Override
    public String getPackageName() {
        return this.methodTargetType.getPackage().getName();
    }

    @Override
    public <T extends Annotation> T getMethodAnnotation(Class<T> annotationType) {
        Method method = Util.getMethod(this.method, this.methodTargetType.getClassLoader());
        Checker.checkState(null != method);
        return method.getAnnotation(annotationType);
    }

    @Override
    public Annotation[] getMethodAnnotations() {
        Method method = Util.getMethod(this.method, this.methodTargetType.getClassLoader());
        Checker.checkState(null != method);
        return method.getDeclaredAnnotations();
    }

    @Override
    public <T> T getMethodParam(int i, Class<T> type) {
        Checker.checkArgument(0 <= i && i < this.methodParams.size());
        return type.cast(this.methodParams.get(i));
    }

    @Override
    public <T> T getFirstParamOfType(Class<T> type) {
        for (Object param : this.methodParams) {
            if (null == param || !type.isAssignableFrom(param.getClass())) continue;
            return type.cast(param);
        }
        return null;
    }

    @Override
    public <T> T getMethodContext(int i, Class<T> type) {
        Checker.checkArgument(0 <= i && i < this.methodContext.size());
        return type.cast(this.methodContext.get(i));
    }

    @Override
    public <T extends Annotation> T getParamAnnotation(int i, Class<T> annotationType) {
        Annotation[] paramAnnotations;
        Method method = Util.getMethod(this.method, this.methodTargetType.getClassLoader());
        if (null == method) {
            return null;
        }
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (Annotation paramAnnotation : paramAnnotations = parameterAnnotations[i]) {
            if (!paramAnnotation.annotationType().equals(annotationType)) continue;
            return (T)((Annotation)annotationType.cast(paramAnnotation));
        }
        return null;
    }

    @Override
    public List<Object> getMethodParams() {
        return Collections.unmodifiableList(this.methodParams);
    }

    @Override
    public <T> T getReturnValue(Class<T> type) {
        return type.cast(this.returnValue);
    }

    @Override
    public Throwable getThrownException() {
        return this.thrownException;
    }

    @Override
    public boolean hasThrownException() {
        return null != this.thrownException;
    }

    @Override
    public <T> T getMethodTarget(Class<T> type) {
        return type.cast(this.methodTarget);
    }

    @Override
    public InstrumentationPoint getInstrumentationPoint() {
        return this.stack.getCurrentInstrumentationPoint();
    }

    @Override
    public ProtocolFacade getProtocol() {
        ProtocolFacade protocol = this.stack.getCurrentProtocolFacade();
        Checker.checkState(null != protocol, "unable to get protocol, transaction probably not started, or called from EventHandler.entering(...)");
        return protocol;
    }

    @Override
    public Configuration getConfig() {
        return this.config;
    }
}

