/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.events;

import org.nudge.dependency.cnab.probe.RawDataProtocol;
import org.nudge.probe.TxUuid;
import org.nudge.probe.collector.Collector;
import org.nudge.probe.events.EventHandler;
import org.nudge.probe.events.InstrumentationPoint;
import org.nudge.probe.events.NudgeStack;
import org.nudge.probe.events.ProtocolFacade;
import org.nudge.probe.events.ProtocolFacadeImpl;
import org.nudge.probe.events.StackTracer;
import org.nudge.probe.events.XApp;
import org.nudge.probe.events.XAppToken;
import org.nudge.probe.util.Checker;

public class NudgeStackImpl
implements NudgeStack,
XApp {
    private final Collector collector;
    private final TxUuid uuid;
    private final StackTracer tracer;
    private InstrumentationPoint currentState;
    private RawDataProtocol.Transaction.Builder protobufTx;
    private ProtocolFacadeImpl protocolFacade;
    private int correlationId;
    private String spannedTxId = null;

    public NudgeStackImpl(Collector collector, TxUuid uuid) {
        this(collector, uuid, null);
    }

    public NudgeStackImpl(Collector collector, TxUuid uuid, StackTracer tracer) {
        Checker.checkArgument(null != collector);
        Checker.checkArgument(null != uuid);
        this.collector = collector;
        this.uuid = uuid;
        this.tracer = tracer;
        this.correlationId = 0;
    }

    boolean isEmpty() {
        return null == this.currentState && null == this.protobufTx && null == this.protocolFacade && 0 == this.correlationId && null == this.spannedTxId;
    }

    @Override
    public InstrumentationPoint getCurrentInstrumentationPoint() {
        return this.currentState;
    }

    @Override
    public RawDataProtocol.Transaction.Builder getCurrentProtobuf() {
        return this.protobufTx;
    }

    @Override
    public ProtocolFacade getCurrentProtocolFacade() {
        return this.protocolFacade;
    }

    @Override
    public boolean isInTransaction() {
        return null != this.currentState && this.currentState.isInTx();
    }

    @Override
    public InstrumentationPoint pushInstrumentationPoint(String method, String type, long startTime) {
        Checker.checkArgument(null != method);
        Checker.checkArgument(null != type && type.length() > 0);
        Checker.checkArgument(0L <= startTime);
        this.currentState = new InstrumentationPoint(this, this.currentState, method, type, startTime);
        if (null != this.tracer) {
            this.tracer.traceInstrumentedMethod(type, method);
        }
        return this.currentState;
    }

    @Override
    public void startCurrentInstrumentationPoint() {
        Checker.checkState(null != this.currentState, "cannot start IP on empty stack");
        if (this.currentState.isDefineTx()) {
            if (null != this.uuid.get()) {
                this.uuid.endMethod();
            }
            if (this.currentState.isTxSpanStartOrContinue() || this.currentState.isTxSpanEnd()) {
                if (null == this.spannedTxId) {
                    this.uuid.startMethod(this.currentState.getMethod());
                    this.spannedTxId = this.uuid.get();
                    this.initProtobuf();
                } else {
                    this.uuid.startMethod(this.currentState.getMethod(), this.spannedTxId);
                }
            } else {
                this.uuid.startMethod(this.currentState.getMethod());
                this.initProtobuf();
                this.spannedTxId = null;
            }
        }
    }

    private void initProtobuf() {
        this.protobufTx = RawDataProtocol.Transaction.newBuilder();
        this.protocolFacade = new ProtocolFacadeImpl(this.protobufTx);
    }

    @Override
    public InstrumentationPoint popInstrumentationPoint() {
        Checker.checkState(null != this.currentState, "pop called on empty stack");
        InstrumentationPoint result = this.currentState;
        this.currentState = this.currentState.getPrevious();
        if (result.isDefineTx()) {
            boolean isSpan;
            boolean doSend;
            Checker.checkState(null != this.protobufTx, "IP defines transaction but has not been properly started");
            for (String rum : this.protocolFacade.getEndUserTimings()) {
                this.collector.sendEndUserTiming(rum);
            }
            if (result.isTxSpanStartOrContinue()) {
                if (!this.protobufTx.hasUuid()) {
                    Checker.checkArgument(null != this.spannedTxId);
                    this.protobufTx.setUuid(this.spannedTxId);
                }
                doSend = false;
                isSpan = true;
            } else if (result.isTxSpanEnd()) {
                Checker.checkState(null != this.spannedTxId, "spanned end tx ID should be set");
                this.protobufTx.setEndTime(result.getEndTime());
                this.protobufTx.setUuid(this.spannedTxId);
                this.spannedTxId = null;
                doSend = true;
                isSpan = true;
            } else {
                this.protobufTx.setStartTime(result.getStartTime());
                this.protobufTx.setEndTime(result.getEndTime());
                this.protobufTx.setUuid(this.uuid.get());
                doSend = true;
                isSpan = false;
            }
            if (isSpan && !this.protobufTx.hasStartTime()) {
                this.protobufTx.setStartTime(result.getStartTime());
            }
            this.uuid.endMethod();
            if (doSend) {
                try {
                    this.collector.send(this.protobufTx);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                this.protobufTx = null;
                this.protocolFacade = null;
            }
        }
        return result;
    }

    @Override
    public void setCurrentHandler(EventHandler handler) {
        Checker.checkArgument(null != handler);
        Checker.checkState(null != this.currentState);
        this.currentState.setHandler(handler);
    }

    @Override
    public EventHandler getCurrentHandler() {
        Checker.checkState(null != this.currentState);
        return this.currentState.getHandler();
    }

    @Override
    public XAppToken createToken() {
        int token = this.correlationId++;
        return new XAppToken(this.collector.getServerId(), this.uuid.get(), token);
    }
}

