/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nudge.dependency.cnab.probe.RawDataProtocol;
import org.nudge.probe.events.EventContext;
import org.nudge.probe.events.ExtendedCode;
import org.nudge.probe.events.InstrumentationPoint;
import org.nudge.probe.events.ProtocolFacade;
import org.nudge.probe.events.XAppToken;
import org.nudge.probe.util.Checker;
import org.nudge.probe.util.RawdataUtil;

public class ProtocolFacadeImpl
implements ProtocolFacade {
    private final RawDataProtocol.Transaction.Builder tx;
    private final Set<String> requestHeaders;
    private final Set<String> responseHeaders;
    private final Map<String, LayerBuilderImpl> layers;
    private final Set<String> endUserTimings;
    private final Map<String, RawDataProtocol.KeyValue.Builder> extendedCodes;

    public ProtocolFacadeImpl(RawDataProtocol.Transaction.Builder tx) {
        Checker.checkArgument(null != tx);
        this.tx = tx;
        this.requestHeaders = new HashSet<String>();
        this.responseHeaders = new HashSet<String>();
        this.endUserTimings = new HashSet<String>();
        this.layers = new HashMap<String, LayerBuilderImpl>();
        this.extendedCodes = new HashMap<String, RawDataProtocol.KeyValue.Builder>();
    }

    @Override
    public ProtocolFacade setCode(String code) {
        if (!this.tx.hasCode()) {
            this.tx.setUrl(code);
            this.tx.setCode(code);
        }
        return this;
    }

    @Override
    public ProtocolFacade addExtendedCode(ExtendedCode extendedCode) {
        return this.addExtendedCode((String)extendedCode.getKey(), (String)extendedCode.getValue());
    }

    private ProtocolFacade addExtendedCode(String key, String value) {
        if (null == key || null == value) {
            return this;
        }
        RawDataProtocol.KeyValue.Builder builder = this.extendedCodes.get(key);
        if (null == builder) {
            builder = this.tx.addExtendedCodesBuilder().setKey(key);
            this.extendedCodes.put(key, builder);
        }
        builder.setValue(value);
        if (key.equals("http.request.header.User-Agent")) {
            this.tx.setUserAgent(value);
        } else if (key.startsWith("http.request.header")) {
            String header = key.substring("http.request.header".length() + 1);
            if (!this.requestHeaders.contains(header)) {
                this.tx.addReqHeadersBuilder().setKey(header).setValue(value);
                this.requestHeaders.add(header);
            }
        } else if (key.startsWith("http.response.header")) {
            String header = key.substring("http.response.header".length() + 1);
            if (!this.responseHeaders.contains(header)) {
                this.tx.addHeadersBuilder().setKey(header).setValue(value);
                this.responseHeaders.add(header);
            }
        } else if (key.startsWith("http.param")) {
            String param = key.substring("http.param".length() + 1);
            this.tx.addParamsBuilder().setKey(param).setValue(value);
        } else if (key.equals("http.session")) {
            this.tx.setSessionId(value);
        } else if (key.equals("http.status")) {
            this.tx.setRespStatusCode(Integer.valueOf(value));
        } else if (key.equals("http.method")) {
            RawDataProtocol.Transaction.ReqMethod reqMethod = null;
            try {
                reqMethod = RawDataProtocol.Transaction.ReqMethod.valueOf(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (null != reqMethod) {
                this.tx.setReqMethod(reqMethod);
            }
        } else if (key.equals("http.clientip")) {
            this.tx.setUserIp(value);
        }
        return this;
    }

    @Override
    public ProtocolFacade setEndUserTiming(String userTiming) {
        if (null != userTiming) {
            this.endUserTimings.add(userTiming);
        }
        return this;
    }

    @Override
    public ProtocolFacade setMethodname(String name) {
        if (null != name) {
            this.tx.setMethodName(name);
        }
        return this;
    }

    @Override
    public ProtocolFacade setException(Throwable exception) {
        if (null != exception) {
            this.tx.setStatus(RawDataProtocol.Transaction.Status.KO);
            RawdataUtil.writeException(exception, this.tx);
        }
        return this;
    }

    @Override
    public ProtocolFacade setError(String msg, long time) {
        this.tx.setStatus(RawDataProtocol.Transaction.Status.KO);
        if (null != msg) {
            RawDataProtocol.Error.Builder error = RawDataProtocol.Error.newBuilder().setCode(msg).setStartTime(time);
            this.tx.addErrors(error);
        }
        return this;
    }

    @Override
    public ProtocolFacade setType(String type) {
        if (!this.tx.hasTxType()) {
            this.tx.setTxType(type);
        }
        return this;
    }

    @Override
    public ProtocolFacade.LayerBuilder createOrUpdateLayerItem(long startTime, String layer, String code, ExtendedCode ... extendedCodes) {
        return this.internalCreateOrUpdateLayer(layer).getOrCreateLayerItem(startTime, code, extendedCodes);
    }

    public Set<String> getEndUserTimings() {
        return this.endUserTimings;
    }

    @Override
    public ProtocolFacade.LayerBuilder createOrUpdateLayer(String layer) {
        return this.internalCreateOrUpdateLayer(layer);
    }

    @Override
    public ProtocolFacade setUpstreamToken(String nudgeToken) {
        if (null != nudgeToken) {
            XAppToken token = XAppToken.parse(nudgeToken);
            this.tx.setUpstreamAgentId(token.getAgentId());
            this.tx.setUpstreamTxId(token.getTxId());
            this.tx.setUpstreamCorrelationId(token.getCorrelationId());
        }
        return this;
    }

    private LayerBuilderImpl internalCreateOrUpdateLayer(String layer) {
        Checker.checkArgument(null != layer && layer.length() > 0);
        LayerBuilderImpl result = this.layers.get(layer);
        if (null == result) {
            result = new LayerBuilderImpl(this.tx.addLayersBuilder().setLayerName(layer));
            this.layers.put(layer, result);
        }
        return result;
    }

    private static class LayerBuilderImpl
    implements ProtocolFacade.LayerBuilder {
        private final RawDataProtocol.Layer.Builder builder;
        private final Map<LayerCallKey, LayerItemBuilderImpl> calls;

        public LayerBuilderImpl(RawDataProtocol.Layer.Builder builder) {
            this.builder = builder;
            this.calls = new HashMap<LayerCallKey, LayerItemBuilderImpl>();
        }

        @Override
        public ProtocolFacade.LayerBuilder addCall(long time, boolean isError) {
            Checker.checkArgument(time >= 0L);
            this.builder.setCount(this.builder.getCount() + 1L);
            this.builder.setTime(this.builder.getTime() + time);
            if (isError) {
                this.builder.setErrors(this.builder.getErrors() + 1L);
            }
            return this;
        }

        @Override
        public ProtocolFacade.LayerBuilder addCall(EventContext c) {
            return this.addCall(c.getInstrumentationPoint().getTotalTime(), c.hasThrownException());
        }

        public ProtocolFacade.LayerBuilder getOrCreateLayerItem(long startTime, String code, ExtendedCode ... extendedCodes) {
            long timestamp = startTime - startTime % 60000L;
            LayerCallKey key = new LayerCallKey(timestamp, code, extendedCodes);
            LayerItemBuilderImpl call = this.calls.get(key);
            if (null == call) {
                RawDataProtocol.LayerDetail.Builder callBuilder = this.builder.addCallsBuilder().setCode(code).setTimestamp(timestamp);
                for (ExtendedCode ec : key.getExtendedCodes()) {
                    callBuilder.addExtCodesBuilder().setKey((String)ec.getKey()).setValue((String)ec.getValue());
                }
                call = new LayerItemBuilderImpl(callBuilder, this);
                this.calls.put(key, call);
            }
            return call;
        }
    }

    static class LayerCallKey {
        private final long timestamp;
        private final String code;
        private final List<ExtendedCode> extendedCodes;

        LayerCallKey(long timestamp, String code, ExtendedCode ... extendedCodes) {
            Checker.checkArgument(null != code && code.length() > 0);
            List validList = Collections.emptyList();
            if (extendedCodes.length > 0) {
                validList = new ArrayList(extendedCodes.length);
            }
            for (ExtendedCode ec : extendedCodes) {
                if (!ec.isValid()) continue;
                validList.add(ec);
            }
            this.timestamp = timestamp;
            this.code = code;
            this.extendedCodes = validList;
        }

        public String getCode() {
            return this.code;
        }

        public List<ExtendedCode> getExtendedCodes() {
            return this.extendedCodes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LayerCallKey that = (LayerCallKey)o;
            if (this.timestamp != that.timestamp) {
                return false;
            }
            if (!this.code.equals(that.code)) {
                return false;
            }
            if (this.extendedCodes.size() != that.extendedCodes.size()) {
                return false;
            }
            for (int i = 0; i < this.extendedCodes.size(); ++i) {
                if (this.extendedCodes.get(i).equals(that.extendedCodes.get(i))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = (int)(this.timestamp ^ this.timestamp >>> 32);
            result = 31 * result + this.code.hashCode();
            for (ExtendedCode ec : this.extendedCodes) {
                result = 31 * result + ec.hashCode();
            }
            return result;
        }

        public String toString() {
            return "LayerCallKey{timestamp=" + this.timestamp + ", code='" + this.code + '\'' + ", extendedCodes=" + this.extendedCodes + '}';
        }
    }

    private static class LayerItemBuilderImpl
    implements ProtocolFacade.LayerBuilder {
        private final RawDataProtocol.LayerDetail.Builder builder;
        private final ProtocolFacade.LayerBuilder layer;

        public LayerItemBuilderImpl(RawDataProtocol.LayerDetail.Builder builder, ProtocolFacade.LayerBuilder layer) {
            this.builder = builder;
            this.layer = layer;
        }

        @Override
        public ProtocolFacade.LayerBuilder addCall(long time, boolean isError) {
            Checker.checkArgument(time >= 0L);
            this.builder.setCount(this.builder.getCount() + 1L);
            this.builder.setTime(this.builder.getTime() + time);
            if (isError) {
                this.builder.setErrors(this.builder.getErrors() + 1L);
            }
            this.layer.addCall(time, isError);
            this.builder.addValues(time);
            return this;
        }

        @Override
        public ProtocolFacade.LayerBuilder addCall(EventContext c) {
            InstrumentationPoint ip = c.getInstrumentationPoint();
            this.addCall(ip.getTotalTime(), c.hasThrownException());
            int correlationId = ip.getCorrelationId();
            if (correlationId >= 0) {
                this.builder.addCorrelationIds(ip.getCorrelationId());
            }
            return this;
        }
    }
}

