/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.events;

import org.nudge.probe.Configuration;
import org.nudge.probe.events.LogEventBuilder;
import org.nudge.probe.log.Logger;
import org.nudge.probe.util.Checker;
import org.nudge.probe.util.ExceptionCounter;

public class SafeLogEventBuilder
implements LogEventBuilder {
    private static final Logger log = Logger.getLogger(Configuration.DEFAULT_LOGGER_NAME);
    private final LogEventBuilder leb;
    private final ExceptionCounter exceptionCounter;

    public SafeLogEventBuilder(LogEventBuilder target, ExceptionCounter exceptionCounter) {
        Checker.checkArgument(null != target);
        Checker.checkArgument(null != exceptionCounter);
        this.leb = target;
        this.exceptionCounter = exceptionCounter;
    }

    @Override
    public LogEventBuilder type(String type) {
        try {
            this.leb.type(type);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
        return this;
    }

    @Override
    public LogEventBuilder handler(String handlerClass) {
        try {
            this.leb.handler(handlerClass);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
        return this;
    }

    @Override
    public LogEventBuilder methodTarget(Object target) {
        try {
            this.leb.methodTarget(target);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
        return this;
    }

    @Override
    public LogEventBuilder methodTargetType(Class<?> type) {
        try {
            this.leb.methodTargetType(type);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
        return this;
    }

    @Override
    public LogEventBuilder method(String method) {
        try {
            this.leb.method(method);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
        return this;
    }

    @Override
    public LogEventBuilder methodParam(Object o) {
        try {
            this.leb.methodParam(o);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
        return this;
    }

    @Override
    public LogEventBuilder methodContext(Object o) {
        try {
            this.leb.methodContext(o);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
        return this;
    }

    @Override
    public LogEventBuilder thrownException(Throwable exception) {
        try {
            this.leb.thrownException(exception);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
        return this;
    }

    @Override
    public LogEventBuilder returnValue(Object returnValue) {
        try {
            this.leb.returnValue(returnValue);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
        return this;
    }

    @Override
    public void entering() {
        try {
            this.leb.entering();
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public void exiting() {
        try {
            this.leb.exiting();
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    private void handleException(Throwable t) {
        long occurences = this.exceptionCounter.tick(t.getClass());
        if (occurences > 0L) {
            log.severe(t, "probe internal error (x%d)", occurences);
        }
    }
}

