/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.events;

import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import org.nudge.probe.Configuration;
import org.nudge.probe.log.Logger;
import org.nudge.probe.util.Checker;

public class StackTracer {
    private static final Logger log = Logger.getLogger(Configuration.DEFAULT_LOGGER_NAME);
    private final Configuration config;
    private final Map<String, Object> set;
    private static final Object ITEM = new Object();

    public StackTracer(Configuration config) {
        this.config = config;
        this.set = new WeakHashMap<String, Object>();
    }

    public void traceInstrumentedMethod(String type, String method) {
        Checker.checkArgument(null != type);
        Checker.checkArgument(null != method);
        if (!this.config.traceInstrumentedCodeStackTraces()) {
            return;
        }
        if (null != this.set.put(StackTracer.getKey(type, method), ITEM)) {
            return;
        }
        log.severe(new Exception("Stack Trace"), "instrumentation point %s %s reached", type, method);
    }

    private static String getKey(String type, String method) {
        return String.format("%s|%s|%d", type, method, Arrays.hashCode(Thread.currentThread().getStackTrace()));
    }
}

