/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.events;

import org.nudge.probe.Util;

public class XAppToken {
    private final int correlationId;
    private final String agentId;
    private final String txId;

    public XAppToken(String agentId, String txId, int correlationId) {
        this.agentId = agentId;
        this.txId = txId;
        this.correlationId = correlationId;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getTxId() {
        return this.txId;
    }

    public int getCorrelationId() {
        return this.correlationId;
    }

    public String value() {
        return String.format("%s,%s,%d", this.agentId, this.txId, this.correlationId);
    }

    public String toString() {
        return this.value();
    }

    public static XAppToken parse(String s) {
        String[] parts = s.split(",");
        if (parts.length != 3 || !Util.isNumeric(parts[2])) {
            throw new IllegalArgumentException("invalid x-app token " + s);
        }
        return new XAppToken(parts[0], parts[1], Integer.parseInt(parts[2]));
    }
}

