/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.jmx;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import org.nudge.dependency.cnab.probe.RawDataProtocol;
import org.nudge.probe.log.Logger;

public class GcActivityBuilder {
    private static final Logger LOG = Logger.getLogger(GcActivityBuilder.class.getName());
    private long start = 0L;
    private long end = 0L;
    private long oldCount = 0L;
    private long oldTime = 0L;

    public RawDataProtocol.GcActivity getBuffer() {
        this.start = this.start == 0L ? System.currentTimeMillis() : this.end;
        RawDataProtocol.GcActivity.Builder builder = RawDataProtocol.GcActivity.newBuilder();
        builder.setStartTime(this.start);
        long newCount = 0L;
        long newTime = 0L;
        List<GarbageCollectorMXBean> beans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean bean : beans) {
            newCount += bean.getCollectionCount();
            newTime += bean.getCollectionTime();
        }
        builder.setCollectionCount((int)(newCount - this.oldCount));
        this.oldCount = newCount;
        builder.setCollectionTime((int)(newTime - this.oldTime));
        this.oldTime = newTime;
        this.end = System.currentTimeMillis();
        builder.setEndTime(this.end);
        return builder.build();
    }
}

